/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.ArrayList;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.EcmaError;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.IdFunctionObject;
import org.htmlunit.corejs.javascript.IdScriptableObject;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.Undefined;

final class NativeReflect
extends IdScriptableObject {
    private static final long serialVersionUID = 2920773905356325445L;
    private static final Object REFLECT_TAG = "Reflect";
    private static final int Id_toSource = 1;
    private static final int Id_apply = 2;
    private static final int Id_construct = 3;
    private static final int Id_defineProperty = 4;
    private static final int Id_deleteProperty = 5;
    private static final int Id_get = 6;
    private static final int Id_getOwnPropertyDescriptor = 7;
    private static final int Id_getPrototypeOf = 8;
    private static final int Id_has = 9;
    private static final int Id_isExtensible = 10;
    private static final int Id_ownKeys = 11;
    private static final int Id_preventExtensions = 12;
    private static final int Id_set = 13;
    private static final int Id_setPrototypeOf = 14;
    private static final int LAST_METHOD_ID = 14;

    static void init(Scriptable scope, boolean sealed) {
        NativeReflect obj = new NativeReflect();
        obj.activatePrototypeMap(14);
        obj.setPrototype(NativeReflect.getObjectPrototype(scope));
        obj.setParentScope(scope);
        if (sealed) {
            obj.sealObject();
        }
        ScriptableObject.defineProperty(scope, "Reflect", obj, 2);
    }

    private NativeReflect() {
    }

    @Override
    public String getClassName() {
        return "Reflect";
    }

    @Override
    protected void initPrototypeId(int id) {
        if (id <= 14) {
            String name;
            int arity;
            switch (id) {
                case 1: {
                    arity = 0;
                    name = "toSource";
                    break;
                }
                case 2: {
                    arity = 3;
                    name = "apply";
                    break;
                }
                case 3: {
                    arity = 2;
                    name = "construct";
                    break;
                }
                case 4: {
                    arity = 3;
                    name = "defineProperty";
                    break;
                }
                case 5: {
                    arity = 2;
                    name = "deleteProperty";
                    break;
                }
                case 6: {
                    arity = 2;
                    name = "get";
                    break;
                }
                case 7: {
                    arity = 2;
                    name = "getOwnPropertyDescriptor";
                    break;
                }
                case 8: {
                    arity = 1;
                    name = "getPrototypeOf";
                    break;
                }
                case 9: {
                    arity = 2;
                    name = "has";
                    break;
                }
                case 10: {
                    arity = 1;
                    name = "isExtensible";
                    break;
                }
                case 11: {
                    arity = 1;
                    name = "ownKeys";
                    break;
                }
                case 12: {
                    arity = 1;
                    name = "preventExtensions";
                    break;
                }
                case 13: {
                    arity = 3;
                    name = "set";
                    break;
                }
                case 14: {
                    arity = 2;
                    name = "setPrototypeOf";
                    break;
                }
                default: {
                    throw new IllegalStateException(String.valueOf(id));
                }
            }
            this.initPrototypeMethod(REFLECT_TAG, id, name, arity);
        }
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(REFLECT_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int methodId = f.methodId();
        switch (methodId) {
            case 1: {
                return "Reflect";
            }
            case 2: {
                return NativeReflect.js_apply(cx, scope, args);
            }
            case 3: {
                return NativeReflect.js_construct(cx, scope, args);
            }
            case 4: {
                return NativeReflect.js_defineProperty(cx, args);
            }
            case 5: {
                return NativeReflect.js_deleteProperty(args);
            }
            case 6: {
                return NativeReflect.js_get(args);
            }
            case 7: {
                return NativeReflect.js_getOwnPropertyDescriptor(cx, args);
            }
            case 8: {
                return NativeReflect.js_getPrototypeOf(args);
            }
            case 9: {
                return NativeReflect.js_has(args);
            }
            case 10: {
                return NativeReflect.js_isExtensible(args);
            }
            case 11: {
                return NativeReflect.js_ownKeys(cx, scope, args);
            }
            case 12: {
                return NativeReflect.js_preventExtensions(args);
            }
            case 13: {
                return NativeReflect.js_set(args);
            }
            case 14: {
                return NativeReflect.js_setPrototypeOf(args);
            }
        }
        throw new IllegalStateException(String.valueOf(methodId));
    }

    private static Object js_apply(Context cx, Scriptable scope, Object[] args) {
        if (args.length < 3) {
            throw ScriptRuntime.typeErrorById("msg.method.missing.parameter", "Reflect.apply", "3", Integer.toString(args.length));
        }
        Scriptable callable = ScriptableObject.ensureScriptable(args[0]);
        Scriptable thisObj = Undefined.SCRIPTABLE_UNDEFINED;
        if (args[1] instanceof Scriptable) {
            thisObj = (Scriptable)args[1];
        }
        if (ScriptRuntime.isSymbol(args[2])) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(args[2]));
        }
        ScriptableObject argumentsList = ScriptableObject.ensureScriptableObject(args[2]);
        return ScriptRuntime.applyOrCall(true, cx, scope, callable, new Object[]{thisObj, argumentsList});
    }

    private static Scriptable js_construct(Context cx, Scriptable scope, Object[] args) {
        if (args.length < 1) {
            throw ScriptRuntime.typeErrorById("msg.method.missing.parameter", "Reflect.construct", "3", Integer.toString(args.length));
        }
        if (!(args[0] instanceof Function)) {
            throw ScriptRuntime.typeErrorById("msg.not.ctor", ScriptRuntime.typeof(args[0]));
        }
        Function ctor = (Function)args[0];
        if (args.length < 2) {
            return ctor.construct(cx, scope, ScriptRuntime.emptyArgs);
        }
        Object[] callArgs = ScriptRuntime.getApplyArguments(cx, args[1]);
        return ctor.construct(cx, scope, callArgs);
    }

    private static boolean js_defineProperty(Context cx, Object[] args) {
        if (args.length < 3) {
            throw ScriptRuntime.typeErrorById("msg.method.missing.parameter", "Reflect.defineProperty", "3", Integer.toString(args.length));
        }
        ScriptableObject obj = NativeReflect.checkTarget(args);
        ScriptableObject desc = ScriptableObject.ensureScriptableObject(args[2]);
        try {
            obj.defineOwnProperty(cx, args[1], desc);
            return true;
        }
        catch (EcmaError e) {
            return false;
        }
    }

    private static boolean js_deleteProperty(Object[] args) {
        ScriptableObject obj = NativeReflect.checkTarget(args);
        if (args.length > 1) {
            if (ScriptRuntime.isSymbol(args[1])) {
                return ScriptableObject.deleteProperty((Scriptable)obj, (Symbol)args[1]);
            }
            return ScriptableObject.deleteProperty((Scriptable)obj, ScriptRuntime.toString(args[1]));
        }
        return false;
    }

    private static Object js_get(Object[] args) {
        ScriptableObject obj = NativeReflect.checkTarget(args);
        if (args.length > 1) {
            if (ScriptRuntime.isSymbol(args[1])) {
                Object prop = ScriptableObject.getProperty((Scriptable)obj, (Symbol)args[1]);
                return prop == Scriptable.NOT_FOUND ? Undefined.SCRIPTABLE_UNDEFINED : prop;
            }
            if (args[1] instanceof Double) {
                Object prop = ScriptableObject.getProperty((Scriptable)obj, ScriptRuntime.toIndex(args[1]));
                return prop == Scriptable.NOT_FOUND ? Undefined.SCRIPTABLE_UNDEFINED : prop;
            }
            Object prop = ScriptableObject.getProperty((Scriptable)obj, ScriptRuntime.toString(args[1]));
            return prop == Scriptable.NOT_FOUND ? Undefined.SCRIPTABLE_UNDEFINED : prop;
        }
        return Undefined.SCRIPTABLE_UNDEFINED;
    }

    private static Scriptable js_getOwnPropertyDescriptor(Context cx, Object[] args) {
        ScriptableObject obj = NativeReflect.checkTarget(args);
        if (args.length > 1) {
            if (ScriptRuntime.isSymbol(args[1])) {
                ScriptableObject desc = obj.getOwnPropertyDescriptor(cx, args[1]);
                return desc == null ? Undefined.SCRIPTABLE_UNDEFINED : desc;
            }
            ScriptableObject desc = obj.getOwnPropertyDescriptor(cx, ScriptRuntime.toString(args[1]));
            return desc == null ? Undefined.SCRIPTABLE_UNDEFINED : desc;
        }
        return Undefined.SCRIPTABLE_UNDEFINED;
    }

    private static Scriptable js_getPrototypeOf(Object[] args) {
        ScriptableObject obj = NativeReflect.checkTarget(args);
        return obj.getPrototype();
    }

    private static boolean js_has(Object[] args) {
        ScriptableObject obj = NativeReflect.checkTarget(args);
        if (args.length > 1) {
            if (ScriptRuntime.isSymbol(args[1])) {
                return ScriptableObject.hasProperty((Scriptable)obj, (Symbol)args[1]);
            }
            return ScriptableObject.hasProperty((Scriptable)obj, ScriptRuntime.toString(args[1]));
        }
        return false;
    }

    private static boolean js_isExtensible(Object[] args) {
        ScriptableObject obj = NativeReflect.checkTarget(args);
        return obj.isExtensible();
    }

    private static Scriptable js_ownKeys(Context cx, Scriptable scope, Object[] args) {
        ScriptableObject obj = NativeReflect.checkTarget(args);
        ArrayList<String> strings = new ArrayList<String>();
        ArrayList<Object> symbols = new ArrayList<Object>();
        for (Object o : obj.getIds(true, true)) {
            if (o instanceof Symbol) {
                symbols.add(o);
                continue;
            }
            strings.add(ScriptRuntime.toString(o));
        }
        Object[] keys = new Object[strings.size() + symbols.size()];
        System.arraycopy(strings.toArray(), 0, keys, 0, strings.size());
        System.arraycopy(symbols.toArray(), 0, keys, strings.size(), symbols.size());
        return cx.newArray(scope, keys);
    }

    private static boolean js_preventExtensions(Object[] args) {
        ScriptableObject obj = NativeReflect.checkTarget(args);
        obj.preventExtensions();
        return true;
    }

    private static boolean js_set(Object[] args) {
        ScriptableObject obj = NativeReflect.checkTarget(args);
        if (args.length > 1) {
            if (ScriptRuntime.isSymbol(args[1])) {
                obj.put((Symbol)args[1], (Scriptable)obj, args[2]);
                return true;
            }
            if (args[1] instanceof Double) {
                obj.put(ScriptRuntime.toIndex(args[1]), (Scriptable)obj, args[2]);
                return true;
            }
            obj.put(ScriptRuntime.toString(args[1]), (Scriptable)obj, args[2]);
            return true;
        }
        return false;
    }

    private static boolean js_setPrototypeOf(Object[] args) {
        if (args.length < 2) {
            throw ScriptRuntime.typeErrorById("msg.method.missing.parameter", "Reflect.js_setPrototypeOf", "2", Integer.toString(args.length));
        }
        ScriptableObject obj = NativeReflect.checkTarget(args);
        if (obj.getPrototype() == args[1]) {
            return true;
        }
        if (!obj.isExtensible()) {
            return false;
        }
        if (args[1] == null) {
            obj.setPrototype(null);
            return true;
        }
        if (ScriptRuntime.isSymbol(args[1])) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(args[0]));
        }
        ScriptableObject proto = ScriptableObject.ensureScriptableObject(args[1]);
        if (obj.getPrototype() == proto) {
            return true;
        }
        for (Scriptable p = proto; p != null; p = p.getPrototype()) {
            if (obj != p) continue;
            return false;
        }
        obj.setPrototype(proto);
        return true;
    }

    private static ScriptableObject checkTarget(Object[] args) {
        if (args.length == 0 || args[0] == null || args[0] == Undefined.instance) {
            Object argument = args.length == 0 ? Undefined.instance : args[0];
            throw ScriptRuntime.typeErrorById("msg.no.properties", ScriptRuntime.toString(argument));
        }
        if (ScriptRuntime.isSymbol(args[0])) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(args[0]));
        }
        return ScriptableObject.ensureScriptableObject(args[0]);
    }

    @Override
    protected int findPrototypeId(String s) {
        int id;
        switch (s) {
            case "toSource": {
                id = 1;
                break;
            }
            case "apply": {
                id = 2;
                break;
            }
            case "construct": {
                id = 3;
                break;
            }
            case "defineProperty": {
                id = 4;
                break;
            }
            case "deleteProperty": {
                id = 5;
                break;
            }
            case "get": {
                id = 6;
                break;
            }
            case "getOwnPropertyDescriptor": {
                id = 7;
                break;
            }
            case "getPrototypeOf": {
                id = 8;
                break;
            }
            case "has": {
                id = 9;
                break;
            }
            case "isExtensible": {
                id = 10;
                break;
            }
            case "ownKeys": {
                id = 11;
                break;
            }
            case "preventExtensions": {
                id = 12;
                break;
            }
            case "set": {
                id = 13;
                break;
            }
            case "setPrototypeOf": {
                id = 14;
                break;
            }
            default: {
                id = 0;
            }
        }
        return id;
    }
}

