/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.expression.xpath;

import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.expression.ExpressionSupport;
import org.apache.commons.jelly.impl.TagScript;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hudsonci.xpath.XNamespaceContext;
import org.hudsonci.xpath.XPath;
import org.hudsonci.xpath.XPathException;
import org.hudsonci.xpath.XVariableContext;

public class XPathExpression
extends ExpressionSupport
implements XVariableContext {
    private Log log = LogFactory.getLog(XPathExpression.class);
    private String text;
    private Expression xpathExpr;
    private JellyContext context;
    private Map uris;

    public XPathExpression() {
    }

    public XPathExpression(String text, Expression xpathExpr, TagScript tagScript) {
        this.text = text;
        this.xpathExpr = xpathExpr;
        Map namespaceContext = tagScript.getNamespaceContext();
        this.uris = this.createUriMap(namespaceContext);
    }

    public String toString() {
        return this.getExpressionText();
    }

    public String getExpressionText() {
        return this.text;
    }

    public Object evaluate(JellyContext context) {
        this.context = context;
        try {
            XPath xpath = new XPath(this.xpathExpr.evaluateAsString(context));
            xpath.setVariableContext((XVariableContext)this);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting the namespace context to be: " + this.uris));
            }
            xpath.setNamespaceContext(new XNamespaceContext(this.uris));
            return xpath;
        }
        catch (XPathException e) {
            this.log.error((Object)"Error constructing xpath", (Throwable)e);
            return null;
        }
    }

    public Object getVariableValue(String namespaceURI, String prefix, String localName) {
        Object value = this.context.getVariable(localName);
        return value;
    }

    protected Map createUriMap(Map namespaceContext) {
        Hashtable uris = new Hashtable(namespaceContext.size());
        for (Map.Entry entry : namespaceContext.entrySet()) {
            String prefix = (String)entry.getKey();
            if (prefix == null || prefix.length() == 0) continue;
            uris.put(prefix, entry.getValue());
        }
        return uris;
    }
}

