
/*
 * Copyright 2004-2012 ICEsoft Technologies Canada Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package com.icesoft.faces.component;

import java.util.ArrayList;
import java.util.List;

import com.icesoft.faces.renderkit.dom_html_basic.HTML;

/**
 *<p>Auto-generated Component Base class. Generated on Aug 13, 2008
 *Do <strong>NOT</strong> modify; all changes
 *<strong>will</strong> be lost!</p>
 * This class helps with Renderer to get component
 * and the passthrough attributes associated with them.
 * 
 */
public class ExtendedAttributeConstants {

    public final static int ICE_EFFECT = 0;

    public final static int ICE_PANELBORDER = 1;

    public final static int ICE_COLUMN = 2;

    public final static int ICE_COLUMNGROUP = 3;

    public final static int ICE_COLUMNS = 4;

    public final static int ICE_DATAPAGINATOR = 5;

    public final static int ICE_INPUTFILE = 6;

    public final static int ICE_GMAP = 7;

    public final static int ICE_GMAPCONTROL = 8;

    public final static int ICE_GMAPDIRECTION = 9;

    public final static int ICE_GMAPGEOXML = 10;

    public final static int ICE_GMAPLATLNG = 11;

    public final static int ICE_GMAPLATLNGS = 12;

    public final static int ICE_GMAPMARKER = 13;

    public final static int ICE_HEADERROW = 14;

    public final static int ICE_CHECKBOX = 15;

    public final static int ICE_COMMANDBUTTON = 16;

    public final static int ICE_COMMANDLINK = 17;

    public final static int ICE_DATATABLE = 18;

    public final static int ICE_FORM = 19;

    public final static int ICE_GRAPHICIMAGE = 20;

    public final static int ICE_INPUTHIDDEN = 21;

    public final static int ICE_INPUTSECRET = 22;

    public final static int ICE_INPUTTEXT = 23;

    public final static int ICE_INPUTTEXTAREA = 24;

    public final static int ICE_MESSAGE = 25;

    public final static int ICE_MESSAGES = 26;

    public final static int ICE_OUTPUTFORMAT = 27;

    public final static int ICE_OUTPUTLABEL = 28;

    public final static int ICE_OUTPUTLINK = 29;

    public final static int ICE_OUTPUTTEXT = 30;

    public final static int ICE_PANELGRID = 31;

    public final static int ICE_PANELGROUP = 32;

    public final static int ICE_RADIO = 33;

    public final static int ICE_SELECTBOOLEANCHECKBOX = 34;

    public final static int ICE_SELECTMANYCHECKBOX = 35;

    public final static int ICE_SELECTMANYLISTBOX = 36;

    public final static int ICE_SELECTMANYMENU = 37;

    public final static int ICE_SELECTONELISTBOX = 38;

    public final static int ICE_SELECTONEMENU = 39;

    public final static int ICE_SELECTONERADIO = 40;

    public final static int ICE_INPUTRICHTEXT = 41;

    public final static int ICE_MENUBAR = 42;

    public final static int ICE_MENUITEM = 43;

    public final static int ICE_MENUITEMSEPARATOR = 44;

    public final static int ICE_MENUITEMS = 45;

    public final static int ICE_MENUPOPUP = 46;

    public final static int ICE_OUTPUTBODY = 47;

    public final static int ICE_OUTPUTCHART = 48;

    public final static int ICE_OUTPUTCONNECTIONSTATUS = 49;

    public final static int ICE_OUTPUTDECLARATION = 50;

    public final static int ICE_OUTPUTHEAD = 51;

    public final static int ICE_OUTPUTHTML = 52;

    public final static int ICE_OUTPUTMEDIA = 53;

    public final static int ICE_OUTPUTSTYLE = 54;

    public final static int ICE_PANELCOLLAPSIBLE = 55;

    public final static int ICE_PANELDIVIDER = 56;

    public final static int ICE_PANELLAYOUT = 57;

    public final static int ICE_PANELPOPUP = 58;

    public final static int ICE_PANELSERIES = 59;

    public final static int ICE_PANELSTACK = 60;

    public final static int ICE_PANELTAB = 61;

    public final static int ICE_PANELTABSET = 62;

    public final static int ICE_PANELTOOLTIP = 63;

    public final static int ICE_PORTLET = 64;

    public final static int ICE_OUTPUTPROGRESS = 65;

    public final static int ICE_ROWSELECTOR = 66;

    public final static int ICE_SELECTINPUTDATE = 67;

    public final static int ICE_SELECTINPUTTEXT = 68;

    public final static int ICE_COMMANDSORTHEADER = 69;

    public final static int ICE_TREENODE = 70;

    public final static int ICE_TREE = 71;

    public final static int ICE_PANELPOSITIONED = 72;
    
    public final static int ICE_PANELCONFIRMATION = 73;

    private final static Object[] attributes = new Object[74];
    static{
           final String[] ICE_EFFECT = 
               new String[]{};
           attributes[0] = (ICE_EFFECT);
           final String[] ICE_PANELBORDER = 
               new String[]{ HTML.ALIGN_ATTR, HTML.BGCOLOR_ATTR,  HTML.BORDER_ATTR,  HTML.CELLPADDING_ATTR,  HTML.CELLSPACING_ATTR,  HTML.DIR_ATTR,  HTML.FRAME_ATTR,  HTML.HEIGHT_ATTR,  HTML.LANG_ATTR,  HTML.RULES_ATTR,  HTML.STYLE_ATTR,  HTML.SUMMARY_ATTR,  HTML.TITLE_ATTR,  HTML.WIDTH_ATTR };                        
           attributes[1] = (ICE_PANELBORDER);
           final String[] ICE_COLUMN = 
               new String[]{ HTML.STYLE_ATTR };                        
           attributes[2] = (ICE_COLUMN);
           final String[] ICE_COLUMNGROUP = 
               new String[]{};
           attributes[3] = (ICE_COLUMNGROUP);
           final String[] ICE_COLUMNS = 
               new String[]{ HTML.ROWS_ATTR };                        
           attributes[4] = (ICE_COLUMNS);
           final String[] ICE_DATAPAGINATOR = 
               new String[]{ HTML.STYLE_ATTR, HTML.TABINDEX_ATTR };                        
           attributes[5] = (ICE_DATAPAGINATOR);
           final String[] ICE_INPUTFILE = 
               new String[]{ HTML.ACCEPT_ATTR,  HTML.ACCESSKEY_ATTR,  HTML.HEIGHT_ATTR,  HTML.ONBLUR_ATTR,  HTML.ONCHANGE_ATTR,  HTML.ONFOCUS_ATTR,  HTML.STYLE_ATTR,  HTML.TABINDEX_ATTR,  HTML.TITLE_ATTR,  HTML.WIDTH_ATTR };                        
           attributes[6] = (ICE_INPUTFILE);
           final String[] ICE_GMAP = 
               new String[]{ HTML.STYLE_ATTR,  HTML.TYPE_ATTR };                        
           attributes[7] = (ICE_GMAP);
           final String[] ICE_GMAPCONTROL = 
               new String[]{};
           attributes[8] = (ICE_GMAPCONTROL);
           final String[] ICE_GMAPDIRECTION = 
               new String[]{};
           attributes[9] = (ICE_GMAPDIRECTION);
           final String[] ICE_GMAPGEOXML = 
               new String[]{};
           attributes[10] = (ICE_GMAPGEOXML);
           final String[] ICE_GMAPLATLNG = 
               new String[]{};
           attributes[11] = (ICE_GMAPLATLNG);
           final String[] ICE_GMAPLATLNGS = 
               new String[]{};
           attributes[12] = (ICE_GMAPLATLNGS);
           final String[] ICE_GMAPMARKER = 
               new String[]{};
           attributes[13] = (ICE_GMAPMARKER);
           final String[] ICE_HEADERROW = 
               new String[]{ HTML.STYLE_ATTR };                        
           attributes[14] = (ICE_HEADERROW);
           final String[] ICE_CHECKBOX = 
               new String[]{};
           attributes[15] = (ICE_CHECKBOX);
           final String[] ICE_COMMANDBUTTON = 
               new String[]{ HTML.ACCESSKEY_ATTR,  HTML.ALT_ATTR,  HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.ONBLUR_ATTR,  HTML.ONCHANGE_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONFOCUS_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.ONSELECT_ATTR,  HTML.STYLE_ATTR,  HTML.TABINDEX_ATTR,  HTML.TITLE_ATTR };                        
           attributes[16] = (ICE_COMMANDBUTTON);
           final String[] ICE_COMMANDLINK = 
               new String[]{ HTML.ACCESSKEY_ATTR,  HTML.CHARSET_ATTR,  HTML.COORDS_ATTR,  HTML.DIR_ATTR,  HTML.HREFLANG_ATTR,  HTML.LANG_ATTR,  HTML.ONBLUR_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONFOCUS_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.REL_ATTR,  HTML.REV_ATTR,  HTML.SHAPE_ATTR,  HTML.STYLE_ATTR,  HTML.TABINDEX_ATTR,  HTML.TARGET_ATTR,  HTML.TITLE_ATTR,  HTML.TYPE_ATTR };                        
           attributes[17] = (ICE_COMMANDLINK);
           final String[] ICE_DATATABLE = 
               new String[]{ HTML.BGCOLOR_ATTR,  HTML.BORDER_ATTR,  HTML.CELLPADDING_ATTR,  HTML.CELLSPACING_ATTR,  HTML.DIR_ATTR,  HTML.FRAME_ATTR,  HTML.LANG_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.RULES_ATTR,  HTML.STYLE_ATTR,  HTML.SUMMARY_ATTR,  HTML.TITLE_ATTR,  HTML.WIDTH_ATTR };                        
           attributes[18] = (ICE_DATATABLE);
           final String[] ICE_FORM = 
               new String[]{ HTML.ACCEPT_ATTR,  HTML.DIR_ATTR,  HTML.ENCTYPE_ATTR,  HTML.LANG_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.ONRESET_ATTR,  HTML.ONSUBMIT_ATTR,  HTML.STYLE_ATTR,  HTML.TARGET_ATTR,  HTML.TITLE_ATTR };                        
           attributes[19] = (ICE_FORM);
           final String[] ICE_GRAPHICIMAGE = 
               new String[]{ HTML.ALT_ATTR,  HTML.DIR_ATTR,  HTML.HEIGHT_ATTR,  HTML.LANG_ATTR,  HTML.LONGDESC_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.STYLE_ATTR,  HTML.TITLE_ATTR,  HTML.USEMAP_ATTR,  HTML.WIDTH_ATTR };                        
           attributes[20] = (ICE_GRAPHICIMAGE);
           final String[] ICE_INPUTHIDDEN = 
               new String[]{};
           attributes[21] = (ICE_INPUTHIDDEN);
           final String[] ICE_INPUTSECRET = 
               new String[]{ HTML.ACCESSKEY_ATTR,  HTML.ALT_ATTR,  HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.MAXLENGTH_ATTR,  HTML.ONBLUR_ATTR,  HTML.ONCHANGE_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONFOCUS_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.ONSELECT_ATTR,  HTML.SIZE_ATTR,  HTML.STYLE_ATTR,  HTML.TABINDEX_ATTR,  HTML.TITLE_ATTR };                        
           attributes[22] = (ICE_INPUTSECRET);
           final String[] ICE_INPUTTEXT = 
               new String[]{ HTML.ACCESSKEY_ATTR,  HTML.ALT_ATTR,  HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.MAXLENGTH_ATTR,  HTML.ONBLUR_ATTR,  HTML.ONCHANGE_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONFOCUS_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.ONSELECT_ATTR,  HTML.SIZE_ATTR,  HTML.STYLE_ATTR,  HTML.TABINDEX_ATTR,  HTML.TITLE_ATTR };                        
           attributes[23] = (ICE_INPUTTEXT);
           final String[] ICE_INPUTTEXTAREA = 
               new String[]{ HTML.ACCESSKEY_ATTR,  HTML.COLS_ATTR,  HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.ONBLUR_ATTR,  HTML.ONCHANGE_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONFOCUS_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.ONSELECT_ATTR,  HTML.ROWS_ATTR,  HTML.STYLE_ATTR,  HTML.TABINDEX_ATTR,  HTML.TITLE_ATTR };                        
           attributes[24] = (ICE_INPUTTEXTAREA);
           final String[] ICE_MESSAGE = 
               new String[]{ HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.STYLE_ATTR,  HTML.TITLE_ATTR };                        
           attributes[25] = (ICE_MESSAGE);
           final String[] ICE_MESSAGES = 
               new String[]{ HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.STYLE_ATTR,  HTML.TITLE_ATTR };                        
           attributes[26] = (ICE_MESSAGES);
           final String[] ICE_OUTPUTFORMAT = 
               new String[]{ HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.STYLE_ATTR,  HTML.TITLE_ATTR };                        
           attributes[27] = (ICE_OUTPUTFORMAT);
           final String[] ICE_OUTPUTLABEL = 
               new String[]{ HTML.ACCESSKEY_ATTR,  HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.ONBLUR_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONFOCUS_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.STYLE_ATTR,  HTML.TABINDEX_ATTR,  HTML.TITLE_ATTR };                        
           attributes[28] = (ICE_OUTPUTLABEL);
           final String[] ICE_OUTPUTLINK = 
               new String[]{ HTML.ACCESSKEY_ATTR,  HTML.CHARSET_ATTR,  HTML.COORDS_ATTR,  HTML.DIR_ATTR,  HTML.HREFLANG_ATTR,  HTML.LANG_ATTR,  HTML.ONBLUR_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONFOCUS_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.REL_ATTR,  HTML.REV_ATTR,  HTML.SHAPE_ATTR,  HTML.STYLE_ATTR,  HTML.TABINDEX_ATTR,  HTML.TARGET_ATTR,  HTML.TITLE_ATTR,  HTML.TYPE_ATTR };                        
           attributes[29] = (ICE_OUTPUTLINK);
           final String[] ICE_OUTPUTTEXT = 
               new String[]{ HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.STYLE_ATTR,  HTML.TITLE_ATTR };                        
           attributes[30] = (ICE_OUTPUTTEXT);
           final String[] ICE_PANELGRID = 
               new String[]{ HTML.BGCOLOR_ATTR,  HTML.BORDER_ATTR,  HTML.CELLPADDING_ATTR,  HTML.CELLSPACING_ATTR,  HTML.DIR_ATTR,  HTML.FRAME_ATTR,  HTML.LANG_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.RULES_ATTR,  HTML.STYLE_ATTR,  HTML.SUMMARY_ATTR,  HTML.TITLE_ATTR,  HTML.WIDTH_ATTR };                        
           attributes[31] = (ICE_PANELGRID);
           final String[] ICE_PANELGROUP = 
               new String[]{ HTML.STYLE_ATTR, HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR, HTML.TITLE_ATTR };                        
           attributes[32] = (ICE_PANELGROUP);
           final String[] ICE_RADIO = 
               new String[]{};
           attributes[33] = (ICE_RADIO);
           final String[] ICE_SELECTBOOLEANCHECKBOX = 
               new String[]{ HTML.ACCESSKEY_ATTR,  HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.ONBLUR_ATTR,  HTML.ONCHANGE_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONFOCUS_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.ONSELECT_ATTR,  HTML.STYLE_ATTR,  HTML.TABINDEX_ATTR,  HTML.TITLE_ATTR };                        
           attributes[34] = (ICE_SELECTBOOLEANCHECKBOX);
           final String[] ICE_SELECTMANYCHECKBOX = 
               new String[]{ HTML.ACCESSKEY_ATTR,  HTML.BORDER_ATTR,  HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.ONBLUR_ATTR,  HTML.ONCHANGE_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONFOCUS_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.ONSELECT_ATTR,  HTML.STYLE_ATTR,  HTML.TABINDEX_ATTR,  HTML.TITLE_ATTR };                        
           attributes[35] = (ICE_SELECTMANYCHECKBOX);
           final String[] ICE_SELECTMANYLISTBOX = 
               new String[]{ HTML.ACCESSKEY_ATTR,  HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.ONBLUR_ATTR,  HTML.ONCHANGE_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONFOCUS_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.ONSELECT_ATTR,  HTML.STYLE_ATTR,  HTML.TABINDEX_ATTR,  HTML.TITLE_ATTR };                        
           attributes[36] = (ICE_SELECTMANYLISTBOX);
           final String[] ICE_SELECTMANYMENU = 
               new String[]{ HTML.ACCESSKEY_ATTR,  HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.ONBLUR_ATTR,  HTML.ONCHANGE_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONFOCUS_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.ONSELECT_ATTR,  HTML.STYLE_ATTR,  HTML.TABINDEX_ATTR,  HTML.TITLE_ATTR };                        
           attributes[37] = (ICE_SELECTMANYMENU);
           final String[] ICE_SELECTONELISTBOX = 
               new String[]{ HTML.ACCESSKEY_ATTR,  HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.ONBLUR_ATTR,  HTML.ONCHANGE_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONFOCUS_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.ONSELECT_ATTR,  HTML.STYLE_ATTR,  HTML.TABINDEX_ATTR,  HTML.TITLE_ATTR };                        
           attributes[38] = (ICE_SELECTONELISTBOX);
           final String[] ICE_SELECTONEMENU = 
               new String[]{ HTML.ACCESSKEY_ATTR,  HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.ONBLUR_ATTR,  HTML.ONCHANGE_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONFOCUS_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.ONSELECT_ATTR,  HTML.STYLE_ATTR,  HTML.TABINDEX_ATTR,  HTML.TITLE_ATTR };                        
           attributes[39] = (ICE_SELECTONEMENU);
           final String[] ICE_SELECTONERADIO = 
               new String[]{ HTML.ACCESSKEY_ATTR,  HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.ONBLUR_ATTR,  HTML.ONCHANGE_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONFOCUS_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.ONSELECT_ATTR,  HTML.STYLE_ATTR,  HTML.TABINDEX_ATTR,  HTML.TITLE_ATTR };                        
           attributes[40] = (ICE_SELECTONERADIO);
           final String[] ICE_INPUTRICHTEXT = 
               new String[]{ HTML.HEIGHT_ATTR,  HTML.STYLE_ATTR,  HTML.WIDTH_ATTR };                        
           attributes[41] = (ICE_INPUTRICHTEXT);
           final String[] ICE_MENUBAR = 
               new String[]{ HTML.STYLE_ATTR };                        
           attributes[42] = (ICE_MENUBAR);
           final String[] ICE_MENUITEM = 
               new String[]{ HTML.ALT_ATTR,  HTML.ONCLICK_ATTR,  HTML.TARGET_ATTR,  HTML.TITLE_ATTR };                        
           attributes[43] = (ICE_MENUITEM);
           final String[] ICE_MENUITEMSEPARATOR = 
               new String[]{};
           attributes[44] = (ICE_MENUITEMSEPARATOR);
           final String[] ICE_MENUITEMS = 
               new String[]{};
           attributes[45] = (ICE_MENUITEMS);
           final String[] ICE_MENUPOPUP = 
               new String[]{ HTML.STYLE_ATTR };                        
           attributes[46] = (ICE_MENUPOPUP);
           final String[] ICE_OUTPUTBODY = 
               new String[]{ HTML.BGCOLOR_ATTR,  HTML.STYLE_ATTR };                        
           attributes[47] = (ICE_OUTPUTBODY);
           final String[] ICE_OUTPUTCHART = 
               new String[]{ HTML.HEIGHT_ATTR,  HTML.STYLE_ATTR,  HTML.WIDTH_ATTR };                        
           attributes[48] = (ICE_OUTPUTCHART);
           final String[] ICE_OUTPUTCONNECTIONSTATUS = 
               new String[]{ HTML.STYLE_ATTR };                        
           attributes[49] = (ICE_OUTPUTCONNECTIONSTATUS);
           final String[] ICE_OUTPUTDECLARATION = 
               new String[]{};
           attributes[50] = (ICE_OUTPUTDECLARATION);
           final String[] ICE_OUTPUTHEAD = 
               new String[]{ HTML.DIR_ATTR,  HTML.LANG_ATTR };                        
           attributes[51] = (ICE_OUTPUTHEAD);
           final String[] ICE_OUTPUTHTML = 
               new String[]{};
           attributes[52] = (ICE_OUTPUTHTML);
           final String[] ICE_OUTPUTMEDIA = 
               new String[]{ HTML.STYLE_ATTR };                        
           attributes[53] = (ICE_OUTPUTMEDIA);
           final String[] ICE_OUTPUTSTYLE = 
               new String[]{};
           attributes[54] = (ICE_OUTPUTSTYLE);
           final String[] ICE_PANELCOLLAPSIBLE = 
               new String[]{ HTML.STYLE_ATTR };                        
           attributes[55] = (ICE_PANELCOLLAPSIBLE);
           final String[] ICE_PANELDIVIDER = 
               new String[]{ HTML.STYLE_ATTR };                        
           attributes[56] = (ICE_PANELDIVIDER);
           final String[] ICE_PANELLAYOUT = 
               new String[]{ HTML.STYLE_ATTR };                        
           attributes[57] = (ICE_PANELLAYOUT);
           final String[] ICE_PANELPOPUP = 
               new String[]{ HTML.STYLE_ATTR,  HTML.TITLE_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR };                        
           attributes[58] = (ICE_PANELPOPUP);
           final String[] ICE_PANELSERIES = 
               new String[]{ HTML.ROWS_ATTR,  HTML.STYLE_ATTR };                        
           attributes[59] = (ICE_PANELSERIES);
           final String[] ICE_PANELSTACK = 
               new String[]{ HTML.STYLE_ATTR };                        
           attributes[60] = (ICE_PANELSTACK);
           final String[] ICE_PANELTAB = 
               new String[]{ HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.STYLE_ATTR,  HTML.TITLE_ATTR };                        
           attributes[61] = (ICE_PANELTAB);
           final String[] ICE_PANELTABSET = 
               new String[]{ HTML.BGCOLOR_ATTR,  HTML.BORDER_ATTR,  HTML.CELLPADDING_ATTR,  HTML.CELLSPACING_ATTR,  HTML.DIR_ATTR,  HTML.FRAME_ATTR,  HTML.HEIGHT_ATTR,  HTML.LANG_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.ROWS_ATTR,  HTML.RULES_ATTR,  HTML.STYLE_ATTR,  HTML.SUMMARY_ATTR,  HTML.TITLE_ATTR,  HTML.WIDTH_ATTR };                        
           attributes[62] = (ICE_PANELTABSET);
           final String[] ICE_PANELTOOLTIP = 
               new String[]{ HTML.STYLE_ATTR, HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR };                        
           attributes[63] = (ICE_PANELTOOLTIP);
           final String[] ICE_PORTLET = 
               new String[]{ HTML.STYLE_ATTR };                        
           attributes[64] = (ICE_PORTLET);
           final String[] ICE_OUTPUTPROGRESS = 
               new String[]{ HTML.STYLE_ATTR };                        
           attributes[65] = (ICE_OUTPUTPROGRESS);
           final String[] ICE_ROWSELECTOR = 
               new String[]{HTML.TABINDEX_ATTR};
           attributes[66] = (ICE_ROWSELECTOR);
           final String[] ICE_SELECTINPUTDATE = 
               new String[]{ HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.STYLE_ATTR,  HTML.TABINDEX_ATTR,  HTML.TITLE_ATTR };                        
           attributes[67] = (ICE_SELECTINPUTDATE);
           final String[] ICE_SELECTINPUTTEXT = 
               new String[]{ HTML.ACCESSKEY_ATTR,  HTML.ALT_ATTR,  HTML.DIR_ATTR,  HTML.LANG_ATTR,  HTML.MAXLENGTH_ATTR,  HTML.ONBLUR_ATTR,  HTML.ONCHANGE_ATTR,  HTML.ONCLICK_ATTR,  HTML.ONDBLCLICK_ATTR,  HTML.ONFOCUS_ATTR,  HTML.ONKEYDOWN_ATTR,  HTML.ONKEYPRESS_ATTR,  HTML.ONKEYUP_ATTR,  HTML.ONMOUSEDOWN_ATTR,  HTML.ONMOUSEMOVE_ATTR,  HTML.ONMOUSEOUT_ATTR,  HTML.ONMOUSEOVER_ATTR,  HTML.ONMOUSEUP_ATTR,  HTML.ONSELECT_ATTR,  HTML.ROWS_ATTR,  HTML.SIZE_ATTR,  HTML.STYLE_ATTR,  HTML.TABINDEX_ATTR,  HTML.TITLE_ATTR,  HTML.WIDTH_ATTR };                        
           attributes[68] = (ICE_SELECTINPUTTEXT);
           final String[] ICE_COMMANDSORTHEADER = 
               new String[]{};
           attributes[69] = (ICE_COMMANDSORTHEADER);
           final String[] ICE_TREENODE = 
               new String[]{};
           attributes[70] = (ICE_TREENODE);
           final String[] ICE_TREE = 
               new String[]{ HTML.STYLE_ATTR };                        
           attributes[71] = (ICE_TREE);
           final String[] ICE_PANELPOSITIONED = 
               new String[]{ HTML.ROWS_ATTR,  HTML.STYLE_ATTR };                        
           attributes[72] = (ICE_PANELPOSITIONED);
           final String[] ICE_PANELCONFIRMATION =
               new String[]{ HTML.STYLE_ATTR, HTML.TITLE_ATTR };
           attributes[73] = (ICE_PANELCONFIRMATION);
    }

    public static String[] getAttributes(int i){
        if(i < 0 || i > attributes.length -1){
            return null;
        }
        return (String[])attributes[i];
    }
    
    public static String[] getAttributes(int index, String[][] remove) {
        List removeArrays = new ArrayList();
        for (int i = 0; i < remove.length; i++) {
            for (int j=0; j < remove[i].length; j++) {
                removeArrays.add(remove[i][j]);
                
            }
        }
        return getAttributes(index,(String[]) removeArrays.toArray(new String[]{})) ;
    }
    
    /**
     * This method is used to exclude entries from a components's list of 
     *  passthrough attributes. The remove parameter may contain entries 
     *  that are not in the list of component attributes returnd from 
     *  getAttributes(int).
     */
    public static String[] getAttributes(int index, String[] remove) {
        String[] attributes = getAttributes(index);
        if(attributes == null)
            return null;
        if(remove == null || remove.length == 0)
            return attributes;
        
        int numToRemove = 0; 
        for(int i = 0; i < attributes.length; i++) {
            for(int j = 0; j < remove.length; j++) {
                if(attributes[i].equals(remove[j])) {
                    numToRemove++;
                    break;
                }
            }
        }
        
        String[] copy = new String[attributes.length - numToRemove];
        int copyIndex = 0;
        for(int i = 0; i < attributes.length; i++) {
            boolean shouldRemove = false;
            for(int j = 0; j < remove.length; j++) {
                if(attributes[i].equals(remove[j])) {
                    shouldRemove = true;
                    break;
                }
            }
            if(!shouldRemove) {
                copy[copyIndex++] = attributes[i];
            }
        }
        return copy;
    }
}