/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.dataexporter;

import com.icesoft.faces.component.dataexporter.OutputTypeHandler;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class PDFOutputHandler
extends OutputTypeHandler {
    protected String title;
    protected ArrayList headers;
    protected ArrayList footers;
    protected ArrayList rowsOfData;
    protected String orientation;
    protected String pageSize;
    protected String headerFont;
    protected String cellFont;
    protected int headerFontSize;
    protected int cellFontSize;
    private static final boolean REFLECTION_LOADED;
    private static Class com_lowagie_text_Cell;
    private static Class com_lowagie_text_Chunk;
    private static Class com_lowagie_text_Document;
    private static Class com_lowagie_text_Element;
    private static Class com_lowagie_text_Font;
    private static Class com_lowagie_text_FontFactory;
    private static Class com_lowagie_text_PageSize;
    private static Class com_lowagie_text_Paragraph;
    private static Class com_lowagie_text_Phrase;
    private static Class com_lowagie_text_Rectangle;
    private static Class com_lowagie_text_Table;
    private static Class com_lowagie_text_pdf_PdfAction;
    private static Class com_lowagie_text_pdf_PdfDestination;
    private static Class com_lowagie_text_pdf_PdfWriter;
    private static Constructor com_lowagie_text_Document_ctor;
    private static Method com_lowagie_text_Document_open;
    private static Method com_lowagie_text_Document_close;
    private static Method com_lowagie_text_Document_setPageSize;
    private static Method com_lowagie_text_Document_add;
    private static Method com_lowagie_text_pdf_PdfWriter_getInstance;
    private static Method com_lowagie_text_pdf_PdfWriter_setOpenAction;
    private static int com_lowagie_text_pdf_PdfDestination_XYZ;
    private static Constructor com_lowagie_text_pdf_PdfDestination_ctor;
    private static Method com_lowagie_text_pdf_PdfAction_gotoLocalPage;
    private static Method com_lowagie_text_PageSize_getRectangle;
    private static Method com_lowagie_text_Rectangle_rotate;
    private static int com_lowagie_text_Rectangle_ALIGN_CENTER;
    private static Method com_lowagie_text_FontFactory_getFont;
    private static Method com_lowagie_text_FontFactory_getFont_BOLD;
    private static String com_lowagie_text_FontFactory_TIMES_ROMAN;
    private static int com_lowagie_text_Font_BOLD;
    private static Constructor com_lowagie_text_Chunk_ctor;
    private static Constructor com_lowagie_text_Phrase_ctor_Chunk;
    private static Constructor com_lowagie_text_Phrase_ctor_SF;
    private static Constructor com_lowagie_text_Paragraph_ctor;
    private static Method com_lowagie_text_Paragraph_setAlignment_ALIGN_CENTER;
    private static Constructor com_lowagie_text_Table_ctor;
    private static Method com_lowagie_text_Table_setWidth;
    private static Method com_lowagie_text_Table_setBorderWidth;
    private static Method com_lowagie_text_Table_setPadding;
    private static Method com_lowagie_text_Table_setCellsFitPage;
    private static Method com_lowagie_text_Table_setWidths;
    private static Method com_lowagie_text_Table_addCell;
    private static int com_lowagie_text_Cell_TOP_BOTTOM_RIGHT_LEFT;
    private static int com_lowagie_text_Cell_ALIGN_CENTER;
    private static Constructor com_lowagie_text_Cell_ctor;
    private static Method com_lowagie_text_Cell_setBorder;
    private static Method com_lowagie_text_Cell_setHorizontalAlignment;
    private static Method com_lowagie_text_Cell_setBackgroundColor;

    public PDFOutputHandler(String path, String title) {
        super(path);
        this.title = title;
        this.mimeType = "application/pdf";
        this.headers = new ArrayList();
        this.footers = new ArrayList();
        this.rowsOfData = new ArrayList();
        this.orientation = "portrait";
        this.pageSize = "A4";
        this.headerFont = "Times-Roman";
        this.cellFont = "Times-Roman";
        this.headerFontSize = 9;
        this.cellFontSize = 8;
        if (!REFLECTION_LOADED) {
            throw new IllegalStateException("iText library not found, can not export dataTable to PDF");
        }
    }

    public void writeCell(Object output, int col, int row) {
        this.rowsOfData.ensureCapacity(row);
        while (row >= this.rowsOfData.size()) {
            this.rowsOfData.add(new ArrayList());
        }
        ArrayList rowData = (ArrayList)this.rowsOfData.get(row);
        rowData.ensureCapacity(col);
        while (col >= rowData.size()) {
            rowData.add(null);
        }
        rowData.set(col, output);
    }

    public void writeHeaderCell(String text, int col) {
        this.headers.ensureCapacity(col);
        while (col >= this.headers.size()) {
            this.headers.add(null);
        }
        this.headers.set(col, text);
    }

    public void writeFooterCell(Object output, int col, int row) {
        this.footers.ensureCapacity(col);
        while (col >= this.footers.size()) {
            this.footers.add(null);
        }
        this.footers.set(col, output);
    }

    public void flushFile() {
        try {
            FileOutputStream fos = new FileOutputStream(this.getFile());
            BufferedOutputStream bos = new BufferedOutputStream(fos, 64896);
            this.printPDF(bos);
            bos.flush();
            fos.flush();
            bos.close();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void printPDF(OutputStream osPDF) throws Exception {
        Object document = PDFOutputHandler.new_Document();
        this.applyDocumentProperties(document);
        Object writer = PDFOutputHandler.PdfWriter_getInstance(document, osPDF);
        PDFOutputHandler.Document_open(document);
        PDFOutputHandler.PdfWriter_setOpenAction(writer);
        this.printHeaderTitle(document, this.title);
        this.printTableData(document);
        PDFOutputHandler.Document_close(document);
    }

    protected void applyDocumentProperties(Object document) throws Exception {
        Object page = PDFOutputHandler.PageSize_getRectangle(this.pageSize);
        if (PDFOutputHandler.nvl(this.orientation).equalsIgnoreCase("LANDSCAPE")) {
            this.Document_setPageSize(document, PDFOutputHandler.Rectangle_rotate(page));
        } else {
            this.Document_setPageSize(document, page);
        }
    }

    protected void printHeaderTitle(Object document, String headerText) throws Exception {
        if (this.title != null && this.title.length() > 0) {
            Object font = PDFOutputHandler.FontFactory_getFont_BOLD(com_lowagie_text_FontFactory_TIMES_ROMAN, 14.0f);
            Object ck = PDFOutputHandler.new_Chunk(headerText, font);
            Object phrase = PDFOutputHandler.new_Phrase(ck);
            Object paragraph = PDFOutputHandler.new_Paragraph(phrase);
            PDFOutputHandler.Paragraph_setAlignment_ALIGN_CENTER(paragraph);
            this.Document_add(document, paragraph);
        }
    }

    protected void printTableData(Object document) throws Exception {
        try {
            int length = this.calculateColumnCount();
            float[] tWidth = new float[length];
            for (int wi = 0; wi < length; ++wi) {
                tWidth[wi] = this.calculateColumnWidth(wi);
            }
            Object table = PDFOutputHandler.new_Table_init(length, tWidth);
            String headerFontProp = PDFOutputHandler.nvl(this.headerFont);
            float fHeaderSize = this.headerFontSize;
            Object font = PDFOutputHandler.FontFactory_getFont_BOLD(headerFontProp, fHeaderSize);
            Color backGroundColor = new Color(225, 225, 225);
            boolean wasHeader = this.printTableHeadersOrFooters(table, font, backGroundColor, this.headers, 0);
            int numContentRows = this.printTableContents(table, wasHeader);
            int footerRow = (wasHeader ? 1 : 0) + numContentRows;
            boolean wasFooter = this.printTableHeadersOrFooters(table, font, backGroundColor, this.footers, footerRow);
            this.Document_add(document, table);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean printTableHeadersOrFooters(Object table, Object font, Color backGroundColor, ArrayList headersOrFooters, int row) throws Exception {
        for (int i = 0; i < headersOrFooters.size(); ++i) {
            String text = PDFOutputHandler.nvl((String)headersOrFooters.get(i));
            PDFOutputHandler.Table_add_new_Cell_BORDER_TOP_BOTTOM_RIGHT_LEFT_ALIGN_CENTER(table, row, i, text, font, backGroundColor);
        }
        return headersOrFooters.size() > 0;
    }

    protected int printTableContents(Object table, boolean wasHeader) throws Exception {
        String cellFontProp = PDFOutputHandler.nvl(this.cellFont);
        float fCellSize = this.cellFontSize;
        Object font = PDFOutputHandler.FontFactory_getFont(cellFontProp, fCellSize);
        Color backGroundColor = Color.white;
        int headerRowOffset = wasHeader ? 1 : 0;
        int numRows = this.rowsOfData.size();
        for (int j = 0; j < numRows; ++j) {
            ArrayList rowData = (ArrayList)this.rowsOfData.get(j);
            for (int i = 0; i < rowData.size(); ++i) {
                String cellText = PDFOutputHandler.nvl((String)rowData.get(i));
                PDFOutputHandler.Table_add_new_Cell_BORDER_TOP_BOTTOM_RIGHT_LEFT_ALIGN_CENTER(table, j + headerRowOffset, i, cellText, font, backGroundColor);
            }
        }
        return numRows;
    }

    protected int calculateColumnCount() {
        int maxColumns = 0;
        maxColumns = Math.max(maxColumns, this.headers.size());
        maxColumns = Math.max(maxColumns, this.footers.size());
        for (int i = 0; i < this.rowsOfData.size(); ++i) {
            ArrayList rowData = (ArrayList)this.rowsOfData.get(i);
            maxColumns = Math.max(maxColumns, rowData.size());
        }
        return maxColumns;
    }

    protected float calculateColumnWidth(int index) throws Exception {
        float defaultWidth = 1.2f;
        String headerText = PDFOutputHandler.nvl((String)this.headers.get(index));
        int iTxtLength = headerText.length();
        for (int i = 0; i < this.rowsOfData.size(); ++i) {
            ArrayList rowData = (ArrayList)this.rowsOfData.get(i);
            String cellValue = PDFOutputHandler.nvl((String)rowData.get(index));
            iTxtLength = Math.max(iTxtLength, cellValue.length());
        }
        return this.returnPDFWidth(iTxtLength);
    }

    protected float returnPDFWidth(int colLength) {
        float retValue = 1.2f;
        retValue = colLength <= 5 ? 0.5f : (colLength <= 7 ? 0.7f : (colLength <= 10 ? 0.8f : (colLength <= 15 ? 1.0f : (colLength <= 20 ? 1.2f : (colLength <= 30 ? 1.5f : (colLength <= 50 ? 1.8f : 2.2f))))));
        return retValue;
    }

    protected static String nvl(String stringValue) {
        String returnValue = "";
        if (stringValue != null) {
            returnValue = stringValue.trim();
        }
        return returnValue;
    }

    private static Object new_Document() {
        try {
            return com_lowagie_text_Document_ctor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    private static void Document_open(Object document) {
        try {
            com_lowagie_text_Document_open.invoke(document, new Object[0]);
        }
        catch (InvocationTargetException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static void Document_close(Object document) {
        try {
            com_lowagie_text_Document_close.invoke(document, new Object[0]);
        }
        catch (InvocationTargetException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private void Document_setPageSize(Object document, Object page) {
        try {
            com_lowagie_text_Document_setPageSize.invoke(document, page);
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private void Document_add(Object document, Object element) {
        try {
            com_lowagie_text_Document_add.invoke(document, element);
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private static Object PdfWriter_getInstance(Object document, OutputStream os) {
        try {
            return com_lowagie_text_pdf_PdfWriter_getInstance.invoke(null, document, os);
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    private static void PdfWriter_setOpenAction(Object writer) {
        try {
            Object destination = com_lowagie_text_pdf_PdfDestination_ctor.newInstance(new Integer(com_lowagie_text_pdf_PdfDestination_XYZ), new Float(0.0f), new Float(10000.0f), new Float(1.0f));
            Object action = com_lowagie_text_pdf_PdfAction_gotoLocalPage.invoke(null, new Integer(1), destination, writer);
            com_lowagie_text_pdf_PdfWriter_setOpenAction.invoke(writer, action);
        }
        catch (InvocationTargetException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static Object PageSize_getRectangle(String pageSize) {
        try {
            return com_lowagie_text_PageSize_getRectangle.invoke(null, pageSize);
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    private static Object Rectangle_rotate(Object rectangle) {
        try {
            return com_lowagie_text_Rectangle_rotate.invoke(rectangle, new Object[0]);
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    private static Object FontFactory_getFont(String fontName, float size) {
        try {
            return com_lowagie_text_FontFactory_getFont.invoke(null, fontName, new Float(size));
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    private static Object FontFactory_getFont_BOLD(String fontName, float size) {
        try {
            return com_lowagie_text_FontFactory_getFont_BOLD.invoke(null, fontName, new Float(size), new Integer(com_lowagie_text_Font_BOLD));
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    private static Object new_Chunk(String text, Object font) {
        try {
            return com_lowagie_text_Chunk_ctor.newInstance(text, font);
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    private static Object new_Phrase(Object chunk) {
        try {
            return com_lowagie_text_Phrase_ctor_Chunk.newInstance(chunk);
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    private static Object new_Paragraph(Object phrase) {
        try {
            return com_lowagie_text_Paragraph_ctor.newInstance(phrase);
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    private static void Paragraph_setAlignment_ALIGN_CENTER(Object paragraph) {
        try {
            com_lowagie_text_Paragraph_setAlignment_ALIGN_CENTER.invoke(paragraph, new Integer(com_lowagie_text_Rectangle_ALIGN_CENTER));
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private static Object new_Table_init(int length, float[] tWidth) throws Exception {
        Object table = null;
        try {
            table = com_lowagie_text_Table_ctor.newInstance(new Integer(length));
            com_lowagie_text_Table_setWidth.invoke(table, new Float(107.0f));
            com_lowagie_text_Table_setBorderWidth.invoke(table, new Float(0.0f));
            com_lowagie_text_Table_setPadding.invoke(table, new Float(2.0f));
            com_lowagie_text_Table_setCellsFitPage.invoke(table, Boolean.TRUE);
            com_lowagie_text_Table_setWidths.invoke(table, new Object[]{tWidth});
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return table;
    }

    private static void Table_add_new_Cell_BORDER_TOP_BOTTOM_RIGHT_LEFT_ALIGN_CENTER(Object table, int row, int column, String text, Object font, Color backgroundColor) throws Exception {
        if (text == null) {
            text = "";
        }
        try {
            Object phrase = com_lowagie_text_Phrase_ctor_SF.newInstance(text, font);
            Object cell = com_lowagie_text_Cell_ctor.newInstance(phrase);
            com_lowagie_text_Cell_setBorder.invoke(cell, new Integer(com_lowagie_text_Cell_TOP_BOTTOM_RIGHT_LEFT));
            com_lowagie_text_Cell_setHorizontalAlignment.invoke(cell, new Integer(com_lowagie_text_Cell_ALIGN_CENTER));
            com_lowagie_text_Cell_setBackgroundColor.invoke(cell, backgroundColor);
            com_lowagie_text_Table_addCell.invoke(table, cell, new Integer(row), new Integer(column));
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
    }

    static {
        boolean loaded = false;
        try {
            com_lowagie_text_Cell = Class.forName("com.lowagie.text.Cell");
            com_lowagie_text_Chunk = Class.forName("com.lowagie.text.Chunk");
            com_lowagie_text_Document = Class.forName("com.lowagie.text.Document");
            com_lowagie_text_Element = Class.forName("com.lowagie.text.Element");
            com_lowagie_text_Font = Class.forName("com.lowagie.text.Font");
            com_lowagie_text_FontFactory = Class.forName("com.lowagie.text.FontFactory");
            com_lowagie_text_PageSize = Class.forName("com.lowagie.text.PageSize");
            com_lowagie_text_Paragraph = Class.forName("com.lowagie.text.Paragraph");
            com_lowagie_text_Phrase = Class.forName("com.lowagie.text.Phrase");
            com_lowagie_text_Rectangle = Class.forName("com.lowagie.text.Rectangle");
            com_lowagie_text_Table = Class.forName("com.lowagie.text.Table");
            com_lowagie_text_pdf_PdfAction = Class.forName("com.lowagie.text.pdf.PdfAction");
            com_lowagie_text_pdf_PdfDestination = Class.forName("com.lowagie.text.pdf.PdfDestination");
            com_lowagie_text_pdf_PdfWriter = Class.forName("com.lowagie.text.pdf.PdfWriter");
            com_lowagie_text_Document_ctor = com_lowagie_text_Document.getConstructor(new Class[0]);
            com_lowagie_text_Document_open = com_lowagie_text_Document.getMethod("open", new Class[0]);
            com_lowagie_text_Document_close = com_lowagie_text_Document.getMethod("close", new Class[0]);
            com_lowagie_text_Document_setPageSize = com_lowagie_text_Document.getMethod("setPageSize", com_lowagie_text_Rectangle);
            com_lowagie_text_Document_add = com_lowagie_text_Document.getMethod("add", com_lowagie_text_Element);
            com_lowagie_text_pdf_PdfWriter_getInstance = com_lowagie_text_pdf_PdfWriter.getMethod("getInstance", com_lowagie_text_Document, OutputStream.class);
            com_lowagie_text_pdf_PdfWriter_setOpenAction = com_lowagie_text_pdf_PdfWriter.getMethod("setOpenAction", com_lowagie_text_pdf_PdfAction);
            com_lowagie_text_pdf_PdfDestination_XYZ = (Integer)com_lowagie_text_pdf_PdfDestination.getField("XYZ").get(null);
            com_lowagie_text_pdf_PdfDestination_ctor = com_lowagie_text_pdf_PdfDestination.getConstructor(Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            com_lowagie_text_pdf_PdfAction_gotoLocalPage = com_lowagie_text_pdf_PdfAction.getMethod("gotoLocalPage", Integer.TYPE, com_lowagie_text_pdf_PdfDestination, com_lowagie_text_pdf_PdfWriter);
            com_lowagie_text_PageSize_getRectangle = com_lowagie_text_PageSize.getMethod("getRectangle", String.class);
            com_lowagie_text_Rectangle_rotate = com_lowagie_text_Rectangle.getMethod("rotate", new Class[0]);
            com_lowagie_text_Rectangle_ALIGN_CENTER = (Integer)com_lowagie_text_Rectangle.getField("ALIGN_CENTER").get(null);
            com_lowagie_text_FontFactory_getFont = com_lowagie_text_FontFactory.getMethod("getFont", String.class, Float.TYPE);
            com_lowagie_text_FontFactory_getFont_BOLD = com_lowagie_text_FontFactory.getMethod("getFont", String.class, Float.TYPE, Integer.TYPE);
            com_lowagie_text_FontFactory_TIMES_ROMAN = com_lowagie_text_FontFactory.getField("TIMES_ROMAN").get(null).toString();
            com_lowagie_text_Font_BOLD = (Integer)com_lowagie_text_Font.getField("BOLD").get(null);
            com_lowagie_text_Chunk_ctor = com_lowagie_text_Chunk.getConstructor(String.class, com_lowagie_text_Font);
            com_lowagie_text_Phrase_ctor_Chunk = com_lowagie_text_Phrase.getConstructor(com_lowagie_text_Chunk);
            com_lowagie_text_Phrase_ctor_SF = com_lowagie_text_Phrase.getConstructor(String.class, com_lowagie_text_Font);
            com_lowagie_text_Paragraph_ctor = com_lowagie_text_Paragraph.getConstructor(com_lowagie_text_Phrase);
            com_lowagie_text_Paragraph_setAlignment_ALIGN_CENTER = com_lowagie_text_Paragraph.getMethod("setAlignment", Integer.TYPE);
            com_lowagie_text_Table_ctor = com_lowagie_text_Table.getConstructor(Integer.TYPE);
            com_lowagie_text_Table_setWidth = com_lowagie_text_Table.getMethod("setWidth", Float.TYPE);
            com_lowagie_text_Table_setBorderWidth = com_lowagie_text_Table.getMethod("setBorderWidth", Float.TYPE);
            com_lowagie_text_Table_setPadding = com_lowagie_text_Table.getMethod("setPadding", Float.TYPE);
            com_lowagie_text_Table_setCellsFitPage = com_lowagie_text_Table.getMethod("setCellsFitPage", Boolean.TYPE);
            com_lowagie_text_Table_setWidths = com_lowagie_text_Table.getMethod("setWidths", Class.forName("[F"));
            com_lowagie_text_Table_addCell = com_lowagie_text_Table.getMethod("addCell", com_lowagie_text_Cell, Integer.TYPE, Integer.TYPE);
            Field Cell_TOP = com_lowagie_text_Cell.getField("TOP");
            Field Cell_BOTTOM = com_lowagie_text_Cell.getField("BOTTOM");
            Field Cell_RIGHT = com_lowagie_text_Cell.getField("RIGHT");
            Field Cell_LEFT = com_lowagie_text_Cell.getField("LEFT");
            com_lowagie_text_Cell_TOP_BOTTOM_RIGHT_LEFT = (Integer)Cell_TOP.get(null) | (Integer)Cell_BOTTOM.get(null) | (Integer)Cell_RIGHT.get(null) | (Integer)Cell_LEFT.get(null);
            com_lowagie_text_Cell_ALIGN_CENTER = (Integer)com_lowagie_text_Cell.getField("ALIGN_CENTER").get(null);
            com_lowagie_text_Cell_ctor = com_lowagie_text_Cell.getConstructor(com_lowagie_text_Element);
            com_lowagie_text_Cell_setBorder = com_lowagie_text_Cell.getMethod("setBorder", Integer.TYPE);
            com_lowagie_text_Cell_setHorizontalAlignment = com_lowagie_text_Cell.getMethod("setHorizontalAlignment", Integer.TYPE);
            com_lowagie_text_Cell_setBackgroundColor = com_lowagie_text_Cell.getMethod("setBackgroundColor", Color.class);
            loaded = true;
        }
        catch (Exception e) {
            System.out.println("Problem with PDFOutputHandler iText reflection: " + e);
        }
        REFLECTION_LOADED = loaded;
    }
}

