/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.outputresource;

import com.icesoft.faces.component.outputresource.OutputResource;
import com.icesoft.faces.context.FileResource;
import com.icesoft.faces.context.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

class RegisteredResource
implements Resource {
    private Resource resource;
    private String fileName;
    private String label;
    private Date lastModified;
    private String mimeType;
    private boolean isAttachment;
    private boolean isShared;
    private String path;

    public RegisteredResource(OutputResource outputResource, Resource resource, String fileName) {
        this.updateContents(outputResource, resource, fileName);
    }

    public String calculateDigest() {
        return this.resource.calculateDigest() + (this.isShared ? "" : String.valueOf(this.resource.hashCode()));
    }

    public Date lastModified() {
        return this.lastModified;
    }

    public InputStream open() throws IOException {
        return this.resource.open();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    void updateContents(OutputResource outputResource, Resource resource, String fileName) {
        this.resource = resource;
        this.fileName = fileName;
        this.label = outputResource.getLabel();
        this.lastModified = outputResource.getLastModified();
        this.mimeType = outputResource.getMimeType();
        this.isAttachment = outputResource.isAttachment();
        this.isShared = outputResource.isShared();
    }

    public void withOptions(Resource.Options options) {
        ResourceOptions resourceOptions = new ResourceOptions();
        try {
            this.resource.withOptions(resourceOptions);
        }
        catch (IOException e) {
            // empty catch block
        }
        String fName = null;
        if (resourceOptions.fileName != null) {
            fName = resourceOptions.fileName;
        } else if (this.fileName != null) {
            fName = this.fileName;
        } else if (this.resource instanceof FileResource) {
            fName = ((FileResource)this.resource).getFile().getName();
        } else if (this.label != null) {
            fName = this.label.replace(' ', '_');
        }
        options.setFileName(fName);
        if (resourceOptions.lastModified != null) {
            options.setLastModified(resourceOptions.lastModified);
        } else if (this.lastModified != null) {
            options.setLastModified(this.lastModified);
        }
        if (resourceOptions.mimeType != null) {
            options.setMimeType(resourceOptions.mimeType);
        } else if (this.mimeType != null) {
            options.setMimeType(this.mimeType);
        }
        if (resourceOptions.isAttachment) {
            options.setAsAttachement();
        } else if (this.isAttachment) {
            options.setAsAttachement();
        }
    }

    private class ResourceOptions
    implements Resource.Options {
        private Date lastModified;
        private String mimeType;
        private String fileName;
        private boolean isAttachment;

        private ResourceOptions() {
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public void setLastModified(Date lastModified) {
            this.lastModified = lastModified;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setExpiresBy(Date date) {
        }

        public void setAsAttachement() {
            this.isAttachment = true;
        }
    }
}

