/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.selectinputtext;

import com.icesoft.faces.component.ext.HtmlInputText;
import com.icesoft.faces.component.ext.KeyEvent;
import com.icesoft.faces.component.ext.renderkit.FormRenderer;
import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.component.selectinputtext.TextChangeEvent;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.model.SelectItem;
import org.icefaces.impl.component.SeriesStateHolder;

public class SelectInputText
extends HtmlInputText
implements NamingContainer,
SeriesStateHolder {
    public static final String COMPONENT_TYPE = "com.icesoft.faces.SelectInputText";
    private String styleClass;
    public static final String RENDERER_TYPE = "com.icesoft.faces.SelectInputText";
    private String listVar = null;
    private Integer rows;
    private final int DEFAULT_MAX_MATCHS = 10;
    private String width;
    private final String DEFAULT_WIDTH = "150";
    private SelectItem selectedItem;
    private transient List itemList;
    private String options;
    private transient int index = -1;
    private MethodBinding textChangeListener;
    private transient List changedComponentIds;

    public SelectInputText() {
        this.setRendererType("com.icesoft.faces.SelectInputText");
        JavascriptContext.includeLib(JavascriptContext.ICE_EXTRAS, FacesContext.getCurrentInstance());
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
    }

    public void decode(FacesContext facesContext) {
        this.setSelectedItem(facesContext);
        super.decode(facesContext);
        if (Util.isEventSource(facesContext, (UIComponent)this)) {
            this.queueEventIfEnterKeyPressed(facesContext);
        }
    }

    private void setSelectedItem(FacesContext facesContext) {
        String selIdxStr;
        boolean changed;
        String clientId;
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(clientId = this.getClientId(facesContext));
        if (value != null && (changed = SelectInputText.isPartialSubmitKeypress(requestMap, clientId))) {
            this.setChangedComponentId(clientId);
            if (this.getTextChangeListener() != null) {
                Object oldValue = this.getSubmittedValue();
                if (oldValue == null) {
                    oldValue = DomBasicRenderer.converterGetAsString(facesContext, (UIComponent)this, this.getValue());
                }
                TextChangeEvent event = new TextChangeEvent((UIComponent)this, oldValue, value);
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
                this.queueEvent((FacesEvent)event);
            }
        }
        if ((selIdxStr = (String)requestMap.get(clientId + "_idx")) != null && selIdxStr.trim().length() > 0) {
            int selIdx = Integer.parseInt(selIdxStr);
            this.setSelectedIndex(selIdx);
            this.setChangedComponentId(clientId);
        } else {
            this.setSelectedItem(value);
        }
    }

    private static boolean isPartialSubmitKeypress(Map requestMap, String clientId) {
        String target = (String)requestMap.get("ice.event.target");
        String captured = (String)requestMap.get("ice.event.captured");
        if (target == null) {
            target = "";
        }
        if (captured == null) {
            captured = "";
        }
        if (!target.equals(clientId) && !captured.equals(clientId)) {
            return false;
        }
        String type = (String)requestMap.get("ice.event.type");
        String partialSubmit = (String)requestMap.get("ice.submit.partial");
        if (type == null || type.length() == 0 || partialSubmit == null || partialSubmit.length() == 0) {
            return false;
        }
        return partialSubmit.equalsIgnoreCase("true") && (type.equalsIgnoreCase("onundefined") || type.equalsIgnoreCase("onunknown") || type.equalsIgnoreCase("onkeypress") || type.equalsIgnoreCase("onkeydown"));
    }

    private boolean hadFocus(FacesContext facesContext) {
        Object focusId = facesContext.getExternalContext().getRequestParameterMap().get(FormRenderer.getFocusElementId());
        boolean focus = false;
        if (focusId != null && focusId.toString().equals(this.getClientId(facesContext))) {
            focus = true;
        }
        this.setFocus(focus);
        return focus;
    }

    public Iterator getItemList() {
        if (this.itemList == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.itemList.iterator();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getClientId(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        String baseClientId = super.getClientId(context);
        if (this.index >= 0) {
            return baseClientId + UINamingContainer.getSeparatorChar((FacesContext)context) + this.index++;
        }
        return baseClientId;
    }

    void resetId(UIComponent component) {
        String id = component.getId();
        component.setId(id);
        if (component.getChildCount() == 0) {
            return;
        }
        for (UIComponent kid : component.getChildren()) {
            this.resetId(kid);
        }
    }

    void populateItemList() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.itemList = this.getSelectFacet() != null ? this.getListValue() : Util.getSelectItems(facesContext, (UIComponent)this);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        MethodBinding mb;
        super.broadcast(event);
        if (event instanceof TextChangeEvent && (mb = this.getTextChangeListener()) != null) {
            mb.invoke(FacesContext.getCurrentInstance(), new Object[]{event});
        }
    }

    public UIComponent getSelectFacet() {
        return this.getFacet("selectInputText");
    }

    protected void setSelectedIndex(int index) {
        SelectItem selItm = null;
        if (index >= 0) {
            if (this.itemList == null) {
                this.populateItemList();
            }
            if (this.itemList != null && index < this.itemList.size()) {
                selItm = (SelectItem)this.itemList.get(index);
            }
        }
        this.selectedItem = selItm;
    }

    public void setSelectedItem(String key) {
        SelectItem selItm = null;
        if (key != null) {
            if (this.itemList == null) {
                this.populateItemList();
            }
            if (this.itemList != null) {
                SelectItem sticky = null;
                boolean multipleMatches = false;
                FacesContext facesContext = FacesContext.getCurrentInstance();
                for (int i = 0; i < this.itemList.size(); ++i) {
                    SelectItem item = (SelectItem)this.itemList.get(i);
                    String itemLabel = item.getLabel();
                    if (itemLabel == null) {
                        itemLabel = DomBasicRenderer.converterGetAsString(facesContext, (UIComponent)this, item.getValue());
                    }
                    if (!key.equals(itemLabel)) continue;
                    if (this.selectedItem != null && this.selectedItem.equals(item)) {
                        sticky = item;
                    }
                    multipleMatches |= selItm != null;
                    selItm = item;
                }
                if (sticky != null) {
                    selItm = sticky;
                } else if (multipleMatches) {
                    selItm = null;
                }
            }
        }
        this.selectedItem = selItm;
    }

    public SelectItem getSelectedItem() {
        return this.selectedItem;
    }

    public void setRows(int rows) {
        this.rows = new Integer(rows);
    }

    public int getRows() {
        if (this.rows != null) {
            return this.rows;
        }
        ValueBinding vb = this.getValueBinding("rows");
        return vb != null ? Integer.parseInt(vb.getValue(this.getFacesContext()).toString()) : 10;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setListVar(String listVar) {
        this.listVar = listVar;
    }

    public String getListVar() {
        if (this.listVar != null) {
            return this.listVar;
        }
        ValueBinding vb = this.getValueBinding("listVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setListValue(List listValue) {
        this.itemList = listValue;
    }

    public List getListValue() {
        ValueBinding vb = this.getValueBinding("listValue");
        return (List)vb.getValue(FacesContext.getCurrentInstance());
    }

    public String getWidth() {
        if (this.width != null) {
            return this.width;
        }
        ValueBinding vb = this.getValueBinding("width");
        return vb != null ? vb.getValue(this.getFacesContext()).toString() : "150";
    }

    String getWidthAsStyle() {
        try {
            int width = Integer.parseInt(this.getWidth());
            return "width:" + width + "px;";
        }
        catch (NumberFormatException e) {
            return "width:" + this.getWidth().trim();
        }
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.styleClass, "iceSelInpTxt", "styleClass", this.isDisabled());
    }

    public String getInputTextClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "Txt", this.isDisabled());
    }

    public String getListClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "List", this.isDisabled());
    }

    public String getRowClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "Row", this.isDisabled());
    }

    public String getSelectedRowClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "SelRow", this.isDisabled());
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public MethodBinding getTextChangeListener() {
        return this.textChangeListener;
    }

    public void setTextChangeListener(MethodBinding mb) {
        this.textChangeListener = mb;
    }

    void setChangedComponentId(Object id) {
        if (id == null) {
            if (this.changedComponentIds != null) {
                this.changedComponentIds.clear();
            }
        } else {
            if (this.changedComponentIds == null) {
                this.changedComponentIds = new ArrayList(6);
            }
            this.changedComponentIds.add(id);
        }
    }

    boolean hasChanged() {
        if (this.changedComponentIds == null) {
            return false;
        }
        return this.changedComponentIds.contains(this.getClientId(FacesContext.getCurrentInstance()));
    }

    private void queueEventIfEnterKeyPressed(FacesContext facesContext) {
        try {
            Map requestParemeterMap = facesContext.getExternalContext().getRequestParameterMap();
            KeyEvent keyEvent = new KeyEvent((UIComponent)this, requestParemeterMap);
            if (keyEvent.getKeyCode() == 13) {
                this.queueEvent((FacesEvent)new ActionEvent((UIComponent)this));
            }
            if ("true".equals(requestParemeterMap.get("ice.event.left"))) {
                this.queueEvent((FacesEvent)new ActionEvent((UIComponent)this));
            } else if ("onclick".equals(requestParemeterMap.get("ice.event.type"))) {
                this.queueEvent((FacesEvent)new ActionEvent((UIComponent)this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.styleClass, this.listVar, this.rows, this.width, this.options, SelectInputText.saveAttachedState((FacesContext)context, (Object)this.textChangeListener), this.selectedItem == null || this.selectedItem.getValue() == null || this.selectedItem.getValue() instanceof Serializable ? this.selectedItem : null};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.styleClass = (String)values[1];
        this.listVar = (String)values[2];
        this.rows = (Integer)values[3];
        this.width = (String)values[4];
        this.options = (String)values[5];
        this.textChangeListener = (MethodBinding)SelectInputText.restoreAttachedState((FacesContext)context, (Object)values[6]);
        this.selectedItem = (SelectItem)values[7];
    }

    public String getOnkeypress() {
        if (this.isDisabled() || this.isReadonly()) {
            return "";
        }
        return super.getOnkeypress();
    }

    public Object saveSeriesState(FacesContext facesContext) {
        Object[] values = new Object[]{this.styleClass, this.listVar, this.rows, this.width, this.options, this.selectedItem == null || this.selectedItem.getValue() == null || this.selectedItem.getValue() instanceof Serializable ? this.selectedItem : null};
        return values;
    }

    public void restoreSeriesState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        this.styleClass = (String)values[0];
        this.listVar = (String)values[1];
        this.rows = (Integer)values[2];
        this.width = (String)values[3];
        this.options = (String)values[4];
        this.selectedItem = (SelectItem)values[5];
    }
}

