/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.selectinputtext;

import com.icesoft.faces.component.selectinputtext.SelectInputText;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicInputRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.util.pooling.ClientIdPool;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.icefaces.impl.util.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SelectInputTextRenderer
extends DomBasicInputRenderer {
    private static final String AUTOCOMPLETE_DIV = "_div";
    static final String AUTOCOMPLETE_INDEX = "_idx";
    private static final Log log = LogFactory.getLog(SelectInputTextRenderer.class);
    private static final String[] passThruAttributes = new String[]{"accesskey", "alt", "dir", "lang", "maxlength", "onchange", "onclick", "ondblclick", "onkeypress", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onselect", "rows", "size", "style", "title", "width"};

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        SelectInputTextRenderer.validateParameters(facesContext, uiComponent, null);
        if (log.isTraceEnabled()) {
            log.trace((Object)"encodeBegin");
        }
        SelectInputText component = (SelectInputText)uiComponent;
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        String clientId = uiComponent.getClientId(facesContext);
        String divId = ClientIdPool.get(clientId + AUTOCOMPLETE_DIV);
        if (!domContext.isInitialized()) {
            Element root = domContext.createRootElement("div");
            Element input = domContext.createElement("input");
            input.setAttribute("type", "text");
            SelectInputTextRenderer.setRootElementId(facesContext, input, uiComponent);
            root.appendChild(input);
            input.setAttribute("name", clientId);
            input.setAttribute("class", component.getInputTextClass());
            String mousedownScript = (String)uiComponent.getAttributes().get("onmousedown");
            input.setAttribute("onmousedown", SelectInputTextRenderer.combinedPassThru(mousedownScript, "this.focus();"));
            String inputStyle = component.getWidthAsStyle();
            if (inputStyle != null && inputStyle.length() > 0) {
                input.setAttribute("style", inputStyle);
            } else {
                input.removeAttribute("style");
            }
            input.setAttribute("autocomplete", "off");
            Element div = domContext.createElement("div");
            String listClass = component.getListClass();
            div.setAttribute("id", divId);
            if (listClass == null) {
                div.setAttribute("style", "display:none;border:1px solid black;background-color:white;z-index:500;");
            } else {
                div.setAttribute("class", listClass);
            }
            root.appendChild(div);
            Element index = domContext.createElement("input");
            index.setAttribute("type", "hidden");
            String indexId = ClientIdPool.get(clientId + AUTOCOMPLETE_INDEX);
            index.setAttribute("name", indexId);
            root.appendChild(index);
            String rootStyle = component.getStyle();
            if (rootStyle != null && rootStyle.length() > 0) {
                root.setAttribute("style", rootStyle);
            } else {
                root.removeAttribute("style");
            }
            root.setAttribute("class", component.getStyleClass());
            if (log.isDebugEnabled()) {
                log.debug((Object)("SelectInputText:encodeBegin():component created with the following id : " + clientId));
            }
            PassThruAttributeRenderer.renderHtmlAttributes(facesContext, uiComponent, input, null, passThruAttributes);
            PassThruAttributeRenderer.renderHtmlAttributes(facesContext, uiComponent, input, null, new String[]{"tabindex"});
            PassThruAttributeRenderer.renderBooleanAttributes(facesContext, uiComponent, input, PassThruAttributeRenderer.EMPTY_STRING_ARRAY);
            Element scriptEle = domContext.createElement("script");
            scriptEle.setAttribute("id", ClientIdPool.get(clientId + "script"));
            scriptEle.setAttribute("type", "text/javascript");
            boolean partialSubmit = component.getPartialSubmit();
            if (!component.isDisabled() && !component.isReadonly()) {
                Text node = domContext.createTextNodeUnescaped("new Ice.Autocompleter('" + clientId + "','" + divId + "', " + component.getOptions() + " ,'" + component.getRowClass() + "','" + component.getSelectedRowClass() + "'," + partialSubmit + ");");
                scriptEle.appendChild(node);
            }
            root.appendChild(scriptEle);
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String value;
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        SelectInputText component = (SelectInputText)uiComponent;
        Element input = (Element)domContext.getRootNode().getFirstChild();
        String combinedValue = "setFocus(this.id);";
        Object appValue = uiComponent.getAttributes().get("onfocus");
        if (appValue != null) {
            combinedValue = combinedValue + appValue.toString();
        }
        input.setAttribute("onfocus", combinedValue);
        combinedValue = "setFocus('');";
        appValue = uiComponent.getAttributes().get("onblur");
        if (appValue != null) {
            combinedValue = combinedValue + appValue.toString();
        }
        input.setAttribute("onblur", combinedValue);
        appValue = uiComponent.getAttributes().get("onchange");
        if (appValue != null) {
            input.setAttribute("onchange", appValue.toString());
        }
        if ((value = this.getValue(facesContext, uiComponent)) != null) {
            input.setAttribute("value", value);
            if (component.hasChanged()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SelectInputText:encodeChildren(): component's value have been changed, start populating list : ");
                }
                this.populateList(facesContext, component);
                component.setChangedComponentId(null);
            }
        }
        domContext.stepOver();
    }

    public void populateList(FacesContext facesContext, SelectInputText component) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"populateList");
        }
        component.populateItemList();
        Iterator matches = component.getItemList();
        int rows = component.getRows();
        if (rows == 0) {
            rows = Integer.MAX_VALUE;
        }
        int rowCounter = 0;
        if (component.getSelectFacet() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SelectInputText:populateList(): \"selectInputText\" facet found, generate generic html for list");
            }
            UIComponent facet = component.getSelectFacet();
            DOMContext domContext = DOMContext.getDOMContext(facesContext, (UIComponent)component);
            Element listDiv = domContext.createElement("div");
            Map requestMap = facesContext.getExternalContext().getRequestMap();
            component.setIndex(0);
            while (matches.hasNext() && rowCounter++ < rows) {
                Element div = domContext.createElement("div");
                SelectItem item = (SelectItem)matches.next();
                requestMap.put(component.getListVar(), item.getValue());
                listDiv.appendChild(div);
                Element spanToDisplay = domContext.createElement("span");
                spanToDisplay.setAttribute("class", "informal");
                div.appendChild(spanToDisplay);
                domContext.setCursorParent(spanToDisplay);
                SelectInputTextRenderer.encodeParentAndChildren(facesContext, facet);
                Element spanToSelect = domContext.createElement("span");
                spanToSelect.setAttribute("style", "visibility:hidden;display:none;");
                String itemLabel = item.getLabel();
                if (itemLabel == null) {
                    itemLabel = SelectInputTextRenderer.converterGetAsString(facesContext, (UIComponent)component, item.getValue());
                }
                Text label = domContext.createTextNode(itemLabel);
                spanToSelect.appendChild(label);
                div.appendChild(spanToSelect);
                component.resetId(facet);
            }
            component.setIndex(-1);
            String nodeValue = DOMUtils.nodeToString((Node)listDiv).replaceAll("\n", "");
            String call = "Ice.Scriptaculous.Autocompleter.Finder.find('" + component.getClientId(facesContext) + "').updateNOW('" + SelectInputTextRenderer.escapeSingleQuote(nodeValue) + "');";
            JavascriptContext.addJavascriptCall(facesContext, call);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SelectInputText:populateList(): \"selectItem(s)\" found, generate plain-text for list");
            }
            if (matches.hasNext()) {
                StringBuffer sb = new StringBuffer("<div>");
                SelectItem item = null;
                while (matches.hasNext() && rowCounter++ < rows) {
                    item = (SelectItem)matches.next();
                    String itemLabel = item.getLabel();
                    if (itemLabel == null) {
                        itemLabel = SelectInputTextRenderer.converterGetAsString(facesContext, (UIComponent)component, item.getValue());
                    }
                    sb.append("<div>").append(DOMUtils.escapeAnsi((String)itemLabel)).append("</div>");
                }
                sb.append("</div>");
                String call = "Ice.Scriptaculous.Autocompleter.Finder.find('" + component.getClientId(facesContext) + "').updateNOW('" + SelectInputTextRenderer.escapeSingleQuote(sb.toString()) + "');";
                JavascriptContext.addJavascriptCall(facesContext, call);
            }
        }
    }

    private static String escapeSingleQuote(String text) {
        if (null == text) {
            return "";
        }
        char[] chars = text.toCharArray();
        StringBuilder buffer = new StringBuilder(chars.length);
        for (int index = 0; index < chars.length; ++index) {
            char ch = chars[index];
            if (ch == '\'') {
                buffer.append("&#39;");
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }
}

