/**
 *
 * Copyright 2016 Fernando Ramirez
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jivesoftware.smackx.blocking.provider;

import org.jivesoftware.smack.provider.ExtensionElementProvider;

import org.jivesoftware.smackx.blocking.element.BlockedErrorExtension;

import org.xmlpull.v1.XmlPullParser;

/**
 * Blocked error extension class.
 *
 * @author Fernando Ramirez
 * @see <a href="http://xmpp.org/extensions/xep-0191.html">XEP-0191: Blocking
 *      Command</a>
 */
public class BlockedErrorExtensionProvider extends ExtensionElementProvider<BlockedErrorExtension> {

    @Override
    public BlockedErrorExtension parse(XmlPullParser parser, int initialDepth) throws Exception {
        return new BlockedErrorExtension();
    }

}
