/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.xml.xpp3;

import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smack.xml.XmlPullParserFactory;
import org.jivesoftware.smack.xml.xpp3.Xpp3XmlPullParser;
import org.xmlpull.v1.XmlPullParser;

public class Xpp3XmlPullParserFactory
implements XmlPullParserFactory {
    private static final Logger LOGGER = Logger.getLogger(Xpp3XmlPullParserFactory.class.getName());
    private static final org.xmlpull.v1.XmlPullParserFactory XPP3_XML_PULL_PARSER_FACTORY;
    public static final String FEATURE_XML_ROUNDTRIP = "http://xmlpull.org/v1/doc/features.html#xml-roundtrip";
    public static final boolean XML_PULL_PARSER_SUPPORTS_ROUNDTRIP;

    public Xpp3XmlPullParser newXmlPullParser(Reader reader) throws XmlPullParserException {
        XmlPullParser xpp3XmlPullParser;
        try {
            xpp3XmlPullParser = XPP3_XML_PULL_PARSER_FACTORY.newPullParser();
            xpp3XmlPullParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            xpp3XmlPullParser.setInput(reader);
        }
        catch (org.xmlpull.v1.XmlPullParserException e) {
            throw new XmlPullParserException((Exception)((Object)e));
        }
        if (XML_PULL_PARSER_SUPPORTS_ROUNDTRIP) {
            try {
                xpp3XmlPullParser.setFeature(FEATURE_XML_ROUNDTRIP, true);
            }
            catch (org.xmlpull.v1.XmlPullParserException e) {
                LOGGER.log(Level.SEVERE, "XmlPullParser does not support XML_ROUNDTRIP, although it was first determined to be supported", e);
            }
        }
        return new Xpp3XmlPullParser(xpp3XmlPullParser);
    }

    static {
        boolean roundtrip = false;
        try {
            XPP3_XML_PULL_PARSER_FACTORY = org.xmlpull.v1.XmlPullParserFactory.newInstance();
            XmlPullParser xmlPullParser = XPP3_XML_PULL_PARSER_FACTORY.newPullParser();
            try {
                xmlPullParser.setFeature(FEATURE_XML_ROUNDTRIP, true);
                roundtrip = true;
            }
            catch (org.xmlpull.v1.XmlPullParserException e) {
                LOGGER.log(Level.FINEST, "XmlPullParser does not support XML_ROUNDTRIP", e);
            }
        }
        catch (org.xmlpull.v1.XmlPullParserException e) {
            throw new AssertionError((Object)e);
        }
        XML_PULL_PARSER_SUPPORTS_ROUNDTRIP = roundtrip;
    }
}

