/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EntityManagerFactoryRegistry {
    private static final Log log = LogFactory.getLog(EntityManagerFactoryRegistry.class);
    private Map<String, EntityManagerFactory> registry = new HashMap<String, EntityManagerFactory>();
    private Map<String, AtomicInteger> usage = new HashMap<String, AtomicInteger>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory getEntityManagerFactory(String persistenceUnitName) {
        EntityManagerFactoryRegistry entityManagerFactoryRegistry = this;
        synchronized (entityManagerFactoryRegistry) {
            if (!this.registry.containsKey(persistenceUnitName)) {
                EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)persistenceUnitName);
                this.registry.put(persistenceUnitName, emf);
                this.usage.put(persistenceUnitName, new AtomicInteger(1));
                return emf;
            }
            this.incrementUsage(persistenceUnitName);
            return this.registry.get(persistenceUnitName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeEntityManagerFactory(String persistenceUnitName) {
        EntityManagerFactoryRegistry entityManagerFactoryRegistry = this;
        synchronized (entityManagerFactoryRegistry) {
            if (!this.registry.containsKey(persistenceUnitName)) {
                return;
            }
            int count = this.decrementUsage(persistenceUnitName);
            if (count == 0) {
                EntityManagerFactory emf = this.registry.remove(persistenceUnitName);
                try {
                    if (emf.isOpen()) {
                        emf.close();
                    }
                }
                catch (IllegalStateException e) {
                    log.warn((Object)("Entity manager factory was already closed: " + persistenceUnitName));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        EntityManagerFactoryRegistry entityManagerFactoryRegistry = this;
        synchronized (entityManagerFactoryRegistry) {
            for (Map.Entry<String, EntityManagerFactory> entry : this.registry.entrySet()) {
                try {
                    if (!entry.getValue().isOpen()) continue;
                    entry.getValue().close();
                }
                catch (IllegalStateException e) {
                    log.warn((Object)("Entity manager factory was already closed: " + entry.getKey()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int incrementUsage(String persistenceUnitName) {
        EntityManagerFactoryRegistry entityManagerFactoryRegistry = this;
        synchronized (entityManagerFactoryRegistry) {
            return this.usage.get(persistenceUnitName).incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int decrementUsage(String persistenceUnitName) {
        EntityManagerFactoryRegistry entityManagerFactoryRegistry = this;
        synchronized (entityManagerFactoryRegistry) {
            return this.usage.get(persistenceUnitName).decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getUsage(String persistenceUnitName) {
        EntityManagerFactoryRegistry entityManagerFactoryRegistry = this;
        synchronized (entityManagerFactoryRegistry) {
            return this.usage.get(persistenceUnitName).intValue();
        }
    }
}

