/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.AbstractCacheStore;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.remote.RemoteCacheStoreConfig;
import org.infinispan.loaders.remote.logging.Log;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
@CacheLoaderMetadata(configurationClass=RemoteCacheStoreConfig.class)
public class RemoteCacheStore
extends AbstractCacheStore {
    private static final Log log = (Log)LogFactory.getLog(RemoteCacheStore.class, Log.class);
    private volatile RemoteCacheStoreConfig config;
    private volatile RemoteCacheManager remoteCacheManager;
    private volatile RemoteCache<Object, Object> remoteCache;
    private static final String LIFESPAN = "lifespan";
    private static final String MAXIDLE = "maxidle";

    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        return (InternalCacheEntry)this.remoteCache.get(key);
    }

    protected void purgeInternal() throws CacheLoaderException {
        if (log.isTraceEnabled()) {
            log.trace("Skipping purge call, as this is performed on the remote cache.");
        }
    }

    public boolean containsKey(Object key) throws CacheLoaderException {
        return this.remoteCache.containsKey(key);
    }

    public void store(InternalCacheEntry entry) throws CacheLoaderException {
        if (log.isTraceEnabled()) {
            log.tracef("Adding entry: %s", entry);
        }
        this.remoteCache.put(entry.getKey(), (Object)entry, this.toSeconds(entry.getLifespan(), entry, LIFESPAN), TimeUnit.SECONDS, this.toSeconds(entry.getMaxIdle(), entry, MAXIDLE), TimeUnit.SECONDS);
    }

    public void fromStream(ObjectInput inputStream) throws CacheLoaderException {
        try {
            Map result = (Map)this.marshaller.objectFromObjectStream(inputStream);
            this.remoteCache.putAll(result);
        }
        catch (Exception e) {
            throw new CacheLoaderException("Exception while reading data", (Throwable)e);
        }
    }

    public void toStream(ObjectOutput outputStream) throws CacheLoaderException {
        Map map = this.remoteCache.getBulk();
        try {
            this.marshaller.objectToObjectStream((Object)map, outputStream);
        }
        catch (IOException e) {
            throw new CacheLoaderException("Exception while serializing remote data to stream", (Throwable)e);
        }
    }

    public void clear() throws CacheLoaderException {
        this.remoteCache.clear();
    }

    public boolean remove(Object key) throws CacheLoaderException {
        return this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove(key) != null;
    }

    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        Map map = this.remoteCache.getBulk();
        return this.convertToInternalCacheEntries(map);
    }

    public Set<InternalCacheEntry> load(int numEntries) throws CacheLoaderException {
        return this.convertToInternalCacheEntries(this.remoteCache.getBulk(numEntries));
    }

    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        log.sharedModeOnlyAllowed();
        throw new CacheLoaderException("RemoteCacheStore can only run in shared mode! This method shouldn't be called in shared mode");
    }

    public void init(CacheLoaderConfig config, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        super.init(config, cache, m);
        this.config = (RemoteCacheStoreConfig)config;
    }

    public void start() throws CacheLoaderException {
        super.start();
        StreamingMarshaller marshaller = this.getMarshaller();
        if (marshaller == null) {
            throw new IllegalStateException("Null marshaller not allowed!");
        }
        this.remoteCacheManager = new RemoteCacheManager((Marshaller)marshaller, this.config.getHotRodClientProperties(), true, this.config.getClassLoader(), this.config.getAsyncExecutorFactory());
        this.remoteCache = this.config.getRemoteCacheName().equals("___defaultcache") ? this.remoteCacheManager.getCache() : this.remoteCacheManager.getCache(this.config.getRemoteCacheName());
    }

    public void stop() throws CacheLoaderException {
        super.stop();
        this.remoteCacheManager.stop();
    }

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return RemoteCacheStoreConfig.class;
    }

    private long toSeconds(long millis, InternalCacheEntry entry, String desc) {
        if (millis > 0L && millis < 1000L) {
            if (log.isTraceEnabled()) {
                log.tracef("Adjusting %s time for (k,v): (%s, %s) from %d millis to 1 sec, as milliseconds are not supported by HotRod", new Object[]{desc, entry.getKey(), entry.getValue(), millis});
            }
            return 1L;
        }
        return TimeUnit.MILLISECONDS.toSeconds(millis);
    }

    private Set<InternalCacheEntry> convertToInternalCacheEntries(Map<Object, Object> map) {
        HashSet<InternalCacheEntry> result = new HashSet<InternalCacheEntry>(map.size());
        Set<Map.Entry<Object, Object>> set = map.entrySet();
        for (Map.Entry<Object, Object> e : set) {
            result.add((InternalCacheEntry)e.getValue());
        }
        return result;
    }
}

