/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.shell;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import org.infinispan.cli.Config;

public class ConfigImpl
implements Config {
    private static final String CONFIG_FILE = "ispn-cli.ini";
    private final String configHome;
    private boolean colorsEnabled = true;
    private boolean historyEnabled = true;
    private String prompt = "[\\c{green}$CONNECTION\\c{yellow}/$CONTAINER\\c{yellow}/$CACHE\\c]> ";

    public ConfigImpl(String configHome) {
        this.configHome = configHome;
    }

    @Override
    public void load() {
        Properties p = new Properties();
        File configFile = new File(this.configHome, CONFIG_FILE);
        if (configFile.exists()) {
            try {
                BufferedReader r = new BufferedReader(new FileReader(configFile));
                p.load(r);
                ((Reader)r).close();
                if (p.containsKey("colors")) {
                    this.colorsEnabled = Boolean.parseBoolean(p.getProperty("colors"));
                }
                if (p.containsKey("history")) {
                    this.historyEnabled = Boolean.parseBoolean(p.getProperty("history"));
                }
                if (p.containsKey("prompt")) {
                    this.prompt = p.getProperty("prompt");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void save() {
        Properties p = new Properties();
        p.setProperty("colors", String.valueOf(this.colorsEnabled));
        p.setProperty("history", String.valueOf(this.historyEnabled));
        p.setProperty("prompt", this.prompt);
        File configDir = new File(this.configHome);
        File configFile = new File(this.configHome, CONFIG_FILE);
        try {
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            BufferedWriter w = new BufferedWriter(new FileWriter(configFile));
            p.store(w, null);
            ((Writer)w).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isColorEnabled() {
        return this.colorsEnabled;
    }

    @Override
    public boolean isHistoryEnabled() {
        return this.historyEnabled;
    }

    @Override
    public String getPrompt() {
        return this.prompt;
    }
}

