/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.net.SocketTimeoutException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.commons.CacheException;

public class Util {
    private static final long BIG_DELAY_NANOS = TimeUnit.DAYS.toNanos(1L);

    private Util() {
    }

    public static <T> T await(CompletableFuture<T> cf) {
        try {
            return cf.get(BIG_DELAY_NANOS, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HotRodClientException(e);
        }
        catch (ExecutionException e) {
            throw Util.rewrap(e);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T await(CompletableFuture<T> cf, long timeoutMillis) {
        try {
            return cf.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HotRodClientException(e);
        }
        catch (ExecutionException e) {
            throw Util.rewrap(e);
        }
        catch (TimeoutException e) {
            cf.cancel(false);
            throw new TransportException(new SocketTimeoutException(), null);
        }
    }

    protected static RuntimeException rewrap(ExecutionException e) {
        if (e.getCause() instanceof HotRodClientException) {
            return (HotRodClientException)e.getCause();
        }
        if (e.getCause() instanceof CacheException) {
            return (CacheException)e.getCause();
        }
        return new TransportException(e.getCause(), null);
    }
}

