/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import io.netty.channel.Channel;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.RemoteIllegalLifecycleStateException;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.iteration.KeyTracker;
import org.infinispan.client.hotrod.impl.iteration.KeyTrackerFactory;
import org.infinispan.client.hotrod.impl.operations.IterationEndResponse;
import org.infinispan.client.hotrod.impl.operations.IterationNextOperation;
import org.infinispan.client.hotrod.impl.operations.IterationNextResponse;
import org.infinispan.client.hotrod.impl.operations.IterationStartOperation;
import org.infinispan.client.hotrod.impl.operations.IterationStartResponse;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.CloseableIterator;

@NotThreadSafe
public class RemoteCloseableIterator<E>
implements CloseableIterator<Map.Entry<Object, E>> {
    private static final Log log = LogFactory.getLog(RemoteCloseableIterator.class);
    private final OperationsFactory operationsFactory;
    protected final Marshaller marshaller;
    private final String filterConverterFactory;
    private final byte[][] filterParams;
    private final Set<Integer> segments;
    private final int batchSize;
    private final boolean metadata;
    private final DataFormat dataFormat;
    private KeyTracker segmentKeyTracker;
    private Channel channel;
    private byte[] iterationId;
    private boolean endOfIteration = false;
    private boolean closed;
    private Queue<Map.Entry<Object, E>> nextElements = new LinkedList<Map.Entry<Object, E>>();

    public RemoteCloseableIterator(OperationsFactory operationsFactory, Marshaller marshaller, String filterConverterFactory, byte[][] filterParams, Set<Integer> segments, int batchSize, boolean metadata, DataFormat dataFormat) {
        this.marshaller = marshaller;
        this.filterConverterFactory = filterConverterFactory;
        this.filterParams = filterParams;
        this.segments = segments;
        this.batchSize = batchSize;
        this.operationsFactory = operationsFactory;
        this.metadata = metadata;
        this.dataFormat = dataFormat;
    }

    public RemoteCloseableIterator(OperationsFactory operationsFactory, Marshaller marshaller, int batchSize, Set<Integer> segments, boolean metadata, DataFormat dataFormat) {
        this(operationsFactory, marshaller, null, null, segments, batchSize, metadata, dataFormat);
    }

    public void close() {
        if (!this.closed) {
            try {
                IterationEndResponse endResponse = Util.await(this.operationsFactory.newIterationEndOperation(this.iterationId, this.channel).execute());
                short status = endResponse.getStatus();
                if (HotRodConstants.isSuccess(status) && Log.HOTROD.isDebugEnabled()) {
                    Log.HOTROD.iterationClosed(this.iterationId());
                }
                if (HotRodConstants.isInvalidIteration(status)) {
                    throw Log.HOTROD.errorClosingIteration(this.iterationId());
                }
            }
            catch (HotRodClientException e) {
                Log.HOTROD.ignoringErrorDuringIterationClose(this.iterationId(), e);
            }
            finally {
                this.closed = true;
            }
        }
    }

    private String iterationId() {
        return new String(this.iterationId, HotRodConstants.HOTROD_STRING_CHARSET);
    }

    public boolean hasNext() {
        if (!this.endOfIteration && this.nextElements.isEmpty()) {
            this.fetch();
        }
        return !this.endOfIteration;
    }

    public Map.Entry<Object, E> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextElements.remove();
    }

    private void fetch() {
        assert (!this.channel.eventLoop().inEventLoop());
        try {
            while (this.nextElements.isEmpty() && !this.endOfIteration) {
                IterationNextOperation iterationNextOperation = this.operationsFactory.newIterationNextOperation(this.iterationId, this.channel, this.segmentKeyTracker, this.dataFormat);
                IterationNextResponse iterationNextResponse = Util.await(iterationNextOperation.execute());
                if (!iterationNextResponse.hasMore()) {
                    this.endOfIteration = true;
                    this.close();
                    break;
                }
                this.nextElements.addAll(iterationNextResponse.getEntries());
            }
        }
        catch (RemoteIllegalLifecycleStateException | TransportException e) {
            log.warnf(e, "Error reaching the server during iteration", new Object[0]);
            this.startInternal(this.segmentKeyTracker.missedSegments());
            this.fetch();
        }
    }

    private IterationStartResponse startInternal(Set<Integer> segments) {
        if (log.isDebugEnabled()) {
            log.debugf("Starting iteration with segments %s", segments);
        }
        IterationStartOperation iterationStartOperation = this.operationsFactory.newIterationStartOperation(this.filterConverterFactory, this.filterParams, segments, this.batchSize, this.metadata, this.dataFormat);
        IterationStartResponse startResponse = (IterationStartResponse)Util.await(iterationStartOperation.execute());
        this.channel = startResponse.getChannel();
        this.iterationId = startResponse.getIterationId();
        if (log.isDebugEnabled()) {
            log.iterationTransportObtained(this.channel.remoteAddress(), this.iterationId());
            log.startedIteration(this.iterationId());
        }
        return startResponse;
    }

    public void start() {
        IterationStartResponse startResponse = this.startInternal(this.segments);
        this.segmentKeyTracker = KeyTrackerFactory.create(this.dataFormat, startResponse.getSegmentConsistentHash(), startResponse.getTopologyId(), this.segments);
    }
}

