/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transaction;

import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transaction.operations.CompleteTransactionOperation;
import org.infinispan.client.hotrod.impl.transaction.operations.ForgetTransactionOperation;
import org.infinispan.client.hotrod.impl.transaction.operations.RecoveryOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;

public class TransactionOperationFactory {
    private final Configuration configuration;
    private final ChannelFactory channelFactory;
    private final Codec codec;
    private final AtomicInteger topologyId;

    public TransactionOperationFactory(Configuration configuration, ChannelFactory channelFactory, Codec codec) {
        this.configuration = configuration;
        this.channelFactory = channelFactory;
        this.codec = codec;
        this.topologyId = channelFactory.createTopologyId(HotRodConstants.DEFAULT_CACHE_NAME_BYTES);
    }

    CompleteTransactionOperation newCompleteTransactionOperation(Xid xid, boolean commit) {
        return new CompleteTransactionOperation(this.codec, this.channelFactory, this.topologyId, this.configuration, xid, commit);
    }

    ForgetTransactionOperation newForgetTransactionOperation(Xid xid) {
        return new ForgetTransactionOperation(this.codec, this.channelFactory, this.topologyId, this.configuration, xid);
    }

    RecoveryOperation newRecoveryOperation() {
        return new RecoveryOperation(this.codec, this.channelFactory, this.topologyId, this.configuration);
    }
}

