/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Immutable
public class PingOperation
extends HotRodOperation {
    private static final Log log = LogFactory.getLog(PingOperation.class);
    private final Transport transport;

    public PingOperation(Flag[] flags, AtomicInteger topologyId, Transport transport) {
        super(flags, DEFAULT_CACHE_NAME_BYTES, topologyId);
        this.transport = transport;
    }

    @Override
    public Object execute() {
        boolean success;
        try {
            long messageId = this.writeHeader(this.transport, (short)23);
            short respStatus = this.readHeaderAndValidate(this.transport, messageId, (short)24);
            if (respStatus == 0) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Successfully validated transport: " + this.transport));
                }
                success = true;
            } else {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Unknown response status: " + respStatus));
                }
                success = false;
            }
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Failed to validate transport: " + this.transport), (Throwable)e);
            }
            success = false;
        }
        return success;
    }
}

