/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.client.hotrod.impl.transport.tcp.RequestBalancingStrategy;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class RoundRobinBalancingStrategy
implements RequestBalancingStrategy {
    private static final Log log = LogFactory.getLog(RoundRobinBalancingStrategy.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final AtomicInteger index = new AtomicInteger(0);
    private volatile InetSocketAddress[] servers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServers(Collection<InetSocketAddress> servers) {
        this.writeLock.lock();
        try {
            this.servers = servers.toArray(new InetSocketAddress[servers.size()]);
            this.index.set(0);
            if (log.isTraceEnabled()) {
                log.trace((Object)("New server list is: " + Arrays.toString(this.servers) + ". Resetting index to 0"));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetSocketAddress nextServer() {
        this.readLock.lock();
        try {
            InetSocketAddress server;
            InetSocketAddress inetSocketAddress = server = this.getServerByIndex(this.index.getAndIncrement());
            return inetSocketAddress;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public InetSocketAddress dryRunNextServer() {
        return this.getServerByIndex(this.index.get());
    }

    private InetSocketAddress getServerByIndex(int val) {
        int pos = val % this.servers.length;
        InetSocketAddress server = this.servers[pos];
        if (log.isTraceEnabled()) {
            log.trace((Object)("Returning server: " + server));
        }
        return server;
    }

    public InetSocketAddress[] getServers() {
        return this.servers;
    }

    public int getNextPosition() {
        return this.index.get() % this.servers.length;
    }
}

