/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.operations.IterationNextResponse;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;

public class IterationNextOperation
extends HotRodOperation {
    private final String iterationId;
    private final Transport transport;

    protected IterationNextOperation(Codec codec, Flag[] flags, byte[] cacheName, AtomicInteger topologyId, String iterationId, Transport transport) {
        super(codec, flags, cacheName, topologyId);
        this.iterationId = iterationId;
        this.transport = transport;
    }

    @Override
    public IterationNextResponse execute() {
        HeaderParams params = this.writeHeader(this.transport, (short)51);
        this.transport.writeString(this.iterationId);
        this.transport.flush();
        short status = this.readHeaderAndValidate(this.transport, params);
        byte[] finishedSegments = this.transport.readArray();
        int entriesSize = this.transport.readVInt();
        Map.Entry[] entries = new Map.Entry[entriesSize];
        if (entriesSize > 0) {
            int projectionsSize = this.transport.readVInt();
            for (int i = 0; i < entriesSize; ++i) {
                byte[] key = this.transport.readArray();
                Object[] projections = new Object[projectionsSize];
                for (int j = 0; j < projectionsSize; ++j) {
                    projections[j] = this.transport.readArray();
                }
                entries[i] = new AbstractMap.SimpleEntry<byte[], Object[]>(key, projections);
            }
        }
        return new IterationNextResponse(status, finishedSegments, entries);
    }
}

