/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import java.io.IOException;
import java.io.OutputStream;
import net.jcip.annotations.NotThreadSafe;
import org.infinispan.client.hotrod.impl.transport.Transport;

@NotThreadSafe
class TransportOutputStream
extends OutputStream {
    private final Transport transport;
    private final Runnable afterClose;
    private byte[] buf;
    private int count;

    public TransportOutputStream(Transport transport, Runnable afterClose) {
        this.transport = transport;
        this.buf = new byte[8192];
        this.afterClose = afterClose;
    }

    private void internalFlush() throws IOException {
        if (this.count > 0) {
            this.transport.writeArray(this.buf, 0, this.count);
            this.transport.flush();
            this.count = 0;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.internalFlush();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buf.length) {
            this.internalFlush();
            this.transport.writeArray(b, off, len);
            return;
        }
        if (len > this.buf.length - this.count) {
            this.internalFlush();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void flush() throws IOException {
        this.internalFlush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.transport.writeVInt(0);
        this.transport.flush();
        if (this.afterClose != null) {
            this.afterClose.run();
        }
    }
}

