/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.channel.Channel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.PlatformDependent;
import java.net.SocketAddress;
import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelInitializer;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelPoolCloseEvent;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelRecord;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

class ChannelPool {
    private static final AtomicIntegerFieldUpdater<TimeoutCallback> invokedUpdater = AtomicIntegerFieldUpdater.newUpdater(TimeoutCallback.class, "invoked");
    private static final Log log = LogFactory.getLog(ChannelPool.class);
    private static final int MAX_FULL_CHANNELS_SEEN = 10;
    private final Deque<Channel> channels = PlatformDependent.newConcurrentDeque();
    private final Deque<ChannelOperation> callbacks = PlatformDependent.newConcurrentDeque();
    private final EventExecutor executor;
    private final SocketAddress address;
    private final ChannelInitializer newChannelInvoker;
    private final ExhaustedAction exhaustedAction;
    private final long maxWait;
    private final int maxConnections;
    private final int maxPendingRequests;
    private final AtomicInteger created = new AtomicInteger();
    private final AtomicInteger active = new AtomicInteger();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile boolean terminated = false;

    ChannelPool(EventExecutor executor, SocketAddress address, ChannelInitializer newChannelInvoker, ExhaustedAction exhaustedAction, long maxWait, int maxConnections, int maxPendingRequests) {
        this.executor = executor;
        this.address = address;
        this.newChannelInvoker = newChannelInvoker;
        this.exhaustedAction = exhaustedAction;
        this.maxWait = maxWait;
        this.maxConnections = maxConnections;
        this.maxPendingRequests = maxPendingRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(ChannelOperation callback) {
        Channel channel;
        if (this.terminated) {
            callback.cancel(this.address, new RejectedExecutionException("Pool was terminated"));
            return;
        }
        int fullChannelsSeen = 0;
        while ((channel = this.channels.pollFirst()) != null) {
            if (!channel.isActive()) continue;
            if (!channel.isWritable() || ((HeaderDecoder)channel.pipeline().get(HeaderDecoder.class)).registeredOperations() >= this.maxPendingRequests) {
                this.channels.addLast(channel);
                if (++fullChannelsSeen >= 10) break;
                continue;
            }
            this.activateChannel(channel, callback, false);
            return;
        }
        int current = this.created.get();
        while (current < this.maxConnections) {
            if (this.created.compareAndSet(current, current + 1)) {
                this.active.incrementAndGet();
                this.createAndInvoke(callback);
                return;
            }
            current = this.created.get();
        }
        switch (this.exhaustedAction) {
            case EXCEPTION: {
                throw new NoSuchElementException("Reached maximum number of connections");
            }
            case WAIT: {
                break;
            }
            case CREATE_NEW: {
                this.created.incrementAndGet();
                this.active.incrementAndGet();
                this.createAndInvoke(callback);
                return;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf((Object)this.exhaustedAction));
            }
        }
        if (this.maxWait > 0L) {
            TimeoutCallback timeoutCallback = new TimeoutCallback(callback);
            timeoutCallback.timeoutFuture = this.executor.schedule((Runnable)timeoutCallback, this.maxWait, TimeUnit.MILLISECONDS);
            callback = timeoutCallback;
        }
        this.lock.writeLock().lock();
        try {
            do {
                if ((channel = this.channels.pollFirst()) != null) continue;
                this.callbacks.addLast(callback);
                return;
            } while (!channel.isActive());
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.activateChannel(channel, callback, false);
    }

    private void createAndInvoke(ChannelOperation callback) {
        try {
            this.newChannelInvoker.createChannel().whenComplete((channel, throwable) -> {
                if (throwable != null) {
                    int currentActive = this.active.decrementAndGet();
                    assert (currentActive >= 0);
                    int currentCreated = this.created.decrementAndGet();
                    assert (currentCreated >= 0);
                    callback.cancel(this.address, (Throwable)throwable);
                } else {
                    callback.invoke((Channel)channel);
                }
            });
        }
        catch (Throwable t) {
            this.active.decrementAndGet();
            this.created.decrementAndGet();
            callback.cancel(this.address, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Channel channel, ChannelRecord record) {
        ChannelOperation callback;
        boolean idle = record.isIdle();
        if (!idle) {
            int currentActive = this.active.decrementAndGet();
            assert (currentActive >= 0);
            record.setIdle();
        }
        if (!channel.isActive()) {
            int currentCreated = this.created.decrementAndGet();
            assert (currentCreated >= 0);
            return;
        }
        if (idle) {
            log.debugf("Not releasing idle non-closed channel %s", channel);
            assert (false);
            return;
        }
        if (this.terminated) {
            log.debugf("Closing %s due to termination", channel);
            channel.close();
            return;
        }
        this.lock.readLock().lock();
        try {
            callback = this.callbacks.pollFirst();
            if (callback == null) {
                this.channels.addFirst(channel);
                return;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.activateChannel(channel, callback, true);
    }

    private void activateChannel(Channel channel, ChannelOperation callback, boolean useExecutor) {
        assert (channel.isActive()) : "Channel " + channel + " is not active";
        this.active.incrementAndGet();
        ChannelRecord record = ChannelRecord.of(channel);
        record.setAcquired();
        if (useExecutor) {
            this.executor.execute(() -> {
                try {
                    callback.invoke(channel);
                }
                catch (Throwable t) {
                    log.tracef(t, "Requesting %s close due to exception", channel);
                    this.discardChannel(channel, record);
                }
            });
        } else {
            try {
                callback.invoke(channel);
            }
            catch (Throwable t) {
                log.tracef(t, "Requesting %s close due to exception", channel);
                this.discardChannel(channel, record);
                throw t;
            }
        }
    }

    private void discardChannel(Channel channel, ChannelRecord record) {
        try {
            channel.close();
        }
        finally {
            if (!record.isIdle()) {
                this.active.decrementAndGet();
                this.created.decrementAndGet();
            }
        }
    }

    public int getActive() {
        return this.active.get();
    }

    public int getIdle() {
        return Math.max(0, this.created.get() - this.active.get());
    }

    public void close() {
        this.terminated = true;
        this.lock.writeLock().lock();
        try {
            RejectedExecutionException cause = new RejectedExecutionException("Pool was terminated");
            this.callbacks.forEach(callback -> callback.cancel(this.address, cause));
            this.channels.forEach(channel -> channel.pipeline().fireUserEventTriggered((Object)ChannelPoolCloseEvent.INSTANCE));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private class TimeoutCallback
    implements ChannelOperation,
    Runnable {
        final ChannelOperation callback;
        volatile ScheduledFuture<?> timeoutFuture;
        volatile int invoked = 0;

        private TimeoutCallback(ChannelOperation callback) {
            this.callback = callback;
        }

        @Override
        public void run() {
            ChannelPool.this.callbacks.remove(this);
            if (invokedUpdater.compareAndSet(this, 0, 1)) {
                this.callback.cancel(ChannelPool.this.address, new TimeoutException("Timed out waiting for connection"));
            }
        }

        @Override
        public void invoke(Channel channel) {
            ScheduledFuture<?> timeoutFuture = this.timeoutFuture;
            if (timeoutFuture != null) {
                timeoutFuture.cancel(false);
            }
            if (invokedUpdater.compareAndSet(this, 0, 1)) {
                this.callback.invoke(channel);
            }
        }

        @Override
        public void cancel(SocketAddress address, Throwable cause) {
            throw new UnsupportedOperationException();
        }
    }
}

