/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

class TransportHelper {
    private static Log log = LogFactory.getLog(TransportHelper.class);
    private static final String USE_EPOLL_PROPERTY = "infinispan.server.channel.epoll";
    private static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase().startsWith("linux");
    private static final boolean EPOLL_DISABLED = System.getProperty("infinispan.server.channel.epoll", "true").equalsIgnoreCase("false");
    private static final boolean USE_NATIVE_EPOLL;

    TransportHelper() {
    }

    static Class<? extends SocketChannel> socketChannel() {
        return USE_NATIVE_EPOLL ? EpollSocketChannel.class : NioSocketChannel.class;
    }

    static EventLoopGroup createEventLoopGroup(int maxExecutors, ExecutorService executorService) {
        return USE_NATIVE_EPOLL ? new EpollEventLoopGroup(maxExecutors, (Executor)executorService) : new NioEventLoopGroup(maxExecutors, (Executor)executorService);
    }

    static {
        if (Epoll.isAvailable()) {
            USE_NATIVE_EPOLL = !EPOLL_DISABLED && IS_LINUX;
        } else {
            if (IS_LINUX) {
                log.epollNotAvailable(Epoll.unavailabilityCause().toString());
            }
            USE_NATIVE_EPOLL = false;
        }
    }
}

