/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration;

import java.util.List;
import java.util.Map;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.Json;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;

public class JsonReader {
    public void readJson(ConfigurationBuilderInfo builderInfo, String json) {
        this.readJson(builderInfo, "", Json.read(json));
    }

    private String extractQualifier(Json object) {
        if (object.isArray()) {
            return null;
        }
        if (object.isObject()) {
            Json aClass = object.asJsonMap().get("class");
            if (aClass == null) {
                return null;
            }
            if (!aClass.isObject() && !aClass.isArray()) {
                return aClass.getValue().toString();
            }
        }
        return null;
    }

    private void readJson(ConfigurationBuilderInfo builderInfo, String enclosing, Json json) {
        for (Map.Entry<String, Json> entry : json.asJsonMap().entrySet()) {
            String name = entry.getKey();
            Json value = entry.getValue();
            if (value.isArray()) {
                this.readArray(builderInfo, enclosing, name, value);
                continue;
            }
            if (value.isObject()) {
                ConfigurationBuilderInfo elementBuilderInfo = builderInfo.getBuilderInfo(name, this.extractQualifier(value));
                if (elementBuilderInfo != null) {
                    this.readJson(elementBuilderInfo, name, value);
                    continue;
                }
                this.readNestedAttribute(builderInfo, enclosing, name, value);
                continue;
            }
            this.readAttribute(builderInfo, enclosing, null, name, value.getValue());
        }
    }

    private void readNestedAttribute(ConfigurationBuilderInfo builderInfo, String element, String nesting, Json value) {
        AttributeSet attributes = builderInfo.attributes();
        if (attributes == null) {
            throw new CacheConfigurationException(String.format("Cannot find any attribute or element under '%s' to handle element '%s'", builderInfo, element));
        }
        for (Attribute<?> a : attributes.attributes()) {
            AttributeDefinition<?> attributeDefinition = a.getAttributeDefinition();
            AttributeSerializer<?, ConfigurationInfo, ConfigurationBuilderInfo> serializerConfig = attributeDefinition.getSerializerConfig();
            AttributeSerializer.SerializationMode serializationMode = serializerConfig.getSerializationMode();
            if (serializationMode != AttributeSerializer.SerializationMode.AS_ELEMENT || !serializerConfig.canRead(element, nesting, null, attributeDefinition)) continue;
            this.readAttribute(builderInfo, element, nesting, null, null);
        }
        Pair simpleAttribute1 = this.findSimpleAttribute(element, null, nesting, builderInfo);
        if (simpleAttribute1 != null) {
            this.readAttribute(builderInfo, element, null, nesting, value.getValue());
        }
        for (Map.Entry<String, Object> entry : value.asMap().entrySet()) {
            String attrName = entry.getKey();
            Object attrValue = entry.getValue();
            Pair simpleAttribute = this.findSimpleAttribute(element, nesting, attrName, builderInfo);
            if (simpleAttribute == null) continue;
            this.readAttribute(builderInfo, element, nesting, attrName, attrValue);
        }
    }

    private void readArray(ConfigurationBuilderInfo builderInfo, String enclosing, String name, Json value) {
        List<Json> elements = value.asJsonList();
        for (Json element : elements) {
            ConfigurationBuilderInfo readerForArray = builderInfo.getNewBuilderInfo(name);
            if (readerForArray != null) {
                this.readJson(readerForArray, name, element);
                continue;
            }
            Pair pair = this.findSimpleAttribute(enclosing, null, name, builderInfo);
            if (pair != null) {
                this.readAttribute(builderInfo, enclosing, null, name, value.getValue());
                continue;
            }
            throw new CacheConfigurationException(String.format("Found multiple '%s' elements under '%s', but cannot find builder info from array under'%s'", name, enclosing, builderInfo));
        }
    }

    private void readAttribute(ConfigurationBuilderInfo builderInfo, String enclosing, String nesting, String name, Object value) {
        Pair pair = this.findSimpleAttribute(enclosing, nesting, name, builderInfo);
        if (pair == null) {
            ElementDefinition element = builderInfo.getElementDefinition();
            if (element != null && element.isSynthetic(name)) {
                return;
            }
            throw new CacheConfigurationException(String.format("Could not find attribute definition for '%s' under '%s'", name, builderInfo));
        }
        this.readAttribute(enclosing, nesting, value, pair.attribute, pair.builderInfo);
    }

    private void readAttribute(String enclosing, String nesting, Object value, Attribute a, ConfigurationBuilderInfo builderInfo) {
        AttributeDefinition attributeDefinition = a.getAttributeDefinition();
        AttributeSerializer serializerConfig = attributeDefinition.getSerializerConfig();
        Object attrValue = serializerConfig.readAttributeValue(enclosing, nesting, attributeDefinition, value, builderInfo);
        a.set(attrValue);
    }

    private Pair findSimpleAttribute(String enclosing, String nesting, String name, ConfigurationBuilderInfo builderInfo) {
        AttributeSet attributes = builderInfo.attributes();
        if (attributes == null) {
            return null;
        }
        for (Attribute<?> attribute : attributes.attributes()) {
            AttributeDefinition<?> attributeDefinition = attribute.getAttributeDefinition();
            AttributeSerializer<?, ConfigurationInfo, ConfigurationBuilderInfo> serializerConfig = attributeDefinition.getSerializerConfig();
            if (!serializerConfig.canRead(enclosing, nesting, name, attributeDefinition)) continue;
            return new Pair(attribute, builderInfo);
        }
        for (ConfigurationBuilderInfo subReader : builderInfo.getChildrenInfo()) {
            Pair simpleAttribute;
            ElementDefinition element = subReader.getElementDefinition();
            if (element == null || element.isTopLevel() || (simpleAttribute = this.findSimpleAttribute(enclosing, nesting, name, subReader)) == null) continue;
            return simpleAttribute;
        }
        return null;
    }

    private static class Pair {
        Attribute<?> attribute;
        ConfigurationBuilderInfo builderInfo;

        Pair(Attribute<?> attribute, ConfigurationBuilderInfo builderInfo) {
            this.attribute = attribute;
            this.builderInfo = builderInfo;
        }
    }
}

