/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration;

import java.util.Collection;
import java.util.Map;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.Json;
import org.infinispan.commons.configuration.JsonWriter;

public class JsonCustomFactory
extends Json.DefaultFactory {
    private final JsonWriter writer = new JsonWriter();

    @Override
    public Json make(Object anything) {
        if (anything == null) {
            return Json.topnull;
        }
        if (anything instanceof Json) {
            return (Json)anything;
        }
        if (anything instanceof String) {
            return Json.factory().string((String)anything);
        }
        if (anything instanceof Collection) {
            Json L = this.array();
            for (Object x : (Collection)anything) {
                L.add(Json.factory().make(x));
            }
            return L;
        }
        if (anything instanceof Map) {
            Json O = this.object();
            for (Map.Entry x : ((Map)anything).entrySet()) {
                O.set(x.getKey().toString(), Json.factory().make(x.getValue()));
            }
            return O;
        }
        if (anything instanceof Boolean) {
            return Json.factory().bool((Boolean)anything);
        }
        if (anything instanceof Number) {
            return Json.factory().number((Number)anything);
        }
        if (anything instanceof Enum) {
            return Json.factory().string(anything.toString());
        }
        if (anything instanceof ConfigurationInfo) {
            Json object = this.object();
            this.writer.writeElement(object, (ConfigurationInfo)anything, false);
            return object;
        }
        if (anything instanceof Class) {
            return Json.factory().string(((Class)anything).getName());
        }
        if (anything.getClass().isArray()) {
            Class<?> comp = anything.getClass().getComponentType();
            if (!comp.isPrimitive()) {
                return Json.array((Object[])anything);
            }
            Json A = this.array();
            if (Boolean.TYPE == comp) {
                for (boolean b : (boolean[])anything) {
                    A.add(b);
                }
            } else if (Byte.TYPE == comp) {
                for (byte b : (byte[])anything) {
                    A.add(b);
                }
            } else if (Character.TYPE == comp) {
                for (char b : (char[])anything) {
                    A.add(Character.valueOf(b));
                }
            } else if (Short.TYPE == comp) {
                for (short b : (short[])anything) {
                    A.add(b);
                }
            } else if (Integer.TYPE == comp) {
                for (int b : (int[])anything) {
                    A.add(b);
                }
            } else if (Long.TYPE == comp) {
                for (long b : (long[])anything) {
                    A.add(b);
                }
            } else if (Float.TYPE == comp) {
                for (float b : (float[])anything) {
                    A.add(Float.valueOf(b));
                }
            } else if (Double.TYPE == comp) {
                for (double b : (double[])anything) {
                    A.add(b);
                }
            }
            return A;
        }
        return this.make(anything.getClass().getName());
    }
}

