/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.equivalence;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.equivalence.EquivalentHashMap;

public class EquivalentLinkedHashMap<K, V>
extends EquivalentHashMap<K, V> {
    private transient LinkedNode<K, V> header;
    private final IterationOrder iterationOrder;

    public EquivalentLinkedHashMap(int initialCapacity, float loadFactor, IterationOrder iterationOrder, Equivalence<? super K> keyEq, Equivalence<? super V> valueEq) {
        super(initialCapacity, loadFactor, keyEq, valueEq);
        this.iterationOrder = iterationOrder;
        this.addFirstEntry();
    }

    private void addFirstEntry() {
        this.header = this.createLinkedNode();
        this.header.before = this.header;
        this.header.after = this.header;
    }

    @Override
    void addEntry(int index, K key, V value, int hash) {
        super.addEntry(index, key, value, hash);
        LinkedNode eldest = this.header.after;
        if (this.removeEldestEntry(eldest)) {
            this.remove(eldest.getKey());
        }
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return false;
    }

    private <K, V> LinkedNode<K, V> createLinkedNode() {
        return new LinkedNode(null, -1, null, null);
    }

    @Override
    EquivalentHashMap.Node<K, V> createNode(K key, V value, int hash, EquivalentHashMap.Node<K, V> node) {
        LinkedNode linkedNode = new LinkedNode(key, hash, value, node);
        linkedNode.addBefore((LinkedNode)this.header);
        return linkedNode;
    }

    @Override
    public V get(Object key) {
        LinkedNode n = (LinkedNode)this.getNode(key);
        return n == null ? null : (V)n.recordAccess(this);
    }

    @Override
    public V remove(Object key) {
        LinkedNode prevNode = (LinkedNode)this.removeNode(key);
        return (V)(prevNode == null ? null : prevNode.remove());
    }

    @Override
    public void clear() {
        super.clear();
        this.header.before = this.header;
        this.header.after = this.header;
    }

    @Override
    Iterator<K> newKeyIterator() {
        return new KeyIterator(this);
    }

    @Override
    Iterator<V> newValueIterator() {
        return new ValueIterator(this);
    }

    @Override
    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator(this);
    }

    private class EntryIterator
    extends EquivalentLinkedHashIterator<Map.Entry<K, V>> {
        protected EntryIterator(EquivalentHashMap<K, V> map) {
            super(map);
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends EquivalentLinkedHashIterator<V> {
        protected ValueIterator(EquivalentHashMap<K, V> map) {
            super(map);
        }

        @Override
        public V next() {
            return this.nextEntry().val;
        }
    }

    private class KeyIterator
    extends EquivalentLinkedHashIterator<K> {
        protected KeyIterator(EquivalentHashMap<K, V> map) {
            super(map);
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private abstract class EquivalentLinkedHashIterator<T>
    implements Iterator<T> {
        final EquivalentHashMap<K, V> map;
        LinkedEntry<K, V> nextEntry;
        LinkedEntry<K, V> lastReturned = null;
        int expectedModCount;

        protected EquivalentLinkedHashIterator(EquivalentHashMap<K, V> map) {
            this.expectedModCount = EquivalentLinkedHashMap.this.modCount;
            this.map = map;
            this.nextEntry = new LinkedEntry<Object, Object>(((EquivalentLinkedHashMap)EquivalentLinkedHashMap.this).header.after.key, ((EquivalentLinkedHashMap)EquivalentLinkedHashMap.this).header.after.value, ((EquivalentLinkedHashMap)EquivalentLinkedHashMap.this).header.after.before, ((EquivalentLinkedHashMap)EquivalentLinkedHashMap.this).header.after.after, map);
        }

        @Override
        public boolean hasNext() {
            return !this.equals(this.nextEntry, EquivalentLinkedHashMap.this.header);
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (EquivalentLinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            EquivalentLinkedHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
            this.expectedModCount = EquivalentLinkedHashMap.this.modCount;
        }

        LinkedEntry<K, V> nextEntry() {
            if (EquivalentLinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.equals(this.nextEntry, EquivalentLinkedHashMap.this.header)) {
                throw new NoSuchElementException();
            }
            LinkedEntry e = this.nextEntry;
            this.lastReturned = this.nextEntry;
            this.nextEntry = new LinkedEntry<Object, Object>(e.after.key, e.after.value, e.after.before, e.after.after, this.map);
            return e;
        }

        boolean equals(LinkedEntry<K, V> entry, LinkedNode<K, V> node) {
            return entry.key == node.key && entry.val == node.value && entry.before == node.before && entry.after == node.after;
        }
    }

    private static class LinkedEntry<K, V>
    extends EquivalentHashMap.MapEntry<K, V> {
        LinkedNode<K, V> before;
        LinkedNode<K, V> after;

        LinkedEntry(K key, V val, LinkedNode<K, V> before, LinkedNode<K, V> after, EquivalentHashMap<K, V> map) {
            super(key, val, map);
            this.before = before;
            this.after = after;
        }
    }

    public static enum IterationOrder {
        ACCESS_ORDER,
        INSERT_ORDER;


        public boolean toJdkAccessOrder() {
            return this == ACCESS_ORDER;
        }
    }

    private static final class LinkedNode<K, V>
    extends EquivalentHashMap.Node<K, V> {
        LinkedNode<K, V> before;
        LinkedNode<K, V> after;

        private LinkedNode(K key, int hash, V value, EquivalentHashMap.Node<K, V> next) {
            super(key, hash, value, next);
        }

        private V remove() {
            this.before.after = this.after;
            this.after.before = this.before;
            return (V)this.value;
        }

        private void addBefore(LinkedNode<K, V> entry) {
            this.after = entry;
            this.before = entry.before;
            this.before.after = this;
            this.after.before = this;
        }

        V recordAccess(EquivalentHashMap<K, V> m) {
            EquivalentLinkedHashMap linkedMap = (EquivalentLinkedHashMap)m;
            if (linkedMap.iterationOrder == IterationOrder.ACCESS_ORDER) {
                ++linkedMap.modCount;
                this.remove();
                this.addBefore(linkedMap.header);
            }
            return (V)this.value;
        }
    }
}

