/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.BiFunction;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteKeyCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.Params;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class ReadWriteKeyValueCommand<K, V, T, R>
extends AbstractWriteKeyCommand<K, V> {
    private static final Log log = LogFactory.getLog(ReadWriteKeyValueCommand.class);
    public static final byte COMMAND_ID = 51;
    private Object argument;
    private BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> f;
    private Object prevValue;
    private Metadata prevMetadata;

    public ReadWriteKeyValueCommand(Object key, Object argument, BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> f, int segment, CommandInvocationId id, ValueMatcher valueMatcher, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion, ComponentRegistry componentRegistry) {
        super(key, valueMatcher, segment, id, params, keyDataConversion, valueDataConversion);
        this.argument = argument;
        this.f = f;
        this.init(componentRegistry);
    }

    public ReadWriteKeyValueCommand() {
    }

    @Override
    public byte getCommandId() {
        return 51;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.argument);
        output.writeObject(this.f);
        MarshallUtil.marshallEnum((Enum)this.valueMatcher, (ObjectOutput)output);
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)this.segment);
        Params.writeObject(output, this.params);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeObject(this.prevValue);
        output.writeObject(this.prevMetadata);
        DataConversion.writeTo(output, this.keyDataConversion);
        DataConversion.writeTo(output, this.valueDataConversion);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.argument = input.readObject();
        this.f = (BiFunction)input.readObject();
        this.valueMatcher = (ValueMatcher)MarshallUtil.unmarshallEnum((ObjectInput)input, ValueMatcher::valueOf);
        this.segment = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        this.params = Params.readObject(input);
        this.setFlagsBitSet(input.readLong());
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.prevValue = input.readObject();
        this.prevMetadata = (Metadata)input.readObject();
        this.keyDataConversion = DataConversion.readFrom(input);
        this.valueDataConversion = DataConversion.readFrom(input);
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadWriteKeyValueCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    @Override
    public String toString() {
        return "ReadWriteKeyValueCommand{" + "key=" + Util.toStr((Object)this.key) + ", argument=" + Util.toStr((Object)this.argument) + ", f=" + this.f.getClass().getName() + ", prevValue=" + Util.toStr((Object)this.prevValue) + ", prevMetadata=" + Util.toStr((Object)this.prevMetadata) + ", flags=" + this.printFlags() + ", commandInvocationId=" + this.commandInvocationId + ", topologyId=" + this.getTopologyId() + ", valueMatcher=" + (Object)((Object)this.valueMatcher) + ", successful=" + this.successful + ", keyDataConversion=" + this.keyDataConversion + ", valueDataConversion=" + this.valueDataConversion + "}";
    }

    @Override
    public Mutation toMutation(Object key) {
        return new Mutations.ReadWriteWithValue<K, V, T, R>(this.keyDataConversion, this.valueDataConversion, this.argument, this.f);
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        componentRegistry.wireDependencies(this.keyDataConversion);
        componentRegistry.wireDependencies(this.valueDataConversion);
        if (this.f instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.f)).inject(componentRegistry);
        }
    }

    public void setPrevValueAndMetadata(Object prevValue, Metadata prevMetadata) {
        this.prevMetadata = prevMetadata;
        this.prevValue = prevValue;
    }

    public Object getArgument() {
        return this.argument;
    }

    public BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> getBiFunction() {
        return this.f;
    }

    public Object getPrevValue() {
        return this.prevValue;
    }

    public Metadata getPrevMetadata() {
        return this.prevMetadata;
    }
}

