/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.cache.EncodingConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;

public class ContentTypeConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<ContentTypeConfiguration>,
ConfigurationBuilderInfo {
    private final AttributeSet attributes;
    private final boolean key;

    protected ContentTypeConfigurationBuilder(boolean key, EncodingConfigurationBuilder builder) {
        super(builder.getBuilder());
        this.key = key;
        this.attributes = ContentTypeConfiguration.attributeDefinitionSet();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return this.key ? ContentTypeConfiguration.KEY_ELEMENT_DEFINITION : ContentTypeConfiguration.VALUE_ELEMENT_DEFINITION;
    }

    public void validate() {
    }

    public ContentTypeConfigurationBuilder mediaType(String mediaType) {
        this.attributes.attribute(ContentTypeConfiguration.MEDIA_TYPE).set((Object)mediaType);
        return this;
    }

    public ContentTypeConfiguration create() {
        return new ContentTypeConfiguration(this.key, this.attributes.protect());
    }

    public ContentTypeConfigurationBuilder read(ContentTypeConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }
}

