/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.cache.ContentTypeConfigurationBuilder;
import org.infinispan.configuration.cache.EncodingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;

public class EncodingConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<EncodingConfiguration>,
ConfigurationBuilderInfo {
    private ContentTypeConfigurationBuilder keyContentTypeBuilder = new ContentTypeConfigurationBuilder(true, this);
    private ContentTypeConfigurationBuilder valueContentTypeBuilder = new ContentTypeConfigurationBuilder(false, this);
    private List<ConfigurationBuilderInfo> builders = new ArrayList<ConfigurationBuilderInfo>();

    EncodingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.builders.addAll(Arrays.asList(this.keyContentTypeBuilder, this.valueContentTypeBuilder));
    }

    public ElementDefinition getElementDefinition() {
        return EncodingConfiguration.ELEMENT_DEFINITION;
    }

    public void validate() {
        this.keyContentTypeBuilder.validate();
        this.valueContentTypeBuilder.validate();
    }

    public ContentTypeConfigurationBuilder key() {
        return this.keyContentTypeBuilder;
    }

    public ContentTypeConfigurationBuilder value() {
        return this.valueContentTypeBuilder;
    }

    public EncodingConfiguration create() {
        ContentTypeConfiguration keyContentType = this.keyContentTypeBuilder.create();
        ContentTypeConfiguration valueContentType = this.valueContentTypeBuilder.create();
        return new EncodingConfiguration(keyContentType, valueContentType);
    }

    public Builder<?> read(EncodingConfiguration template) {
        this.keyContentTypeBuilder = new ContentTypeConfigurationBuilder(true, this).read(template.keyDataType());
        this.valueContentTypeBuilder = new ContentTypeConfigurationBuilder(false, this).read(template.valueDataType());
        return this;
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        this.keyContentTypeBuilder.validate();
        this.valueContentTypeBuilder.validate();
    }

    public String toString() {
        return "DataTypeConfigurationBuilder{keyContentTypeBuilder=" + this.keyContentTypeBuilder + ", valueContentTypeBuilder=" + this.valueContentTypeBuilder + '}';
    }

    public Collection<ConfigurationBuilderInfo> getChildrenInfo() {
        return this.builders;
    }
}

