/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.GroupsConfigurationBuilder;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.distribution.group.Grouper;

public class GroupsConfiguration
implements Matchable<GroupsConfiguration>,
ConfigurationInfo {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false).immutable().build();
    public static final AttributeDefinition<List<Grouper<?>>> GROUPERS = AttributeDefinition.builder((String)"groupers", null, List.class).initializer(LinkedList::new).serializer(new AttributeSerializer<List<Grouper<?>>, GroupsConfiguration, GroupsConfigurationBuilder>(){

        public Object readAttributeValue(String enclosingElement, String nesting, AttributeDefinition attributeDefinition, Object attrValue, GroupsConfigurationBuilder builderInfo) {
            List values = (List)attrValue;
            return values.stream().map(v -> Util.getInstance((String)v, (ClassLoader)builderInfo.getClass().getClassLoader())).collect(Collectors.toList());
        }
    }).immutable().build();
    static final ElementDefinition ELEMENT_DEFINTION = new DefaultElementDefinition(Element.GROUPS.getLocalName());
    private final Attribute<Boolean> enabled;
    private final Attribute<List<Grouper<?>>> groupers;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GroupsConfiguration.class, new AttributeDefinition[]{ENABLED, GROUPERS});
    }

    GroupsConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.groupers = attributes.attribute(GROUPERS);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINTION;
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    public List<Grouper<?>> groupers() {
        return (List)this.groupers.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "GroupsConfiguration [attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupsConfiguration other = (GroupsConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }
}

