/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.hash.Hash;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.GroupsConfigurationBuilder;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class HashConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder
implements Builder<HashConfiguration>,
ConfigurationBuilderInfo {
    private static final Log log = LogFactory.getLog(HashConfigurationBuilder.class);
    private final AttributeSet attributes;
    private final GroupsConfigurationBuilder groupsConfigurationBuilder;
    private final List<ConfigurationBuilderInfo> subElements = new ArrayList<ConfigurationBuilderInfo>();

    HashConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
        this.attributes = HashConfiguration.attributeDefinitionSet();
        this.groupsConfigurationBuilder = new GroupsConfigurationBuilder(builder);
        this.subElements.add(this.groupsConfigurationBuilder);
    }

    public ElementDefinition getElementDefinition() {
        return HashConfiguration.ELEMENT_DEFINITION;
    }

    @Deprecated
    public HashConfigurationBuilder consistentHash(ConsistentHash consistentHash) {
        log.consistentHashDeprecated();
        return this;
    }

    public HashConfigurationBuilder consistentHashFactory(ConsistentHashFactory<? extends ConsistentHash> consistentHashFactory) {
        this.attributes.attribute(HashConfiguration.CONSISTENT_HASH_FACTORY).set(consistentHashFactory);
        return this;
    }

    public HashConfigurationBuilder numOwners(int numOwners) {
        if (numOwners < 1) {
            throw new IllegalArgumentException("numOwners cannot be less than 1");
        }
        this.attributes.attribute(HashConfiguration.NUM_OWNERS).set((Object)numOwners);
        return this;
    }

    boolean isNumOwnersSet() {
        return this.attributes.attribute(HashConfiguration.NUM_OWNERS).isModified();
    }

    int numOwners() {
        return (Integer)this.attributes.attribute(HashConfiguration.NUM_OWNERS).get();
    }

    @Deprecated
    public HashConfigurationBuilder numVirtualNodes(int numVirtualNodes) {
        log.hashNumVirtualNodesDeprecated();
        return this;
    }

    public HashConfigurationBuilder numSegments(int numSegments) {
        if (numSegments < 1) {
            throw new IllegalArgumentException("numSegments cannot be less than 1");
        }
        this.attributes.attribute(HashConfiguration.NUM_SEGMENTS).set((Object)numSegments);
        return this;
    }

    @Deprecated
    public HashConfigurationBuilder rehashEnabled() {
        this.stateTransfer().fetchInMemoryState(true);
        return this;
    }

    @Deprecated
    public HashConfigurationBuilder rehashEnabled(boolean enabled) {
        this.stateTransfer().fetchInMemoryState(enabled);
        return this;
    }

    @Deprecated
    public HashConfigurationBuilder rehashDisabled() {
        this.stateTransfer().fetchInMemoryState(false);
        return this;
    }

    @Deprecated
    public HashConfigurationBuilder rehashRpcTimeout(long rehashRpcTimeout) {
        this.stateTransfer().timeout(rehashRpcTimeout);
        return this;
    }

    @Deprecated
    public HashConfigurationBuilder rehashWait(long rehashWait) {
        return this;
    }

    @Deprecated
    public HashConfigurationBuilder hash(Hash hash) {
        this.attributes.attribute(HashConfiguration.HASH).set((Object)hash);
        return this;
    }

    public HashConfigurationBuilder capacityFactor(float capacityFactor) {
        if (capacityFactor < 0.0f) {
            throw new IllegalArgumentException("capacityFactor must be positive");
        }
        this.attributes.attribute(HashConfiguration.CAPACITY_FACTOR).set((Object)Float.valueOf(capacityFactor));
        return this;
    }

    public HashConfigurationBuilder keyPartitioner(KeyPartitioner keyPartitioner) {
        this.attributes.attribute(HashConfiguration.KEY_PARTITIONER).set((Object)keyPartitioner);
        return this;
    }

    public GroupsConfigurationBuilder groups() {
        return this.groupsConfigurationBuilder;
    }

    public void validate() {
        this.groupsConfigurationBuilder.validate();
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        this.groupsConfigurationBuilder.validate(globalConfig);
    }

    public HashConfiguration create() {
        return new HashConfiguration(this.attributes.protect(), this.groupsConfigurationBuilder.create(), this.stateTransfer().create());
    }

    public HashConfigurationBuilder read(HashConfiguration template) {
        this.attributes.read(template.attributes());
        this.groupsConfigurationBuilder.read(template.groups());
        return this;
    }

    public String toString() {
        return "HashConfigurationBuilder [attributes=" + this.attributes + ", groupsConfigurationBuilder=" + this.groupsConfigurationBuilder + "]";
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public Collection<ConfigurationBuilderInfo> getChildrenInfo() {
        return this.subElements;
    }
}

