/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;

public class InterceptorConfiguration
extends AbstractTypedPropertiesConfiguration
implements ConfigurationInfo {
    public static final AttributeDefinition<Position> POSITION = AttributeDefinition.builder((String)"position", (Object)((Object)Position.OTHER_THAN_FIRST_OR_LAST)).immutable().build();
    public static final AttributeDefinition<Class> AFTER = AttributeDefinition.builder((String)"after", null, Class.class).immutable().build();
    public static final AttributeDefinition<Class> BEFORE = AttributeDefinition.builder((String)"before", null, Class.class).immutable().build();
    public static final AttributeDefinition<AsyncInterceptor> INTERCEPTOR = AttributeDefinition.builder((String)"interceptor", null, AsyncInterceptor.class).copier(IdentityAttributeCopier.INSTANCE).immutable().build();
    public static final AttributeDefinition<Class> INTERCEPTOR_CLASS = AttributeDefinition.builder((String)"interceptorClass", null, Class.class).xmlName("class").immutable().build();
    public static final AttributeDefinition<Integer> INDEX = AttributeDefinition.builder((String)"index", (Object)-1).immutable().build();
    static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.INTERCEPTOR.getLocalName());
    private final Attribute<Position> position;
    private final Attribute<Class> after;
    private final Attribute<Class> before;
    private final Attribute<AsyncInterceptor> interceptor;
    private final Attribute<Class> interceptorClass;
    private final Attribute<Integer> index;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(InterceptorConfiguration.class, AbstractTypedPropertiesConfiguration.attributeSet(), new AttributeDefinition[]{POSITION, AFTER, BEFORE, INTERCEPTOR, INTERCEPTOR_CLASS, INDEX});
    }

    InterceptorConfiguration(AttributeSet attributes) {
        super(attributes);
        this.position = attributes.attribute(POSITION);
        this.after = attributes.attribute(AFTER);
        this.before = attributes.attribute(BEFORE);
        this.interceptor = attributes.attribute(INTERCEPTOR);
        this.interceptorClass = attributes.attribute(INTERCEPTOR_CLASS);
        this.index = attributes.attribute(INDEX);
    }

    public Class<? extends AsyncInterceptor> after() {
        return (Class)this.after.get();
    }

    public Class<? extends AsyncInterceptor> before() {
        return (Class)this.before.get();
    }

    @Deprecated
    public CommandInterceptor interceptor() {
        if (this.interceptor.isNull()) {
            return (CommandInterceptor)Util.getInstance((Class)((Class)this.interceptorClass.get()));
        }
        return (CommandInterceptor)this.interceptor.get();
    }

    public AsyncInterceptor asyncInterceptor() {
        if (this.interceptor.isNull()) {
            return (AsyncInterceptor)Util.getInstance((Class)((Class)this.interceptorClass.get()));
        }
        return (AsyncInterceptor)this.interceptor.get();
    }

    @Deprecated
    public Class<? extends CommandInterceptor> interceptorClass() {
        return (Class)this.interceptorClass.get();
    }

    public Class<? extends AsyncInterceptor> sequentialInterceptorClass() {
        return (Class)this.interceptorClass.get();
    }

    public int index() {
        return (Integer)this.index.get();
    }

    public Position position() {
        return (Position)((Object)this.position.get());
    }

    public boolean first() {
        return this.position() == Position.FIRST;
    }

    public boolean last() {
        return this.position() == Position.LAST;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public String toString() {
        return "InterceptorConfiguration [attributes=" + this.attributes + "]";
    }

    public static enum Position {
        FIRST,
        LAST,
        OTHER_THAN_FIRST_OR_LAST;

    }
}

