/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AsElementAttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.MemoryConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;

public class MemoryConfiguration
implements Matchable<MemoryConfiguration>,
ConfigurationInfo {
    private static AttributeSerializer<StorageType, MemoryConfiguration, MemoryConfigurationBuilder> STORAGE_SERIALIZER = new AsElementAttributeSerializer<StorageType, MemoryConfiguration, MemoryConfigurationBuilder>(){

        public boolean canRead(String enclosing, String nestingName, String nestedName, AttributeDefinition attributeDefinition) {
            return nestedName == null && StorageType.forElement(nestingName) != null;
        }

        public String getParentElement(MemoryConfiguration configurationElement) {
            StorageType storageType = configurationElement.storageType();
            return storageType != null ? storageType.getElement().getLocalName() : null;
        }

        public Object readAttributeValue(String enclosingElement, String nesting, AttributeDefinition attributeDefinition, Object attrValue, MemoryConfigurationBuilder builderInfo) {
            return StorageType.forElement(nesting);
        }
    };
    private static AttributeSerializer<Object, MemoryConfiguration, MemoryConfigurationBuilder> UNDER_STORAGE = new AttributeSerializer<Object, MemoryConfiguration, MemoryConfigurationBuilder>(){

        public String getParentElement(MemoryConfiguration configurationElement) {
            StorageType storageType = configurationElement.storageType();
            return storageType != null ? storageType.getElement().getLocalName() : null;
        }

        public boolean canRead(String enclosing, String nestingName, String nestedName, AttributeDefinition attributeDefinition) {
            return StorageType.forElement(nestingName) != null && nestedName.equals(attributeDefinition.xmlName());
        }
    };
    public static final AttributeDefinition<Integer> ADDRESS_COUNT = AttributeDefinition.builder((String)"address-count", (Object)0x100000).serializer(UNDER_STORAGE).build();
    public static final AttributeDefinition<StorageType> STORAGE_TYPE = AttributeDefinition.builder((String)"storage", (Object)((Object)StorageType.OBJECT)).copier(IdentityAttributeCopier.INSTANCE).serializer(STORAGE_SERIALIZER).immutable().build();
    public static final AttributeDefinition<Long> SIZE = AttributeDefinition.builder((String)"size", (Object)-1L).serializer(UNDER_STORAGE).build();
    public static final AttributeDefinition<EvictionType> EVICTION_TYPE = AttributeDefinition.builder((String)"type", (Object)((Object)EvictionType.COUNT)).xmlName(Attribute.EVICTION.getLocalName()).serializer(UNDER_STORAGE).build();
    public static final AttributeDefinition<EvictionStrategy> EVICTION_STRATEGY = AttributeDefinition.builder((String)"strategy", (Object)((Object)EvictionStrategy.NONE)).serializer(UNDER_STORAGE).build();
    public static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.MEMORY.getLocalName());
    private final org.infinispan.commons.configuration.attributes.Attribute<Long> size;
    private final org.infinispan.commons.configuration.attributes.Attribute<EvictionType> evictionType;
    private final org.infinispan.commons.configuration.attributes.Attribute<EvictionStrategy> evictionStrategy;
    private final org.infinispan.commons.configuration.attributes.Attribute<StorageType> storageType;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> addressCount;
    private final AttributeSet attributes;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(MemoryConfiguration.class, AbstractTypedPropertiesConfiguration.attributeSet(), new AttributeDefinition[]{STORAGE_TYPE, SIZE, EVICTION_TYPE, EVICTION_STRATEGY, ADDRESS_COUNT});
    }

    MemoryConfiguration(AttributeSet attributes) {
        this.attributes = attributes;
        this.storageType = attributes.attribute(STORAGE_TYPE);
        this.size = attributes.attribute(SIZE);
        this.evictionType = attributes.attribute(EVICTION_TYPE);
        this.evictionStrategy = attributes.attribute(EVICTION_STRATEGY);
        this.addressCount = attributes.attribute(ADDRESS_COUNT);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public StorageType storageType() {
        return (StorageType)((Object)this.storageType.get());
    }

    public long size() {
        return (Long)this.size.get();
    }

    public void size(long newSize) {
        this.size.set((Object)newSize);
    }

    public EvictionType evictionType() {
        return (EvictionType)((Object)this.evictionType.get());
    }

    public EvictionStrategy evictionStrategy() {
        return (EvictionStrategy)((Object)this.evictionStrategy.get());
    }

    public boolean isEvictionEnabled() {
        return (Long)this.size.get() > 0L && ((EvictionStrategy)((Object)this.evictionStrategy.get())).isRemovalBased();
    }

    public int addressCount() {
        return (Integer)this.addressCount.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryConfiguration other = (MemoryConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public String toString() {
        return "MemoryConfiguration [attributes=" + this.attributes + "]";
    }
}

