/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Arrays;
import java.util.List;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractSegmentedStoreConfiguration;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.persistence.file.SingleFileStore;

@BuiltBy(value=SingleFileStoreConfigurationBuilder.class)
@ConfigurationFor(value=SingleFileStore.class)
public class SingleFileStoreConfiguration
extends AbstractSegmentedStoreConfiguration<SingleFileStoreConfiguration>
implements ConfigurationInfo {
    public static final AttributeDefinition<String> LOCATION = AttributeDefinition.builder((String)"location", (Object)"Infinispan-SingleFileStore").immutable().xmlName("path").global(false).build();
    public static final AttributeDefinition<Integer> MAX_ENTRIES = AttributeDefinition.builder((String)"maxEntries", (Object)-1).immutable().build();
    public static final AttributeDefinition<Float> FRAGMENTATION_FACTOR = AttributeDefinition.builder((String)"fragmentationFactor", (Object)Float.valueOf(0.75f)).immutable().build();
    static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.FILE_STORE.getLocalName());
    private final Attribute<String> location;
    private final Attribute<Integer> maxEntries;
    private final Attribute<Float> fragmentationFactor;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SingleFileStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{LOCATION, MAX_ENTRIES, FRAGMENTATION_FACTOR});
    }

    public SingleFileStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore) {
        super(attributes, async, singletonStore);
        this.location = attributes.attribute(LOCATION);
        this.maxEntries = attributes.attribute(MAX_ENTRIES);
        this.fragmentationFactor = attributes.attribute(FRAGMENTATION_FACTOR);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    @Override
    public List<ConfigurationInfo> subElements() {
        return Arrays.asList(this.async(), this.singletonStore());
    }

    @Override
    public SingleFileStoreConfiguration newConfigurationFrom(int segment) {
        AttributeSet set = SingleFileStoreConfiguration.attributeDefinitionSet();
        set.read(this.attributes);
        String location = (String)set.attribute(LOCATION).get();
        set.attribute(LOCATION).set((Object)SingleFileStoreConfiguration.fileLocationTransform(location, segment));
        return new SingleFileStoreConfiguration(set.protect(), this.async(), this.singletonStore());
    }

    public String location() {
        return (String)this.location.get();
    }

    public int maxEntries() {
        return (Integer)this.maxEntries.get();
    }

    public float fragmentationFactor() {
        return ((Float)this.fragmentationFactor.get()).floatValue();
    }

    @Override
    public AttributeSet attributes() {
        return this.attributes;
    }

    @Override
    public String toString() {
        return "SingleFileStoreConfiguration [attributes=" + this.attributes + "]";
    }
}

