/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.parsing.Element;

public class StateTransferConfiguration
implements Matchable<StateTransferConfiguration>,
ConfigurationInfo {
    public static final AttributeDefinition<Boolean> AWAIT_INITIAL_TRANSFER = AttributeDefinition.builder((String)"awaitInitialTransfer", (Object)true).immutable().build();
    public static final AttributeDefinition<Boolean> FETCH_IN_MEMORY_STATE = AttributeDefinition.builder((String)"fetchInMemoryState", (Object)true).xmlName("enabled").immutable().build();
    public static final AttributeDefinition<Long> TIMEOUT = AttributeDefinition.builder((String)"timeout", (Object)TimeUnit.MINUTES.toMillis(4L)).immutable().build();
    public static final AttributeDefinition<Integer> CHUNK_SIZE = AttributeDefinition.builder((String)"chunkSize", (Object)512).immutable().build();
    public static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.STATE_TRANSFER.getLocalName());
    private final Attribute<Boolean> awaitInitialTransfer;
    private final Attribute<Boolean> fetchInMemoryState;
    private final Attribute<Long> timeout;
    private final Attribute<Integer> chunkSize;
    private final AttributeSet attributes;

    static final AttributeSet attributeDefinitionSet() {
        return new AttributeSet(StateTransferConfiguration.class, new AttributeDefinition[]{FETCH_IN_MEMORY_STATE, TIMEOUT, CHUNK_SIZE, AWAIT_INITIAL_TRANSFER});
    }

    StateTransferConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.awaitInitialTransfer = attributes.attribute(AWAIT_INITIAL_TRANSFER);
        this.fetchInMemoryState = attributes.attribute(FETCH_IN_MEMORY_STATE);
        this.timeout = attributes.attribute(TIMEOUT);
        this.chunkSize = attributes.attribute(CHUNK_SIZE);
    }

    public boolean fetchInMemoryState() {
        return (Boolean)this.fetchInMemoryState.get();
    }

    public long timeout() {
        return (Long)this.timeout.get();
    }

    public StateTransferConfiguration timeout(long l) {
        this.timeout.set((Object)l);
        return this;
    }

    public int chunkSize() {
        return (Integer)this.chunkSize.get();
    }

    public boolean awaitInitialTransfer() {
        return (Boolean)this.awaitInitialTransfer.get();
    }

    private boolean originalAwaitInitialTransfer() {
        return !this.awaitInitialTransfer.isModified();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.attributes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StateTransferConfiguration other = (StateTransferConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }
}

