/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Parser;
import org.infinispan.configuration.parsing.ParserContext;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.remoting.transport.jgroups.EmbeddedJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.FileJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;

public class ConfigurationBuilderHolder {
    private GlobalConfigurationBuilder globalConfigurationBuilder = new GlobalConfigurationBuilder();
    private final Map<String, ConfigurationBuilder> namedConfigurationBuilders = new HashMap<String, ConfigurationBuilder>();
    private ConfigurationBuilder currentConfigurationBuilder;
    private final Map<Class<? extends ConfigurationParser>, ParserContext> parserContexts = new HashMap<Class<? extends ConfigurationParser>, ParserContext>();
    private final WeakReference<ClassLoader> classLoader;
    private final Deque<String> scope;
    private final Map<String, JGroupsChannelConfigurator> jgroupsStacks;

    public ConfigurationBuilderHolder() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ConfigurationBuilderHolder(ClassLoader classLoader) {
        this.classLoader = new WeakReference<ClassLoader>(classLoader);
        this.scope = new ArrayDeque<String>();
        this.scope.push(ParserScope.GLOBAL.name());
        this.jgroupsStacks = new HashMap<String, JGroupsChannelConfigurator>();
    }

    public GlobalConfigurationBuilder getGlobalConfigurationBuilder() {
        return this.globalConfigurationBuilder;
    }

    public ConfigurationBuilder newConfigurationBuilder(String name) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        this.namedConfigurationBuilders.put(name, builder);
        this.currentConfigurationBuilder = builder;
        return builder;
    }

    public Map<String, ConfigurationBuilder> getNamedConfigurationBuilders() {
        return this.namedConfigurationBuilders;
    }

    public ConfigurationBuilder getCurrentConfigurationBuilder() {
        return this.currentConfigurationBuilder;
    }

    public ConfigurationBuilder getDefaultConfigurationBuilder() {
        if (this.globalConfigurationBuilder.defaultCacheName().isPresent()) {
            return this.namedConfigurationBuilders.get(this.globalConfigurationBuilder.defaultCacheName().get());
        }
        return null;
    }

    void pushScope(Enum<?> scope) {
        this.pushScope(scope.name());
    }

    public void pushScope(String scope) {
        this.scope.push(scope);
    }

    public String popScope() {
        return this.scope.pop();
    }

    public boolean inScope(String scope) {
        return this.getScope().equals(scope);
    }

    public boolean inScope(Enum<?> scope) {
        return this.inScope(scope.name());
    }

    public String getScope() {
        return this.scope.peek();
    }

    public <T extends ParserContext> T getParserContext(Class<? extends ConfigurationParser> parserClass) {
        return (T)this.parserContexts.get(parserClass);
    }

    public void setParserContext(Class<? extends ConfigurationParser> parserClass, ParserContext context) {
        this.parserContexts.put(parserClass, context);
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.classLoader.get();
    }

    Map<Class<? extends ConfigurationParser>, ParserContext> getParserContexts() {
        return this.parserContexts;
    }

    public void validate() {
        this.globalConfigurationBuilder.defaultCacheName().ifPresent(name -> {
            if (!this.namedConfigurationBuilders.containsKey(name)) {
                throw Parser.log.missingDefaultCacheDeclaration((String)name);
            }
        });
    }

    public void addJGroupsStack(FileJGroupsChannelConfigurator stack) {
        String name = stack.getName();
        if (this.jgroupsStacks.containsKey(name)) {
            throw Parser.log.duplicateJGroupsStack(name);
        }
        this.jgroupsStacks.put(name, stack);
    }

    public void addJGroupsStack(EmbeddedJGroupsChannelConfigurator stack, String extend) {
        String name = stack.getName();
        if (this.jgroupsStacks.containsKey(name)) {
            throw Parser.log.duplicateJGroupsStack(name);
        }
        if (extend == null) {
            this.jgroupsStacks.put(stack.getName(), stack);
        } else {
            if (!this.jgroupsStacks.containsKey(extend)) {
                throw Parser.log.missingJGroupsStack(extend);
            }
            JGroupsChannelConfigurator baseStack = this.jgroupsStacks.get(extend);
            this.jgroupsStacks.put(stack.getName(), EmbeddedJGroupsChannelConfigurator.combine(baseStack, stack));
        }
    }

    public JGroupsChannelConfigurator getJGroupsStack(String name) {
        return this.jgroupsStacks.get(name);
    }
}

