/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.executors.BlockingThreadPoolExecutorFactory;
import org.infinispan.commons.executors.CachedThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ScheduledThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.GlobUtils;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AsyncStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusterLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ContentTypeConfigurationBuilder;
import org.infinispan.configuration.cache.CustomStoreConfigurationBuilder;
import org.infinispan.configuration.cache.EncodingConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.InterceptorConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfigurationBuilder;
import org.infinispan.configuration.cache.PartitionHandlingConfigurationBuilder;
import org.infinispan.configuration.cache.SecurityConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalRoleConfigurationBuilder;
import org.infinispan.configuration.global.GlobalStateConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.conflict.MergePolicy;
import org.infinispan.container.DataContainer;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.factories.KnownComponentNames;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.globalstate.LocalConfigurationStorage;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.persistence.cluster.ClusterLoader;
import org.infinispan.persistence.file.SingleFileStore;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.BuiltinJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.EmbeddedJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.FileJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;
import org.infinispan.security.AuditLogger;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.impl.ClusterRoleMapper;
import org.infinispan.security.impl.CommonNameRoleMapper;
import org.infinispan.security.impl.IdentityRoleMapper;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionProtocol;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.conf.ProtocolConfiguration;

@Namespaces(value={@Namespace(root="infinispan"), @Namespace(uri="urn:infinispan:config:*", root="infinispan")})
public class Parser
implements ConfigurationParser {
    static final Log log = LogFactory.getLog(Parser.class);
    private final Map<String, DefaultThreadFactory> threadFactories = new HashMap<String, DefaultThreadFactory>();
    private final Map<String, ThreadPoolConfigurationBuilder> threadPools = new HashMap<String, ThreadPoolConfigurationBuilder>();
    private final Map<String, String> threadPoolToThreadFactory = new HashMap<String, String>();

    @Override
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.TCP(reader.getProperties()));
        holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.UDP(reader.getProperties()));
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CACHE_CONTAINER: {
                    this.parseContainer(reader, holder);
                    continue block5;
                }
                case JGROUPS: {
                    this.parseJGroups(reader, holder);
                    continue block5;
                }
                case THREADS: {
                    this.parseThreads(reader, holder);
                    continue block5;
                }
            }
            reader.handleAny(holder);
        }
    }

    private void parseSerialization(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MARSHALLER_CLASS: {
                    builder.serialization().marshaller((Marshaller)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block4;
                }
                case VERSION: {
                    builder.serialization().version(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        this.parseAdvancedExternalizers(reader, holder);
    }

    private void parseAdvancedExternalizers(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADVANCED_EXTERNALIZER: {
                    int attributes = reader.getAttributeCount();
                    AdvancedExternalizer advancedExternalizer = null;
                    Integer id = null;
                    ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.CLASS.getLocalName());
                    block8: for (int i = 0; i < attributes; ++i) {
                        String value = reader.getAttributeValue(i);
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case CLASS: {
                                advancedExternalizer = (AdvancedExternalizer)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader());
                                continue block8;
                            }
                            case ID: {
                                id = Integer.valueOf(value);
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                            }
                        }
                    }
                    ParseUtils.requireNoContent(reader);
                    if (id != null) {
                        builder.serialization().addAdvancedExternalizer(id, advancedExternalizer);
                        continue block7;
                    }
                    builder.serialization().addAdvancedExternalizer(advancedExternalizer);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseThreads(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case THREAD_FACTORY: {
                    this.parseThreadFactory(reader);
                    continue block6;
                }
                case CACHED_THREAD_POOL: {
                    this.parseCachedThreadPool(reader, holder);
                    continue block6;
                }
                case SCHEDULED_THREAD_POOL: {
                    this.parseScheduledThreadPool(reader, holder);
                    continue block6;
                }
                case BLOCKING_BOUNDED_QUEUE_THREAD_POOL: {
                    this.parseBlockingBoundedQueueThreadPool(reader, holder);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        for (Map.Entry<String, ThreadPoolConfigurationBuilder> entry : this.threadPools.entrySet()) {
            String threadFactoryName = this.threadPoolToThreadFactory.get(entry.getKey());
            if (threadFactoryName == null) continue;
            ThreadFactory threadFactory = this.threadFactories.get(threadFactoryName);
            entry.getValue().threadFactory(threadFactory);
        }
    }

    private void parseBlockingBoundedQueueThreadPool(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ThreadPoolConfigurationBuilder builder = new ThreadPoolConfigurationBuilder(holder.getGlobalConfigurationBuilder());
        String name = null;
        String threadFactoryName = null;
        int maxThreads = 0;
        int coreThreads = 0;
        int queueLength = 0;
        long keepAlive = 0L;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block8;
                }
                case THREAD_FACTORY: {
                    threadFactoryName = value;
                    continue block8;
                }
                case CORE_THREADS: {
                    coreThreads = Integer.valueOf(value);
                    continue block8;
                }
                case MAX_THREADS: {
                    maxThreads = Integer.valueOf(value);
                    continue block8;
                }
                case QUEUE_LENGTH: {
                    queueLength = Integer.valueOf(value);
                    continue block8;
                }
                case KEEP_ALIVE_TIME: {
                    keepAlive = Long.valueOf(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        BlockingThreadPoolExecutorFactory factory = new BlockingThreadPoolExecutorFactory(maxThreads, coreThreads, queueLength, keepAlive);
        builder.threadPoolFactory((ThreadPoolExecutorFactory)factory);
        this.threadPoolToThreadFactory.put(name, threadFactoryName);
        this.threadPools.put(name, builder);
        ParseUtils.requireNoContent(reader);
    }

    private void parseScheduledThreadPool(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ThreadPoolConfigurationBuilder builder = new ThreadPoolConfigurationBuilder(holder.getGlobalConfigurationBuilder());
        String name = null;
        String threadFactoryName = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block4;
                }
                case THREAD_FACTORY: {
                    threadFactoryName = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ScheduledThreadPoolExecutorFactory factory = ScheduledThreadPoolExecutorFactory.create();
        builder.threadPoolFactory((ThreadPoolExecutorFactory)factory);
        this.threadPoolToThreadFactory.put(name, threadFactoryName);
        this.threadPools.put(name, builder);
        ParseUtils.requireNoContent(reader);
    }

    private void parseCachedThreadPool(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ThreadPoolConfigurationBuilder builder = new ThreadPoolConfigurationBuilder(holder.getGlobalConfigurationBuilder());
        String name = null;
        String threadFactoryName = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block4;
                }
                case THREAD_FACTORY: {
                    threadFactoryName = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        CachedThreadPoolExecutorFactory factory = CachedThreadPoolExecutorFactory.create();
        builder.threadPoolFactory((ThreadPoolExecutorFactory)factory);
        this.threadPoolToThreadFactory.put(name, threadFactoryName);
        this.threadPools.put(name, builder);
        ParseUtils.requireNoContent(reader);
    }

    private void parseThreadFactory(XMLExtendedStreamReader reader) throws XMLStreamException {
        String name = null;
        ThreadGroup threadGroup = null;
        String threadNamePattern = null;
        int priority = 1;
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block6;
                }
                case GROUP_NAME: {
                    threadGroup = new ThreadGroup(value);
                    continue block6;
                }
                case THREAD_NAME_PATTERN: {
                    threadNamePattern = value;
                    continue block6;
                }
                case PRIORITY: {
                    priority = Integer.valueOf(value);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(name, threadGroup, priority, threadNamePattern, null, null);
        this.threadFactories.put(name, threadFactory);
        ParseUtils.requireNoContent(reader);
    }

    private void parseJGroups(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        Transport transport = null;
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TRANSPORT: {
                    transport = (Transport)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader());
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        if (transport == null) {
            holder.getGlobalConfigurationBuilder().transport().defaultTransport();
        } else {
            holder.getGlobalConfigurationBuilder().transport().transport(transport);
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STACK_FILE: {
                    this.parseStackFile(reader, holder);
                    continue block8;
                }
                case STACK: {
                    if (!reader.getSchema().since(10, 0)) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    this.parseJGroupsStack(reader, holder);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void addJGroupsStackFile(ConfigurationBuilderHolder holder, String name, String path, Properties properties) {
        try (InputStream xml = FileLookupFactory.newInstance().lookupFileStrict(path, holder.getClassLoader());){
            holder.addJGroupsStack(new FileJGroupsChannelConfigurator(name, path, xml, properties));
        }
        catch (IOException e) {
            throw log.jgroupsConfigurationNotFound(path);
        }
    }

    private void parseJGroupsStack(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String stackName = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME)[0];
        EmbeddedJGroupsChannelConfigurator stackConfigurator = new EmbeddedJGroupsChannelConfigurator(stackName);
        String extend = null;
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    continue block7;
                }
                case EXTENDS: {
                    extend = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        List<ProtocolConfiguration> stack = stackConfigurator.getProtocolStack();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SITES: {
                    this.parseJGroupsRelay(reader, holder, stackConfigurator);
                    continue block8;
                }
            }
            String protocolName = reader.getLocalName();
            HashMap<String, String> protocolAttributes = new HashMap<String, String>();
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                protocolAttributes.put(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
            }
            ParseUtils.requireNoContent(reader);
            stack.add(new ProtocolConfiguration(protocolName, protocolAttributes));
        }
        holder.addJGroupsStack(stackConfigurator, extend);
    }

    private void parseJGroupsRelay(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, EmbeddedJGroupsChannelConfigurator stackConfigurator) throws XMLStreamException {
        String defaultStack = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, Attribute.DEFAULT_STACK);
        if (holder.getJGroupsStack(defaultStack) == null) {
            throw log.missingJGroupsStack(defaultStack);
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SITE: {
                    String remoteSite = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME)[0];
                    String stack = defaultStack;
                    block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                continue block8;
                            }
                            case STACK: {
                                stack = reader.getAttributeValue(i);
                                if (holder.getJGroupsStack(stack) != null) continue block8;
                                throw log.missingJGroupsStack(stack);
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                            }
                        }
                    }
                    ParseUtils.requireNoContent(reader);
                    stackConfigurator.addRemoteSite(remoteSite, holder.getJGroupsStack(stack));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseStackFile(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME, Attribute.PATH);
        ParseUtils.requireNoContent(reader);
        this.addJGroupsStackFile(holder, attributes[0], attributes[1], reader.getProperties());
    }

    private void parseContainer(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        holder.pushScope(ParserScope.CACHE_CONTAINER);
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        if (!reader.getSchema().since(9, 0)) {
            builder.defaultCacheName("___defaultcache");
        }
        block36: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    builder.globalJmxStatistics().cacheManagerName(value);
                    continue block36;
                }
                case ALIASES: {
                    log.ignoreXmlAttribute((Object)attribute);
                    continue block36;
                }
                case DEFAULT_CACHE: {
                    builder.defaultCacheName(value);
                    continue block36;
                }
                case JNDI_NAME: {
                    log.ignoreXmlAttribute((Object)attribute);
                    continue block36;
                }
                case START: {
                    log.ignoreXmlAttribute((Object)attribute);
                    continue block36;
                }
                case ASYNC_EXECUTOR: {
                    builder.asyncThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.async"));
                    continue block36;
                }
                case LISTENER_EXECUTOR: {
                    builder.listenerThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.notification"));
                    continue block36;
                }
                case EVICTION_EXECUTOR: {
                    log.evictionExecutorDeprecated();
                }
                case EXPIRATION_EXECUTOR: {
                    builder.expirationThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.expiration"));
                    continue block36;
                }
                case REPLICATION_QUEUE_EXECUTOR: {
                    if (reader.getSchema().since(9, 0)) {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, attribute.getLocalName());
                    }
                    log.ignoredReplicationQueueAttribute(attribute.getLocalName(), reader.getLocation().getLineNumber());
                    continue block36;
                }
                case PERSISTENCE_EXECUTOR: {
                    builder.persistenceThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.persistence"));
                    continue block36;
                }
                case STATE_TRANSFER_EXECUTOR: {
                    builder.stateTransferThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.stateTransferExecutor"));
                    continue block36;
                }
                case MODULE: {
                    log.ignoreXmlAttribute((Object)attribute);
                    continue block36;
                }
                case STATISTICS: {
                    builder.globalJmxStatistics().enabled(Boolean.parseBoolean(value));
                    continue block36;
                }
                case SHUTDOWN_HOOK: {
                    builder.shutdown().hookBehavior(ShutdownHookBehavior.valueOf(value));
                    continue block36;
                }
                case ZERO_CAPACITY_NODE: {
                    builder.zeroCapacityNode(Boolean.parseBoolean(value));
                    continue block36;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        block37: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TRANSPORT: {
                    this.parseTransport(reader, holder);
                    continue block37;
                }
                case LOCAL_CACHE: {
                    this.parseLocalCache(reader, holder, false);
                    continue block37;
                }
                case LOCAL_CACHE_CONFIGURATION: {
                    this.parseLocalCache(reader, holder, true);
                    continue block37;
                }
                case INVALIDATION_CACHE: {
                    this.parseInvalidationCache(reader, holder, false);
                    continue block37;
                }
                case INVALIDATION_CACHE_CONFIGURATION: {
                    this.parseInvalidationCache(reader, holder, true);
                    continue block37;
                }
                case REPLICATED_CACHE: {
                    this.parseReplicatedCache(reader, holder, false);
                    continue block37;
                }
                case REPLICATED_CACHE_CONFIGURATION: {
                    this.parseReplicatedCache(reader, holder, true);
                    continue block37;
                }
                case DISTRIBUTED_CACHE: {
                    this.parseDistributedCache(reader, holder, false);
                    continue block37;
                }
                case DISTRIBUTED_CACHE_CONFIGURATION: {
                    this.parseDistributedCache(reader, holder, true);
                    continue block37;
                }
                case SCATTERED_CACHE: {
                    if (reader.getSchema().since(9, 1)) {
                        this.parseScatteredCache(reader, holder, false);
                        continue block37;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
                case SCATTERED_CACHE_CONFIGURATION: {
                    if (reader.getSchema().since(9, 1)) {
                        this.parseScatteredCache(reader, holder, true);
                        continue block37;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
                case SERIALIZATION: {
                    this.parseSerialization(reader, holder);
                    continue block37;
                }
                case MODULES: {
                    if (reader.getSchema().since(9, 0)) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    this.parseModules(reader, holder);
                    continue block37;
                }
                case JMX: {
                    this.parseJmx(reader, holder);
                    continue block37;
                }
                case SECURITY: {
                    this.parseGlobalSecurity(reader, holder);
                    continue block37;
                }
                case GLOBAL_STATE: {
                    if (reader.getSchema().since(8, 1)) {
                        this.parseGlobalState(reader, holder);
                        continue block37;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            reader.handleAny(holder);
        }
        holder.popScope();
    }

    private void parseGlobalSecurity(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHORIZATION: {
                    this.parseGlobalAuthorization(reader, holder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseGlobalAuthorization(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalAuthorizationConfigurationBuilder builder = holder.getGlobalConfigurationBuilder().security().authorization().enable();
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AUDIT_LOGGER: {
                    builder.auditLogger((AuditLogger)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        PrincipalRoleMapper roleMapper = null;
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case IDENTITY_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    roleMapper = new IdentityRoleMapper();
                    continue block11;
                }
                case COMMON_NAME_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    roleMapper = new CommonNameRoleMapper();
                    continue block11;
                }
                case CLUSTER_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    roleMapper = new ClusterRoleMapper();
                    continue block11;
                }
                case CUSTOM_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    roleMapper = this.parseCustomMapper(reader, holder);
                    continue block11;
                }
                case ROLE: {
                    this.parseGlobalRole(reader, builder);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (roleMapper != null) {
            builder.principalRoleMapper(roleMapper);
        }
    }

    private PrincipalRoleMapper parseCustomMapper(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String mapperClass = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, Attribute.CLASS.getLocalName());
        ParseUtils.requireNoContent(reader);
        return (PrincipalRoleMapper)Util.getInstance((String)mapperClass, (ClassLoader)holder.getClassLoader());
    }

    private void parseGlobalRole(XMLExtendedStreamReader reader, GlobalAuthorizationConfigurationBuilder builder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME.getLocalName(), Attribute.PERMISSIONS.getLocalName());
        GlobalRoleConfigurationBuilder role = builder.role(attributes[0]);
        for (String permission : attributes[1].split("\\s+")) {
            role.permission(permission);
        }
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: 
                case PERMISSIONS: {
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseJmx(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case JMX_DOMAIN: {
                    builder.globalJmxStatistics().jmxDomain(value);
                    continue block5;
                }
                case MBEAN_SERVER_LOOKUP: {
                    builder.globalJmxStatistics().mBeanServerLookup((MBeanServerLookup)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block5;
                }
                case ALLOW_DUPLICATE_DOMAINS: {
                    builder.globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        Properties properties = Parser.parseProperties(reader);
        builder.globalJmxStatistics().withProperties(properties);
    }

    private void parseModules(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            reader.handleAny(holder);
        }
    }

    private void parseTransport(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder globalBuilder = holder.getGlobalConfigurationBuilder();
        if (holder.getGlobalConfigurationBuilder().transport().getTransport() == null) {
            holder.getGlobalConfigurationBuilder().transport().defaultTransport();
        }
        TransportConfigurationBuilder transport = holder.getGlobalConfigurationBuilder().transport();
        block15: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STACK: {
                    JGroupsChannelConfigurator jGroupsStack = holder.getJGroupsStack(value);
                    if (jGroupsStack == null) {
                        throw log.missingJGroupsStack(value);
                    }
                    Properties p = new Properties();
                    p.put("channelConfigurator", jGroupsStack);
                    p.put("stack", value);
                    transport.withProperties(p);
                    continue block15;
                }
                case CLUSTER: {
                    transport.clusterName(value);
                    continue block15;
                }
                case EXECUTOR: {
                    transport.transportThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.transport"));
                    continue block15;
                }
                case TOTAL_ORDER_EXECUTOR: {
                    if (reader.getSchema().since(9, 0)) {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, attribute.getLocalName());
                    }
                    log.ignoredAttribute("total order executor", "9.0", attribute.getLocalName(), reader.getLocation().getLineNumber());
                }
                case REMOTE_COMMAND_EXECUTOR: {
                    transport.remoteCommandThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.remote"));
                    continue block15;
                }
                case LOCK_TIMEOUT: {
                    transport.distributedSyncTimeout(Long.valueOf(value));
                    continue block15;
                }
                case NODE_NAME: {
                    transport.nodeName(value);
                    for (DefaultThreadFactory threadFactory : this.threadFactories.values()) {
                        threadFactory.setNode(value);
                    }
                    continue block15;
                }
                case LOCKING: {
                    continue block15;
                }
                case MACHINE_ID: {
                    transport.machineId(value);
                    continue block15;
                }
                case RACK_ID: {
                    transport.rackId(value);
                    continue block15;
                }
                case SITE: {
                    transport.siteId(value);
                    globalBuilder.site().localSite(value);
                    continue block15;
                }
                case INITIAL_CLUSTER_SIZE: {
                    if (reader.getSchema().since(8, 2)) {
                        transport.initialClusterSize(Integer.valueOf(value));
                        continue block15;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
                case INITIAL_CLUSTER_TIMEOUT: {
                    if (reader.getSchema().since(8, 2)) {
                        transport.initialClusterTimeout(Long.parseLong(value), TimeUnit.MILLISECONDS);
                        continue block15;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseGlobalState(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        GlobalStateConfigurationBuilder builder = holder.getGlobalConfigurationBuilder().globalState().enable();
        ConfigurationStorage storage = null;
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PERSISTENT_LOCATION: {
                    builder.persistentLocation(this.parseGlobalStatePath(reader));
                    continue block10;
                }
                case SHARED_PERSISTENT_LOCATION: {
                    builder.sharedPersistentLocation(this.parseGlobalStatePath(reader));
                    continue block10;
                }
                case TEMPORARY_LOCATION: {
                    builder.temporaryLocation(this.parseGlobalStatePath(reader));
                    continue block10;
                }
                case IMMUTABLE_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    storage = ConfigurationStorage.IMMUTABLE;
                    continue block10;
                }
                case VOLATILE_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    storage = ConfigurationStorage.VOLATILE;
                    continue block10;
                }
                case OVERLAY_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    storage = ConfigurationStorage.OVERLAY;
                    continue block10;
                }
                case MANAGED_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    throw log.managerConfigurationStorageUnavailable();
                }
                case CUSTOM_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    storage = ConfigurationStorage.CUSTOM;
                    builder.configurationStorageSupplier(this.parseCustomConfigurationStorage(reader, holder));
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (storage != null) {
            builder.configurationStorage(storage);
        }
    }

    private String parseGlobalStatePath(XMLExtendedStreamReader reader) throws XMLStreamException {
        String path = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.PATH.getLocalName())[0];
        String relativeTo = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    relativeTo = (String)reader.getProperty(reader.getAttributeValue(i));
                    continue block4;
                }
                case PATH: {
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
        return ParseUtils.resolvePath(path, relativeTo);
    }

    private Supplier<? extends LocalConfigurationStorage> parseCustomConfigurationStorage(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String storageClass = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, Attribute.CLASS.getLocalName());
        ParseUtils.requireNoContent(reader);
        return Util.getInstanceSupplier((String)storageClass, (ClassLoader)holder.getClassLoader());
    }

    private ThreadPoolConfiguration createThreadPoolConfiguration(String threadPoolName, String componentName) {
        ThreadPoolConfigurationBuilder threadPool = this.threadPools.get(threadPoolName);
        if (threadPool == null) {
            throw log.undefinedThreadPoolName(threadPoolName);
        }
        ThreadPoolConfiguration threadPoolConfiguration = threadPool.create();
        DefaultThreadFactory threadFactory = (DefaultThreadFactory)threadPoolConfiguration.threadFactory();
        threadFactory.setComponent(KnownComponentNames.shortened(componentName));
        return threadPoolConfiguration;
    }

    private void parseLocalCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, boolean template) throws XMLStreamException {
        holder.pushScope(template ? ParserScope.CACHE_TEMPLATE : ParserScope.CACHE);
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        if (!template && GlobUtils.isGlob((String)name)) {
            throw log.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(null, Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(holder, name, template, configuration);
        builder.clustering().cacheMode(CacheMode.LOCAL);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseCacheAttribute(reader, i, attribute, value, builder);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            this.parseCacheElement(reader, element, holder);
        }
        holder.popScope();
    }

    private void parseCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ConfigurationBuilder builder) throws XMLStreamException {
        switch (attribute) {
            case NAME: 
            case CONFIGURATION: {
                break;
            }
            case JNDI_NAME: 
            case START: 
            case MODULE: {
                log.ignoreXmlAttribute((Object)attribute);
                break;
            }
            case SIMPLE_CACHE: {
                builder.simpleCache(Boolean.valueOf(value));
                break;
            }
            case STATISTICS: {
                builder.jmxStatistics().enabled(Boolean.valueOf(value));
                break;
            }
            case STATISTICS_AVAILABLE: {
                builder.jmxStatistics().available(Boolean.valueOf(value));
                break;
            }
            case SPIN_DURATION: {
                log.ignoreXmlAttribute((Object)attribute);
                break;
            }
            case UNRELIABLE_RETURN_VALUES: {
                builder.unsafe().unreliableReturnValues(Boolean.valueOf(value));
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, index);
            }
        }
    }

    private void parseSharedStateCacheElement(XMLExtendedStreamReader reader, Element element, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        switch (element) {
            case STATE_TRANSFER: {
                this.parseStateTransfer(reader, builder);
                break;
            }
            default: {
                this.parseCacheElement(reader, element, holder);
            }
        }
    }

    private void parseBackups(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        builder.sites().backups().clear();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BACKUP: {
                    this.parseBackup(reader, builder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parsePartitionHandling(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        PartitionHandlingConfigurationBuilder ph = builder.clustering().partitionHandling();
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    log.partitionHandlingConfigurationEnabledDeprecated();
                    ph.enabled(Boolean.valueOf(value));
                    continue block5;
                }
                case WHEN_SPLIT: {
                    ph.whenSplit(PartitionHandling.valueOf(value.toUpperCase()));
                    continue block5;
                }
                case MERGE_POLICY: {
                    MergePolicy mp = MergePolicy.fromString(value);
                    MergePolicy mergePolicy = mp == MergePolicy.CUSTOM ? (EntryMergePolicy)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()) : mp;
                    ph.mergePolicy(mergePolicy);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseBackup(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        BackupConfigurationBuilder backup = builder.sites().addBackup();
        block13: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SITE: {
                    backup.site(value);
                    continue block13;
                }
                case STRATEGY: {
                    backup.strategy(BackupConfiguration.BackupStrategy.valueOf(value));
                    continue block13;
                }
                case BACKUP_FAILURE_POLICY: {
                    backup.backupFailurePolicy(BackupFailurePolicy.valueOf(value));
                    continue block13;
                }
                case TIMEOUT: {
                    backup.replicationTimeout(Long.valueOf(value));
                    continue block13;
                }
                case ENABLED: {
                    backup.enabled(Boolean.valueOf(value));
                    continue block13;
                }
                case USE_TWO_PHASE_COMMIT: {
                    backup.useTwoPhaseCommit(Boolean.parseBoolean(value));
                    continue block13;
                }
                case FAILURE_POLICY_CLASS: {
                    backup.failurePolicyClass(value);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        if (backup.site() == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.SITE));
        }
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TAKE_OFFLINE: {
                    this.parseTakeOffline(reader, backup);
                    continue block14;
                }
                case STATE_TRANSFER: {
                    this.parseXSiteStateTransfer(reader, backup);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseTakeOffline(XMLExtendedStreamReader reader, BackupConfigurationBuilder backup) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TAKE_BACKUP_OFFLINE_AFTER_FAILURES: {
                    backup.takeOffline().afterFailures(Integer.valueOf(value));
                    continue block4;
                }
                case TAKE_BACKUP_OFFLINE_MIN_WAIT: {
                    backup.takeOffline().minTimeToWait(Long.valueOf(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseXSiteStateTransfer(XMLExtendedStreamReader reader, BackupConfigurationBuilder backup) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CHUNK_SIZE: {
                    backup.stateTransfer().chunkSize(Integer.parseInt(value));
                    continue block6;
                }
                case TIMEOUT: {
                    backup.stateTransfer().timeout(Long.parseLong(value));
                    continue block6;
                }
                case MAX_RETRIES: {
                    backup.stateTransfer().maxRetries(Integer.parseInt(value));
                    continue block6;
                }
                case WAIT_TIME: {
                    backup.stateTransfer().waitTime(Long.parseLong(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseBackupFor(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        builder.sites().backupFor().reset();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REMOTE_CACHE: {
                    builder.sites().backupFor().remoteCache(value);
                    continue block4;
                }
                case REMOTE_SITE: {
                    builder.sites().backupFor().remoteSite(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseCacheSecurity(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        SecurityConfigurationBuilder securityBuilder = builder.security();
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHORIZATION: {
                    this.parseCacheAuthorization(reader, securityBuilder.authorization().enable());
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseCacheAuthorization(XMLExtendedStreamReader reader, AuthorizationConfigurationBuilder authzBuilder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    authzBuilder.enabled(Boolean.parseBoolean(value));
                    continue block4;
                }
                case ROLES: {
                    for (String role : value.split("\\s+")) {
                        authzBuilder.role(role);
                    }
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    protected void parseCacheElement(XMLExtendedStreamReader reader, Element element, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        switch (element) {
            case LOCKING: {
                this.parseLocking(reader, builder);
                break;
            }
            case TRANSACTION: {
                this.parseTransaction(reader, builder, holder);
                break;
            }
            case EVICTION: {
                this.parseEviction(reader, builder);
                break;
            }
            case EXPIRATION: {
                this.parseExpiration(reader, builder);
                break;
            }
            case ENCODING: {
                this.parseDataType(reader, builder, holder);
                break;
            }
            case PERSISTENCE: {
                this.parsePersistence(reader, holder);
                break;
            }
            case INDEXING: {
                this.parseIndexing(reader, holder);
                break;
            }
            case CUSTOM_INTERCEPTORS: {
                this.parseCustomInterceptors(reader, holder);
                break;
            }
            case VERSIONING: {
                this.parseVersioning(reader, holder);
                break;
            }
            case COMPATIBILITY: {
                this.parseCompatibility(reader, holder);
                break;
            }
            case STORE_AS_BINARY: {
                this.parseStoreAsBinary(reader, holder);
                break;
            }
            case MODULES: {
                if (reader.getSchema().since(9, 0)) {
                    throw ParseUtils.unexpectedElement(reader);
                }
                this.parseModules(reader, holder);
                break;
            }
            case DATA_CONTAINER: {
                this.parseDataContainer(reader, holder);
                break;
            }
            case MEMORY: {
                this.parseMemory(reader, holder);
                break;
            }
            case BACKUPS: {
                this.parseBackups(reader, builder);
                break;
            }
            case BACKUP_FOR: {
                this.parseBackupFor(reader, builder);
                break;
            }
            case PARTITION_HANDLING: {
                this.parsePartitionHandling(reader, holder);
                break;
            }
            case SECURITY: {
                this.parseCacheSecurity(reader, builder);
                break;
            }
            default: {
                reader.handleAny(holder);
            }
        }
    }

    private void parseDataContainer(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    log.dataContainerConfigurationDeprecated();
                    builder.dataContainer().dataContainer((DataContainer)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block8;
                }
                case KEY_EQUIVALENCE: {
                    builder.dataContainer().keyEquivalence((Equivalence)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block8;
                }
                case VALUE_EQUIVALENCE: {
                    builder.dataContainer().valueEquivalence((Equivalence)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        Properties properties = new Properties();
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    Parser.parseProperty(reader, properties);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        builder.dataContainer().withProperties(properties);
    }

    private void parseMemory(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        MemoryConfigurationBuilder memoryBuilder = holder.getCurrentConfigurationBuilder().memory();
        ParseUtils.requireNoAttributes(reader);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case OFF_HEAP: {
                    memoryBuilder.storageType(StorageType.OFF_HEAP);
                    this.parseOffHeapMemoryAttributes(reader, holder);
                    continue block5;
                }
                case OBJECT: {
                    memoryBuilder.storageType(StorageType.OBJECT);
                    this.parseObjectMemoryAttributes(reader, holder);
                    continue block5;
                }
                case BINARY: {
                    memoryBuilder.storageType(StorageType.BINARY);
                    this.parseBinaryMemoryAttributes(reader, holder);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseOffHeapMemoryAttributes(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        MemoryConfigurationBuilder memoryBuilder = holder.getCurrentConfigurationBuilder().memory();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    memoryBuilder.size(Long.parseLong(value));
                    continue block6;
                }
                case EVICTION: {
                    memoryBuilder.evictionType(EvictionType.valueOf(value));
                    continue block6;
                }
                case ADDRESS_COUNT: {
                    memoryBuilder.addressCount(Integer.parseInt(value));
                    continue block6;
                }
                case STRATEGY: {
                    memoryBuilder.evictionStrategy(EvictionStrategy.valueOf(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseObjectMemoryAttributes(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        MemoryConfigurationBuilder memoryBuilder = holder.getCurrentConfigurationBuilder().memory();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    memoryBuilder.size(Long.parseLong(value));
                    continue block4;
                }
                case STRATEGY: {
                    memoryBuilder.evictionStrategy(EvictionStrategy.valueOf(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseBinaryMemoryAttributes(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        MemoryConfigurationBuilder memoryBuilder = holder.getCurrentConfigurationBuilder().memory();
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    memoryBuilder.size(Long.parseLong(value));
                    continue block5;
                }
                case EVICTION: {
                    memoryBuilder.evictionType(EvictionType.valueOf(value));
                    continue block5;
                }
                case STRATEGY: {
                    memoryBuilder.evictionStrategy(EvictionStrategy.valueOf(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseStoreAsBinary(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        log.elementDeprecatedUseOther(Element.STORE_AS_BINARY, Element.MEMORY);
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Boolean binaryKeys = null;
        Boolean binaryValues = null;
        builder.memory().storageType(StorageType.BINARY);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STORE_KEYS_AS_BINARY: {
                    binaryKeys = Boolean.parseBoolean(value);
                    continue block4;
                }
                case STORE_VALUES_AS_BINARY: {
                    binaryValues = Boolean.parseBoolean(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        if (binaryKeys != null && !binaryKeys.booleanValue() && binaryValues != null && !binaryValues.booleanValue()) {
            builder.memory().storageType(StorageType.OBJECT);
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseCompatibility(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        builder.compatibility().enable();
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MARSHALLER_CLASS: {
                    builder.compatibility().marshaller((Marshaller)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseVersioning(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VERSIONING_SCHEME: {
                    log.ignoredAttribute("versioning", "9.0", attribute.getLocalName(), reader.getLocation().getLineNumber());
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseCustomInterceptors(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INTERCEPTOR: {
                    this.parseInterceptor(reader, holder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseInterceptor(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        InterceptorConfigurationBuilder interceptorBuilder = builder.customInterceptors().addInterceptor();
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AFTER: {
                    interceptorBuilder.after(Util.loadClass((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block7;
                }
                case BEFORE: {
                    interceptorBuilder.before(Util.loadClass((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block7;
                }
                case CLASS: {
                    interceptorBuilder.interceptorClass(Util.loadClass((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block7;
                }
                case INDEX: {
                    interceptorBuilder.index(Integer.parseInt(value));
                    continue block7;
                }
                case POSITION: {
                    interceptorBuilder.position(InterceptorConfiguration.Position.valueOf(value.toUpperCase()));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        interceptorBuilder.withProperties(Parser.parseProperties(reader));
    }

    protected void parseLocking(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ISOLATION: {
                    builder.locking().isolationLevel(IsolationLevel.valueOf(value));
                    continue block7;
                }
                case STRIPING: {
                    builder.locking().useLockStriping(Boolean.parseBoolean(value));
                    continue block7;
                }
                case ACQUIRE_TIMEOUT: {
                    builder.locking().lockAcquisitionTimeout(Long.parseLong(value));
                    continue block7;
                }
                case CONCURRENCY_LEVEL: {
                    builder.locking().concurrencyLevel(Integer.parseInt(value));
                    continue block7;
                }
                case WRITE_SKEW_CHECK: {
                    log.ignoredAttribute("write skew attribute", "9.0", attribute.getLocalName(), reader.getLocation().getLineNumber());
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    protected void parseTransaction(XMLExtendedStreamReader reader, ConfigurationBuilder builder, ConfigurationBuilderHolder holder) throws XMLStreamException {
        CacheMode cacheMode;
        if (!reader.getSchema().since(9, 0) && !(cacheMode = builder.clustering().cacheMode()).isSynchronous()) {
            log.unsupportedAsyncCacheMode(cacheMode, cacheMode.toSync());
            builder.clustering().cacheMode(cacheMode.toSync());
        }
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STOP_TIMEOUT: {
                    builder.transaction().cacheStopTimeout(Long.parseLong(value));
                    continue block12;
                }
                case MODE: {
                    TransactionMode txMode = TransactionMode.valueOf(value);
                    builder.transaction().transactionMode(txMode.getMode());
                    builder.transaction().useSynchronization(!txMode.isXAEnabled() && txMode.getMode().isTransactional());
                    builder.transaction().recovery().enabled(txMode.isRecoveryEnabled());
                    builder.invocationBatching().enable(txMode.isBatchingEnabled());
                    continue block12;
                }
                case LOCKING: {
                    builder.transaction().lockingMode(LockingMode.valueOf(value));
                    continue block12;
                }
                case TRANSACTION_MANAGER_LOOKUP_CLASS: {
                    builder.transaction().transactionManagerLookup((TransactionManagerLookup)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block12;
                }
                case REAPER_WAKE_UP_INTERVAL: {
                    builder.transaction().reaperWakeUpInterval(Long.parseLong(value));
                    continue block12;
                }
                case COMPLETED_TX_TIMEOUT: {
                    builder.transaction().completedTxTimeout(Long.parseLong(value));
                    continue block12;
                }
                case TRANSACTION_PROTOCOL: {
                    builder.transaction().transactionProtocol(TransactionProtocol.valueOf(value));
                    continue block12;
                }
                case AUTO_COMMIT: {
                    builder.transaction().autoCommit(Boolean.parseBoolean(value));
                    continue block12;
                }
                case RECOVERY_INFO_CACHE_NAME: {
                    builder.transaction().recovery().recoveryInfoCacheName(value);
                    continue block12;
                }
                case NOTIFICATIONS: {
                    builder.transaction().notifications(Boolean.parseBoolean(value));
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    protected void parseDataType(XMLExtendedStreamReader reader, ConfigurationBuilder builder, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        EncodingConfigurationBuilder encodingBuilder = builder.encoding();
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case KEY_DATA_TYPE: {
                    ContentTypeConfigurationBuilder keyBuilder = encodingBuilder.key();
                    this.parseContentType(reader, holder, keyBuilder);
                    ParseUtils.requireNoContent(reader);
                    continue block4;
                }
                case VALUE_DATA_TYPE: {
                    ContentTypeConfigurationBuilder valueBuilder = encodingBuilder.value();
                    this.parseContentType(reader, holder, valueBuilder);
                    ParseUtils.requireNoContent(reader);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseContentType(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ContentTypeConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MEDIA_TYPE: {
                    builder.mediaType(value);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
    }

    private void parseEviction(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        log.elementDeprecatedUseOther(Element.EVICTION, Element.MEMORY);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STRATEGY: 
                case THREAD_POLICY: 
                case TYPE: {
                    log.ignoreXmlElement((Object)attribute);
                    continue block5;
                }
                case MAX_ENTRIES: {
                    log.evictionMaxEntriesDeprecated();
                }
                case SIZE: {
                    builder.memory().size(Long.parseLong(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseExpiration(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_IDLE: {
                    builder.expiration().maxIdle(Long.parseLong(value));
                    continue block5;
                }
                case LIFESPAN: {
                    builder.expiration().lifespan(Long.parseLong(value));
                    continue block5;
                }
                case INTERVAL: {
                    builder.expiration().wakeUpInterval(Long.parseLong(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseInvalidationCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, boolean template) throws XMLStreamException {
        holder.pushScope(template ? ParserScope.CACHE_TEMPLATE : ParserScope.CACHE);
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        if (!template && GlobUtils.isGlob((String)name)) {
            throw log.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(null, Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(holder, name, template, configuration);
        CacheMode baseCacheMode = configuration == null ? CacheMode.INVALIDATION_SYNC : builder.clustering().cacheMode();
        builder.clustering().cacheMode(baseCacheMode);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEY_PARTITIONER: {
                    builder.clustering().hash().keyPartitioner((KeyPartitioner)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block5;
                }
                default: {
                    this.parseClusteredCacheAttribute(reader, i, attribute, value, builder, baseCacheMode);
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseCacheElement(reader, element, holder);
        }
        holder.popScope();
    }

    private void parseSegmentedCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ConfigurationBuilder builder, ClassLoader classLoader, CacheMode baseCacheMode) throws XMLStreamException {
        switch (attribute) {
            case SEGMENTS: {
                builder.clustering().hash().numSegments(Integer.parseInt(value));
                break;
            }
            case CONSISTENT_HASH_FACTORY: {
                builder.clustering().hash().consistentHashFactory((ConsistentHashFactory)Util.getInstance((String)value, (ClassLoader)classLoader));
                break;
            }
            case KEY_PARTITIONER: {
                if (reader.getSchema().since(8, 2)) {
                    builder.clustering().hash().keyPartitioner((KeyPartitioner)Util.getInstance((String)value, (ClassLoader)classLoader));
                    break;
                }
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, index);
            }
            default: {
                this.parseClusteredCacheAttribute(reader, index, attribute, value, builder, baseCacheMode);
            }
        }
    }

    private void parseClusteredCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ConfigurationBuilder builder, CacheMode baseCacheMode) throws XMLStreamException {
        switch (attribute) {
            case ASYNC_MARSHALLING: {
                if (reader.getSchema().since(9, 0)) {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, attribute.getLocalName());
                }
                log.ignoredReplicationQueueAttribute(attribute.getLocalName(), reader.getLocation().getLineNumber());
                break;
            }
            case MODE: {
                Mode mode = Mode.valueOf(value);
                builder.clustering().cacheMode(mode.apply(baseCacheMode));
                break;
            }
            case QUEUE_SIZE: {
                log.ignoredReplicationQueueAttribute(attribute.getLocalName(), reader.getLocation().getLineNumber());
                break;
            }
            case QUEUE_FLUSH_INTERVAL: {
                log.ignoredReplicationQueueAttribute(attribute.getLocalName(), reader.getLocation().getLineNumber());
                break;
            }
            case REMOTE_TIMEOUT: {
                builder.clustering().remoteTimeout(Long.parseLong(value));
                break;
            }
            default: {
                this.parseCacheAttribute(reader, index, attribute, value, builder);
            }
        }
    }

    private void parseReplicatedCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, boolean template) throws XMLStreamException {
        holder.pushScope(template ? ParserScope.CACHE_TEMPLATE : ParserScope.CACHE);
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        if (!template && GlobUtils.isGlob((String)name)) {
            throw log.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(null, Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(holder, name, template, configuration);
        CacheMode baseCacheMode = configuration == null ? CacheMode.REPL_SYNC : builder.clustering().cacheMode();
        builder.clustering().cacheMode(baseCacheMode);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseSegmentedCacheAttribute(reader, i, attribute, value, builder, holder.getClassLoader(), baseCacheMode);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseSharedStateCacheElement(reader, element, holder);
        }
        holder.popScope();
    }

    private void parseStateTransfer(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AWAIT_INITIAL_TRANSFER: {
                    builder.clustering().stateTransfer().awaitInitialTransfer(Boolean.parseBoolean(value));
                    continue block6;
                }
                case ENABLED: {
                    builder.clustering().stateTransfer().fetchInMemoryState(Boolean.parseBoolean(value));
                    continue block6;
                }
                case TIMEOUT: {
                    builder.clustering().stateTransfer().timeout(Long.parseLong(value));
                    continue block6;
                }
                case CHUNK_SIZE: {
                    builder.clustering().stateTransfer().chunkSize(Integer.parseInt(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseDistributedCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, boolean template) throws XMLStreamException {
        holder.pushScope(template ? ParserScope.CACHE_TEMPLATE : ParserScope.CACHE);
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        if (!template && GlobUtils.isGlob((String)name)) {
            throw log.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(null, Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(holder, name, template, configuration);
        CacheMode baseCacheMode = configuration == null ? CacheMode.DIST_SYNC : builder.clustering().cacheMode();
        builder.clustering().cacheMode(baseCacheMode);
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case OWNERS: {
                    builder.clustering().hash().numOwners(Integer.parseInt(value));
                    continue block9;
                }
                case L1_LIFESPAN: {
                    long lifespan = Long.parseLong(value);
                    if (lifespan > 0L) {
                        builder.clustering().l1().enable().lifespan(lifespan);
                        continue block9;
                    }
                    builder.clustering().l1().disable();
                    continue block9;
                }
                case INVALIDATION_CLEANUP_TASK_FREQUENCY: {
                    builder.clustering().l1().cleanupTaskFrequency(Long.parseLong(value));
                    continue block9;
                }
                case CAPACITY_FACTOR: {
                    builder.clustering().hash().capacityFactor(Float.parseFloat(value));
                    continue block9;
                }
                default: {
                    this.parseSegmentedCacheAttribute(reader, i, attribute, value, builder, holder.getClassLoader(), baseCacheMode);
                }
            }
        }
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case GROUPS: {
                    this.parseGroups(reader, holder);
                    continue block10;
                }
            }
            this.parseSharedStateCacheElement(reader, element, holder);
        }
        holder.popScope();
    }

    private void parseGroups(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String value;
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        ParseUtils.requireSingleAttribute((XMLStreamReader)reader, "enabled");
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.clustering().hash().groups().enabled();
                        continue block6;
                    }
                    builder.clustering().hash().groups().disabled();
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case GROUPER: {
                    value = ParseUtils.readStringAttributeElement(reader, "class");
                    builder.clustering().hash().groups().addGrouper((Grouper)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseScatteredCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, boolean template) throws XMLStreamException {
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        if (!template && GlobUtils.isGlob((String)name)) {
            throw log.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(null, Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(holder, name, template, configuration);
        CacheMode baseCacheMode = configuration == null ? CacheMode.SCATTERED_SYNC : builder.clustering().cacheMode();
        builder.clustering().cacheMode(baseCacheMode);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case INVALIDATION_BATCH_SIZE: {
                    builder.clustering().invalidationBatchSize(Integer.parseInt(value));
                    continue block5;
                }
                default: {
                    this.parseSegmentedCacheAttribute(reader, i, attribute, value, builder, holder.getClassLoader(), baseCacheMode);
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseSharedStateCacheElement(reader, element, holder);
        }
    }

    private ConfigurationBuilder getConfigurationBuilder(ConfigurationBuilderHolder holder, String name, boolean template, String baseConfigurationName) {
        if (holder.getNamedConfigurationBuilders().containsKey(name)) {
            throw log.duplicateCacheName(name);
        }
        ConfigurationBuilder builder = holder.newConfigurationBuilder(name).template(template);
        if (baseConfigurationName != null) {
            ConfigurationBuilder baseConfigurationBuilder = holder.getNamedConfigurationBuilders().get(baseConfigurationName);
            if (baseConfigurationBuilder == null) {
                throw log.undeclaredConfiguration(baseConfigurationName, name);
            }
            Configuration baseConfiguration = baseConfigurationBuilder.build();
            if (!baseConfiguration.isTemplate()) {
                throw log.noConfiguration(baseConfigurationName);
            }
            builder.read(baseConfiguration);
        }
        return builder;
    }

    private void parsePersistence(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PASSIVATION: {
                    builder.persistence().passivation(Boolean.parseBoolean(value));
                    continue block12;
                }
                case AVAILABILITY_INTERVAL: {
                    builder.persistence().availabilityInterval(Integer.parseInt(value));
                    continue block12;
                }
                case CONNECTION_ATTEMPTS: {
                    builder.persistence().connectionAttempts(Integer.parseInt(value));
                    continue block12;
                }
                case CONNECTION_INTERVAL: {
                    builder.persistence().connectionInterval(Integer.parseInt(value));
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        builder.persistence().clearStores();
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLUSTER_LOADER: {
                    this.parseClusterLoader(reader, holder);
                    continue block13;
                }
                case FILE_STORE: {
                    this.parseFileStore(reader, holder);
                    continue block13;
                }
                case STORE: {
                    this.parseCustomStore(reader, holder);
                    continue block13;
                }
                case LOADER: {
                    log.ignoreXmlElement((Object)element);
                    continue block13;
                }
            }
            reader.handleAny(holder);
        }
    }

    private void parseClusterLoader(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        ClusterLoaderConfigurationBuilder cclb = builder.persistence().addClusterLoader();
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            String attrName = reader.getAttributeLocalName(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case REMOTE_TIMEOUT: {
                    cclb.remoteCallTimeout(Long.parseLong(value));
                    continue block3;
                }
                default: {
                    Parser.parseStoreAttribute(reader, i, cclb);
                }
            }
        }
        this.parseStoreElements(reader, cclb);
    }

    protected void parseFileStore(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        SingleFileStoreConfigurationBuilder storeBuilder = holder.getCurrentConfigurationBuilder().persistence().addSingleFileStore();
        String path = null;
        String relativeTo = null;
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    relativeTo = (String)reader.getProperty(value);
                    continue block6;
                }
                case PATH: {
                    path = value;
                    continue block6;
                }
                case MAX_ENTRIES: {
                    storeBuilder.maxEntries(Integer.valueOf(value));
                    continue block6;
                }
                case FRAGMENTATION_FACTOR: {
                    storeBuilder.fragmentationFactor(Float.parseFloat(value));
                    continue block6;
                }
                default: {
                    Parser.parseStoreAttribute(reader, i, storeBuilder);
                }
            }
        }
        if ((path = ParseUtils.resolvePath(path, relativeTo)) != null) {
            storeBuilder.location(path);
        }
        this.parseStoreElements(reader, storeBuilder);
    }

    public static void parseStoreAttribute(XMLExtendedStreamReader reader, int index, AbstractStoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        String value = reader.getAttributeValue(index);
        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case SHARED: {
                storeBuilder.shared(Boolean.parseBoolean(value));
                break;
            }
            case READ_ONLY: {
                storeBuilder.ignoreModifications(Boolean.valueOf(value));
                break;
            }
            case PRELOAD: {
                storeBuilder.preload(Boolean.parseBoolean(value));
                break;
            }
            case FETCH_STATE: {
                storeBuilder.fetchPersistentState(Boolean.parseBoolean(value));
                break;
            }
            case PURGE: {
                storeBuilder.purgeOnStartup(Boolean.parseBoolean(value));
                break;
            }
            case SINGLETON: {
                storeBuilder.singleton().enabled(Boolean.parseBoolean(value));
                break;
            }
            case TRANSACTIONAL: {
                storeBuilder.transactional(Boolean.parseBoolean(value));
                break;
            }
            case MAX_BATCH_SIZE: {
                storeBuilder.maxBatchSize(Integer.parseInt(value));
                break;
            }
            case SEGMENTED: {
                storeBuilder.segmented(Boolean.parseBoolean(value));
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, index);
            }
        }
    }

    private void parseStoreElements(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            Parser.parseStoreElement(reader, storeBuilder);
        }
    }

    public static void parseStoreElement(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case WRITE_BEHIND: {
                Parser.parseStoreWriteBehind(reader, storeBuilder.async().enable());
                break;
            }
            case PROPERTY: {
                Parser.parseStoreProperty(reader, storeBuilder);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    public static void parseStoreWriteBehind(XMLExtendedStreamReader reader, AsyncStoreConfigurationBuilder<?> storeBuilder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FLUSH_LOCK_TIMEOUT: {
                    if (reader.getSchema().since(9, 0)) {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, attribute.getLocalName());
                    }
                    storeBuilder.flushLockTimeout(Long.parseLong(value));
                    continue block7;
                }
                case MODIFICATION_QUEUE_SIZE: {
                    storeBuilder.modificationQueueSize(Integer.parseInt(value));
                    continue block7;
                }
                case FAIL_SILENTLY: {
                    storeBuilder.failSilently(Boolean.parseBoolean(value));
                    continue block7;
                }
                case SHUTDOWN_TIMEOUT: {
                    if (reader.getSchema().since(9, 0)) {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, attribute.getLocalName());
                    }
                    storeBuilder.shutdownTimeout(Long.parseLong(value));
                    continue block7;
                }
                case THREAD_POOL_SIZE: {
                    storeBuilder.threadPoolSize(Integer.parseInt(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    public static void parseStoreProperty(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        String property = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, Attribute.NAME.getLocalName());
        String value = reader.getElementText();
        storeBuilder.addProperty(property, value);
    }

    private void parseCustomStore(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Boolean fetchPersistentState = null;
        Boolean ignoreModifications = null;
        Boolean purgeOnStartup = null;
        Boolean preload = null;
        Boolean shared = null;
        Boolean singleton = null;
        Boolean transactional = null;
        Object store = null;
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    store = (CacheLoader)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader());
                    continue block10;
                }
                case FETCH_STATE: {
                    fetchPersistentState = Boolean.valueOf(value);
                    continue block10;
                }
                case READ_ONLY: {
                    ignoreModifications = Boolean.valueOf(value);
                    continue block10;
                }
                case PURGE: {
                    purgeOnStartup = Boolean.valueOf(value);
                    continue block10;
                }
                case PRELOAD: {
                    preload = Boolean.parseBoolean(value);
                    continue block10;
                }
                case SHARED: {
                    shared = Boolean.parseBoolean(value);
                    continue block10;
                }
                case SINGLETON: {
                    singleton = Boolean.parseBoolean(value);
                    continue block10;
                }
                case TRANSACTIONAL: {
                    transactional = Boolean.parseBoolean(value);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        if (store != null) {
            if (store instanceof SingleFileStore) {
                SingleFileStoreConfigurationBuilder sfs = builder.persistence().addSingleFileStore();
                if (fetchPersistentState != null) {
                    sfs.fetchPersistentState(fetchPersistentState);
                }
                if (ignoreModifications != null) {
                    sfs.ignoreModifications(ignoreModifications);
                }
                if (purgeOnStartup != null) {
                    sfs.purgeOnStartup(purgeOnStartup);
                }
                if (preload != null) {
                    sfs.preload(preload);
                }
                if (shared != null) {
                    sfs.shared(shared);
                }
                if (singleton != null) {
                    sfs.singleton().enabled(singleton);
                }
                if (transactional != null) {
                    sfs.transactional(transactional);
                }
                this.parseStoreElements(reader, sfs);
            } else if (store instanceof ClusterLoader) {
                ClusterLoaderConfigurationBuilder cscb = builder.persistence().addClusterLoader();
                this.parseStoreElements(reader, cscb);
            } else {
                Class configuredBy;
                ConfiguredBy annotation = store.getClass().getAnnotation(ConfiguredBy.class);
                Class<StoreConfigurationBuilder> builderClass = null;
                if (annotation != null && (configuredBy = annotation.value()) != null) {
                    BuiltBy builtBy = configuredBy.getAnnotation(BuiltBy.class);
                    builderClass = builtBy.value().asSubclass(StoreConfigurationBuilder.class);
                }
                Object configBuilder = builderClass == null ? builder.persistence().addStore(CustomStoreConfigurationBuilder.class).customStoreClass(store.getClass()) : builder.persistence().addStore(builderClass);
                if (fetchPersistentState != null) {
                    configBuilder.fetchPersistentState(fetchPersistentState.booleanValue());
                }
                if (ignoreModifications != null) {
                    configBuilder.ignoreModifications(ignoreModifications.booleanValue());
                }
                if (purgeOnStartup != null) {
                    configBuilder.purgeOnStartup(purgeOnStartup.booleanValue());
                }
                if (preload != null) {
                    configBuilder.preload(preload.booleanValue());
                }
                if (shared != null) {
                    configBuilder.shared(shared.booleanValue());
                }
                if (transactional != null) {
                    configBuilder.transactional(transactional.booleanValue());
                }
                this.parseStoreElements(reader, (StoreConfigurationBuilder<?, ?>)configBuilder);
            }
        }
    }

    private void parseIndexing(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case INDEX: {
                    Index index = Index.valueOf(value);
                    builder.indexing().index(index);
                    continue block9;
                }
                case AUTO_CONFIG: {
                    builder.indexing().autoConfig(Boolean.valueOf(value));
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        Properties indexingProperties = new Properties();
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case KEY_TRANSFORMERS: {
                    this.parseKeyTransformers(reader, holder, builder);
                    continue block10;
                }
                case INDEXED_ENTITIES: {
                    this.parseIndexedEntities(reader, holder, builder);
                    continue block10;
                }
                case PROPERTY: {
                    Parser.parseProperty(reader, indexingProperties);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        builder.indexing().withProperties(indexingProperties);
    }

    private void parseKeyTransformers(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ConfigurationBuilder builder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case KEY_TRANSFORMER: {
                    this.parseKeyTransformer(reader, holder, builder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseKeyTransformer(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ConfigurationBuilder builder) throws XMLStreamException {
        String[] attrs = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.KEY.getLocalName(), Attribute.TRANSFORMER.getLocalName());
        Class keyClass = Util.loadClass((String)attrs[0], (ClassLoader)holder.getClassLoader());
        Class transformerClass = Util.loadClass((String)attrs[1], (ClassLoader)holder.getClassLoader());
        builder.indexing().addKeyTransformer(keyClass, transformerClass);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEY: 
                case TRANSFORMER: {
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseIndexedEntities(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ConfigurationBuilder builder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INDEXED_ENTITY: {
                    ParseUtils.requireNoAttributes(reader);
                    String className = reader.getElementText();
                    Class indexedEntity = Util.loadClass((String)className, (ClassLoader)holder.getClassLoader());
                    builder.indexing().addIndexedEntity(indexedEntity);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private static void parseProperty(XMLExtendedStreamReader reader, Properties properties) throws XMLStreamException {
        int attributes = reader.getAttributeCount();
        ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME.getLocalName());
        String key = null;
        block3: for (int i = 0; i < attributes; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    key = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        String propertyValue = reader.getElementText();
        properties.setProperty(key, propertyValue);
    }

    public static Properties parseProperties(XMLExtendedStreamReader reader) throws XMLStreamException {
        Properties properties = new Properties();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    Parser.parseProperty(reader, properties);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        return properties;
    }

    @Override
    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    public static enum Mode {
        SYNC(true),
        ASYNC(false);

        private final boolean sync;

        private Mode(boolean sync) {
            this.sync = sync;
        }

        public static Mode forCacheMode(CacheMode mode) {
            return mode.isSynchronous() ? SYNC : ASYNC;
        }

        public CacheMode apply(CacheMode mode) {
            return this.sync ? mode.toSync() : mode.toAsync();
        }

        public boolean isSynchronous() {
            return this.sync;
        }
    }

    public static enum TransactionMode {
        NONE(org.infinispan.transaction.TransactionMode.NON_TRANSACTIONAL, false, false, false),
        BATCH(org.infinispan.transaction.TransactionMode.TRANSACTIONAL, false, false, true),
        NON_XA(org.infinispan.transaction.TransactionMode.TRANSACTIONAL, false, false, false),
        NON_DURABLE_XA(org.infinispan.transaction.TransactionMode.TRANSACTIONAL, true, false, false),
        FULL_XA(org.infinispan.transaction.TransactionMode.TRANSACTIONAL, true, true, false);

        private final org.infinispan.transaction.TransactionMode mode;
        private final boolean xaEnabled;
        private final boolean recoveryEnabled;
        private final boolean batchingEnabled;

        private TransactionMode(org.infinispan.transaction.TransactionMode mode, boolean xaEnabled, boolean recoveryEnabled, boolean batchingEnabled) {
            this.mode = mode;
            this.xaEnabled = xaEnabled;
            this.recoveryEnabled = recoveryEnabled;
            this.batchingEnabled = batchingEnabled;
        }

        public static TransactionMode fromConfiguration(org.infinispan.transaction.TransactionMode mode, boolean xaEnabled, boolean recoveryEnabled, boolean batchingEnabled) {
            if (mode == org.infinispan.transaction.TransactionMode.NON_TRANSACTIONAL) {
                return NONE;
            }
            for (TransactionMode txMode : TransactionMode.values()) {
                if (txMode.mode != mode || txMode.xaEnabled != xaEnabled || txMode.recoveryEnabled != recoveryEnabled || txMode.batchingEnabled != batchingEnabled) continue;
                return txMode;
            }
            throw log.unknownTransactionConfiguration(mode, xaEnabled, recoveryEnabled, batchingEnabled);
        }

        public org.infinispan.transaction.TransactionMode getMode() {
            return this.mode;
        }

        public boolean isXAEnabled() {
            return this.xaEnabled;
        }

        public boolean isRecoveryEnabled() {
            return this.recoveryEnabled;
        }

        public boolean isBatchingEnabled() {
            return this.batchingEnabled;
        }
    }
}

