/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import java.util.concurrent.CompletionStage;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.concurrent.CompletionStages;

@ThreadSafe
@Scope(value=Scopes.NAMED_CACHE)
@MBean(objectName="Passivation", description="Component that handles passivating entries to a CacheStore on eviction.")
public interface PassivationManager
extends JmxStatisticsExposer {
    public boolean isEnabled();

    default public void passivate(InternalCacheEntry entry) {
        CompletionStages.join(this.passivateAsync(entry));
    }

    public CompletionStage<Void> passivateAsync(InternalCacheEntry var1);

    @Stop(priority=9)
    @ManagedOperation(description="Passivate all entries to the CacheStore", displayName="Passivate all")
    public void passivateAll() throws PersistenceException;

    public void skipPassivationOnStop(boolean var1);

    @ManagedAttribute(description="Number of passivation events", displayName="Number of cache passivations", measurementType=MeasurementType.TRENDSUP)
    public long getPassivations();

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics();
}

