/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.commons.time.TimeService;
import org.infinispan.executors.ManageableExecutorService;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorServiceImpl;

public final class LazyInitializingBlockingTaskAwareExecutorService
extends ManageableExecutorService<ExecutorService>
implements BlockingTaskAwareExecutorService {
    private final ThreadPoolExecutorFactory<ExecutorService> executorFactory;
    private final ThreadFactory threadFactory;
    private final TimeService timeService;
    private final String controllerThreadName;
    private volatile BlockingTaskAwareExecutorServiceImpl blockingExecutor;

    public LazyInitializingBlockingTaskAwareExecutorService(ThreadPoolExecutorFactory<ExecutorService> executorFactory, ThreadFactory threadFactory, TimeService timeService, String controllerThreadName) {
        this.executorFactory = executorFactory;
        this.threadFactory = threadFactory;
        this.timeService = timeService;
        this.controllerThreadName = controllerThreadName;
    }

    @Override
    public void execute(BlockingRunnable runnable) {
        this.initIfNeeded();
        this.blockingExecutor.execute(runnable);
    }

    @Override
    public void checkForReadyTasks() {
        if (this.blockingExecutor != null) {
            this.blockingExecutor.checkForReadyTasks();
        }
    }

    @Override
    public void shutdown() {
        if (this.blockingExecutor != null) {
            this.blockingExecutor.shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (this.blockingExecutor == null) {
            return Collections.emptyList();
        }
        return this.blockingExecutor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.blockingExecutor == null || this.blockingExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.blockingExecutor == null || this.blockingExecutor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.blockingExecutor == null) {
            return true;
        }
        return this.blockingExecutor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.initIfNeeded();
        return this.blockingExecutor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.initIfNeeded();
        return this.blockingExecutor.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.initIfNeeded();
        return this.blockingExecutor.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.initIfNeeded();
        return this.blockingExecutor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        this.initIfNeeded();
        return this.blockingExecutor.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.initIfNeeded();
        return this.blockingExecutor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.initIfNeeded();
        return this.blockingExecutor.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.initIfNeeded();
        this.blockingExecutor.execute(command);
    }

    public BlockingTaskAwareExecutorService getExecutorService() {
        return this.blockingExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNeeded() {
        if (this.blockingExecutor == null) {
            LazyInitializingBlockingTaskAwareExecutorService lazyInitializingBlockingTaskAwareExecutorService = this;
            synchronized (lazyInitializingBlockingTaskAwareExecutorService) {
                if (this.blockingExecutor == null) {
                    this.executor = this.executorFactory.createExecutor(this.threadFactory);
                    this.blockingExecutor = new BlockingTaskAwareExecutorServiceImpl(this.controllerThreadName, this.executor, this.timeService);
                }
            }
        }
    }
}

