/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.components.ComponentMetadata;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.BasicComponentRegistryImpl;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.util.logging.Log;

@SurvivesRestarts
@Scope(value=Scopes.NAMED_CACHE)
@Deprecated
public abstract class AbstractComponentRegistry
implements Lifecycle,
Cloneable {
    public static final boolean DEBUG_DEPENDENCIES = false;
    final ComponentMetadataRepo componentMetadataRepo;
    final BasicComponentRegistry basicComponentRegistry;
    protected volatile ComponentStatus state = ComponentStatus.INSTANTIATED;

    protected AbstractComponentRegistry(ComponentMetadataRepo componentMetadataRepo, ClassLoader classLoader, Scopes scope, BasicComponentRegistry nextBasicComponentRegistry) {
        this.componentMetadataRepo = componentMetadataRepo;
        this.basicComponentRegistry = new BasicComponentRegistryImpl(classLoader, componentMetadataRepo, scope, nextBasicComponentRegistry);
    }

    public ComponentStatus getStatus() {
        return this.state;
    }

    protected abstract ClassLoader getClassLoader();

    protected abstract Log getLog();

    public abstract ComponentMetadataRepo getComponentMetadataRepo();

    public void wireDependencies(Object target) throws CacheConfigurationException {
        boolean startDependencies = this.state == ComponentStatus.RUNNING || this.state == ComponentStatus.INITIALIZING;
        this.basicComponentRegistry.wireDependencies(target, startDependencies);
    }

    public final void registerComponent(Object component, Class<?> type) {
        this.registerComponent(component, type.getName(), type.equals(component.getClass()));
    }

    public final void registerComponent(Object component, String name) {
        this.registerComponent(component, name, name.equals(component.getClass().getName()));
    }

    public final void registerComponent(Object component, String name, boolean nameIsFQCN) {
        this.registerComponentInternal(component, name, nameIsFQCN);
    }

    protected final void registerNonVolatileComponent(Object component, String name) {
        this.registerComponentInternal(component, name, false);
    }

    protected final void registerNonVolatileComponent(Object component, Class<?> type) {
        this.registerComponentInternal(component, type.getName(), true);
    }

    protected void registerComponentInternal(Object component, String name, boolean nameIsFQCN) {
        ComponentRef<Object> ref = this.basicComponentRegistry.registerComponent(name, component, true);
        if (this.state == ComponentStatus.INITIALIZING || this.state == ComponentStatus.RUNNING) {
            ref.running();
        }
    }

    protected <T> T getOrCreateComponent(Class<T> componentClass) {
        return this.getComponent(componentClass, componentClass.getName());
    }

    protected <T> T getOrCreateComponent(Class<T> componentClass, String name) {
        return this.getComponent(componentClass, name);
    }

    protected <T> T getOrCreateComponent(Class<T> componentClass, String name, boolean nameIsFQCN) {
        return this.getComponent(componentClass, name);
    }

    protected AbstractComponentFactory getFactory(Class<?> componentClass) {
        String cfClass = this.getComponentMetadataRepo().findFactoryForComponent(componentClass);
        if (cfClass == null) {
            throw new CacheConfigurationException("No registered default factory for component '" + componentClass + "' found!");
        }
        return this.basicComponentRegistry.getComponent(cfClass, AbstractComponentFactory.class).wired();
    }

    protected AbstractComponentFactory createComponentFactoryInternal(Class<?> componentClass, String cfClass) {
        return this.basicComponentRegistry.getComponent(cfClass, AbstractComponentFactory.class).wired();
    }

    protected Component lookupComponent(String componentClassName, String componentName, boolean nameIsFQCN) {
        Class componentType = Util.loadClass((String)componentClassName, (ClassLoader)this.getClassLoader());
        ComponentRef component = this.basicComponentRegistry.getComponent(componentName, componentType);
        return new Component(component, this.componentMetadataRepo.getComponentMetadata(component.wired().getClass()));
    }

    protected final void registerNullComponent(String name) {
        this.registerComponent(null, name, false);
    }

    public <T> T getComponent(Class<T> type) {
        String className = type.getName();
        return this.getComponent(type, className);
    }

    public <T> T getComponent(String componentClassName) {
        return this.getComponent(componentClassName, componentClassName, true);
    }

    public <T> T getComponent(String componentClassName, String name) {
        return this.getComponent(componentClassName, name, false);
    }

    public <T> T getComponent(Class<T> componentClass, String name) {
        ComponentRef<T> component = this.basicComponentRegistry.getComponent(name, componentClass);
        return component != null ? (T)component.wired() : null;
    }

    public <T> T getComponent(String componentClassName, String name, boolean nameIsFQCN) {
        return (T)this.getComponent(Object.class, name);
    }

    public <T> Optional<T> getOptionalComponent(Class<T> type) {
        return Optional.ofNullable(this.getComponent(type));
    }

    private Object unwrapComponent(Component wrapper) {
        return wrapper.getInstance();
    }

    protected ClassLoader registerDefaultClassLoader(ClassLoader loader) {
        ClassLoader loaderToUse = loader == null ? this.getClass().getClassLoader() : loader;
        this.registerComponent((Object)loaderToUse, ClassLoader.class);
        return loaderToUse;
    }

    public void rewire() {
        this.basicComponentRegistry.rewire();
    }

    private void populateLifecycleMethods() {
    }

    public void resetVolatileComponents() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        AbstractComponentRegistry abstractComponentRegistry = this;
        synchronized (abstractComponentRegistry) {
            try {
                while (this.state == ComponentStatus.INITIALIZING) {
                    this.wait();
                }
                if (this.state != ComponentStatus.INSTANTIATED) {
                    return;
                }
                this.state = ComponentStatus.INITIALIZING;
            }
            catch (InterruptedException e) {
                throw new CacheException("Interrupted waiting for the component registry to start");
            }
        }
        this.preStart();
        try {
            this.internalStart();
            abstractComponentRegistry = this;
            synchronized (abstractComponentRegistry) {
                this.state = ComponentStatus.RUNNING;
                this.notifyAll();
            }
            this.postStart();
        }
        catch (Throwable t) {
            AbstractComponentRegistry abstractComponentRegistry2 = this;
            synchronized (abstractComponentRegistry2) {
                this.state = ComponentStatus.FAILED;
                this.notifyAll();
            }
            this.handleLifecycleTransitionFailure(t);
        }
    }

    protected abstract void preStart();

    protected abstract void postStart();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        boolean failed;
        AbstractComponentRegistry abstractComponentRegistry = this;
        synchronized (abstractComponentRegistry) {
            try {
                while (this.state == ComponentStatus.STOPPING) {
                    this.wait();
                }
                if (!this.state.stopAllowed()) {
                    this.getLog().debugf("Ignoring call to stop() as current state is %s", (Object)this.state);
                    return;
                }
                failed = this.state == ComponentStatus.FAILED;
                this.state = ComponentStatus.STOPPING;
            }
            catch (InterruptedException e) {
                throw new CacheException("Interrupted waiting for the component registry to stop");
            }
        }
        this.preStop();
        try {
            this.internalStop();
            this.postStop();
        }
        catch (Throwable t) {
            if (failed) {
                this.getLog().failedToCallStopAfterFailure(t);
            } else {
                this.handleLifecycleTransitionFailure(t);
            }
        }
        finally {
            abstractComponentRegistry = this;
            synchronized (abstractComponentRegistry) {
                this.state = ComponentStatus.TERMINATED;
            }
        }
    }

    protected abstract void postStop();

    protected abstract void preStop();

    private void handleLifecycleTransitionFailure(Throwable t) {
        if (t.getCause() != null && t.getCause() instanceof CacheConfigurationException) {
            throw (CacheConfigurationException)t.getCause();
        }
        if (t.getCause() != null && t.getCause() instanceof InvocationTargetException && t.getCause().getCause() != null && t.getCause().getCause() instanceof CacheConfigurationException) {
            throw (CacheConfigurationException)t.getCause().getCause();
        }
        if (t instanceof CacheException) {
            throw (CacheException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new CacheException(t);
    }

    private void internalStart() throws CacheException, IllegalArgumentException {
        Collection<ComponentRef<?>> components = this.basicComponentRegistry.getRegisteredComponents();
        for (ComponentRef<?> component : components) {
            component.running();
        }
        this.addShutdownHook();
    }

    protected void addShutdownHook() {
    }

    protected void removeShutdownHook() {
    }

    private void internalStop() {
        this.removeShutdownHook();
        this.basicComponentRegistry.stop();
    }

    public Set<Component> getRegisteredComponents() {
        HashSet<Component> set = new HashSet<Component>();
        for (ComponentRef<?> c : this.basicComponentRegistry.getRegisteredComponents()) {
            ComponentMetadata metadata = c.wired() != null ? this.componentMetadataRepo.getComponentMetadata(c.wired().getClass()) : null;
            Component component = new Component(c, metadata);
            set.add(component);
        }
        return set;
    }

    public AbstractComponentRegistry clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public abstract TimeService getTimeService();

    protected void throwStackAwareConfigurationException(String message) {
        throw new CacheConfigurationException(message);
    }

    public class Component {
        private final ComponentRef ref;
        private final ComponentMetadata metadata;

        Component(ComponentRef ref, ComponentMetadata metadata) {
            this.ref = ref;
            this.metadata = metadata;
        }

        public void injectDependencies() {
        }

        public Object getInstance() {
            return this.ref.wired();
        }

        public String getName() {
            return this.ref.getName();
        }

        public ComponentMetadata getMetadata() {
            return this.metadata;
        }

        public void buildInjectionMethodsList() throws ClassNotFoundException {
        }

        public void buildInjectionFieldsList() throws ClassNotFoundException {
        }

        public String toString() {
            return this.ref.toString();
        }
    }
}

