/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.AdvancedCache;
import org.infinispan.cache.impl.CacheConfigurationMBean;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.conflict.impl.InternalConflictManager;
import org.infinispan.conflict.impl.StateReceiver;
import org.infinispan.container.versioning.NumericVersionGenerator;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.components.ComponentMetadata;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.persistence.manager.PreloadManager;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManager;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.stats.ClusterCacheStats;
import org.infinispan.stream.impl.ClusterStreamManager;
import org.infinispan.stream.impl.LocalStreamManager;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupSender;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;

public class ComponentRegistry
extends AbstractComponentRegistry {
    private static final Log log = LogFactory.getLog(ComponentRegistry.class);
    private static final boolean trace = log.isTraceEnabled();
    private final String cacheName;
    private final Configuration configuration;
    private final GlobalComponentRegistry globalComponents;
    @Inject
    private CacheManagerNotifier cacheManagerNotifier;
    private StateTransferManager stateTransferManager;
    private ResponseGenerator responseGenerator;
    private CommandsFactory commandsFactory;
    private StateTransferLock stateTransferLock;
    private PerCacheInboundInvocationHandler inboundInvocationHandler;
    private VersionGenerator versionGenerator;
    private DistributionManager distributionManager;

    public ComponentRegistry(String cacheName, Configuration configuration, AdvancedCache<?, ?> cache, GlobalComponentRegistry globalComponents, ClassLoader defaultClassLoader) {
        super(globalComponents.getComponentMetadataRepo(), defaultClassLoader, Scopes.NAMED_CACHE, globalComponents.getComponent(BasicComponentRegistry.class));
        if (cacheName == null) {
            throw new CacheConfigurationException("Cache name cannot be null!");
        }
        try {
            this.cacheName = cacheName;
            this.configuration = configuration;
            this.globalComponents = globalComponents;
            this.basicComponentRegistry.registerComponent("cacheName", cacheName, false);
            this.basicComponentRegistry.registerComponent(ComponentRegistry.class, this, false);
            this.basicComponentRegistry.registerComponent(Configuration.class, configuration, false);
            this.bootstrapComponents();
        }
        catch (Exception e) {
            throw new CacheException("Unable to construct a ComponentRegistry!", (Throwable)e);
        }
    }

    @Override
    protected ClassLoader getClassLoader() {
        return this.globalComponents.getClassLoader();
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public final <T> T getComponent(String componentTypeName, String name, boolean nameIsFQCN) {
        Class componentType = Util.loadClass((String)componentTypeName, (ClassLoader)this.getClassLoader());
        ComponentRef component = this.basicComponentRegistry.getComponent(name, componentType);
        return component != null ? (T)component.running() : null;
    }

    public final <T> T getLocalComponent(String componentTypeName, String name, boolean nameIsFQCN) {
        Class componentType = Util.loadClass((String)componentTypeName, (ClassLoader)this.getClassLoader());
        ComponentRef componentRef = this.basicComponentRegistry.getComponent(name, componentType);
        if (componentRef == null || componentRef.wired() == null) {
            return null;
        }
        Class<?> componentClass = componentRef.wired().getClass();
        ComponentMetadata metadata = this.getComponentMetadataRepo().getComponentMetadata(componentClass);
        if (metadata != null && metadata.isGlobalScope()) {
            return null;
        }
        return componentRef.running();
    }

    public final <T> T getLocalComponent(Class<T> componentType) {
        String componentTypeName = componentType.getName();
        return this.getLocalComponent(componentTypeName, componentTypeName, true);
    }

    protected final AbstractComponentRegistry.Component lookupLocalComponent(String componentClassName, String name, boolean nameIsFQCN) {
        throw new UnsupportedOperationException("The component metadata is no longer exposed");
    }

    public final GlobalComponentRegistry getGlobalComponentRegistry() {
        return this.globalComponents;
    }

    @Override
    protected final <T> T getOrCreateComponent(Class<T> componentClass, String name, boolean nameIsFQCN) {
        ComponentRef<T> component = this.basicComponentRegistry.getComponent(name, componentClass);
        return component != null ? (T)component.running() : null;
    }

    @Override
    public void start() {
        if (this.state.needToDestroyFailedCache()) {
            this.stop();
        }
        if (this.state.needToInitializeBeforeStart()) {
            this.state = ComponentStatus.INSTANTIATED;
            this.rewire();
        }
        super.start();
    }

    @Override
    protected void preStart() {
        this.cacheComponents();
        this.globalComponents.registerNamedComponentRegistry(this, this.cacheName);
        this.notifyCacheStarting(this.configuration);
    }

    @Override
    protected void postStart() {
        CompletionStages.join(this.cacheManagerNotifier.notifyCacheStarted(this.cacheName));
    }

    private void notifyCacheStarting(Configuration configuration) {
        for (ModuleLifecycle l : this.globalComponents.moduleLifecycles) {
            l.cacheStarting(this, configuration, this.cacheName);
        }
    }

    @Override
    protected void preStop() {
        this.globalComponents.unregisterNamedComponentRegistry(this.cacheName);
        for (ModuleLifecycle l : this.globalComponents.moduleLifecycles) {
            if (log.isTraceEnabled()) {
                log.tracef("Invoking %s.cacheStopping()", l);
            }
            try {
                l.cacheStopping(this, this.cacheName);
            }
            catch (Throwable t) {
                log.moduleStopError(l.getClass().getName() + ":" + this.cacheName, t);
            }
        }
    }

    @Override
    protected void postStop() {
        for (ModuleLifecycle l : this.globalComponents.moduleLifecycles) {
            if (log.isTraceEnabled()) {
                log.tracef("Invoking %s.cacheStopped()", l);
            }
            try {
                l.cacheStopped(this, this.cacheName);
            }
            catch (Throwable t) {
                log.moduleStopError(l.getClass().getName() + ":" + this.cacheName, t);
            }
        }
        CompletionStages.join(this.cacheManagerNotifier.notifyCacheStopped(this.cacheName));
    }

    @Override
    public TimeService getTimeService() {
        return this.globalComponents.getTimeService();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public StreamingMarshaller getCacheMarshaller() {
        return this.globalComponents.getComponent(StreamingMarshaller.class);
    }

    public StateTransferManager getStateTransferManager() {
        return this.stateTransferManager;
    }

    public DistributionManager getDistributionManager() {
        return this.distributionManager;
    }

    public ResponseGenerator getResponseGenerator() {
        return this.responseGenerator;
    }

    public CommandsFactory getCommandsFactory() {
        return this.commandsFactory;
    }

    public StateTransferLock getStateTransferLock() {
        return this.stateTransferLock;
    }

    public VersionGenerator getVersionGenerator() {
        return this.versionGenerator;
    }

    public PerCacheInboundInvocationHandler getPerCacheInboundInvocationHandler() {
        return this.inboundInvocationHandler;
    }

    protected void bootstrapComponents() {
    }

    public void cacheComponents() {
        this.stateTransferManager = this.basicComponentRegistry.getComponent(StateTransferManager.class).wired();
        this.responseGenerator = this.basicComponentRegistry.getComponent(ResponseGenerator.class).wired();
        this.commandsFactory = this.basicComponentRegistry.getComponent(CommandsFactory.class).wired();
        this.stateTransferLock = this.basicComponentRegistry.getComponent(StateTransferLock.class).wired();
        this.inboundInvocationHandler = this.basicComponentRegistry.getComponent(PerCacheInboundInvocationHandler.class).wired();
        this.versionGenerator = this.basicComponentRegistry.getComponent(VersionGenerator.class).wired();
        this.distributionManager = this.basicComponentRegistry.getComponent(DistributionManager.class).wired();
        this.basicComponentRegistry.getComponent(ClusterCacheStats.class);
        this.basicComponentRegistry.getComponent(CacheConfigurationMBean.class);
        this.basicComponentRegistry.getComponent(InternalConflictManager.class);
        this.basicComponentRegistry.getComponent(LocalStreamManager.class);
        this.basicComponentRegistry.getComponent(ClusterStreamManager.class);
        this.basicComponentRegistry.getComponent(ClusterPublisherManager.class);
        this.basicComponentRegistry.getComponent(XSiteStateTransferManager.class);
        this.basicComponentRegistry.getComponent(BackupSender.class);
        this.basicComponentRegistry.getComponent(StateTransferManager.class);
        this.basicComponentRegistry.getComponent(StateReceiver.class);
        this.basicComponentRegistry.getComponent(PreloadManager.class);
    }

    @Override
    public ComponentMetadataRepo getComponentMetadataRepo() {
        return this.globalComponents.getComponentMetadataRepo();
    }

    public final org.infinispan.transaction.TransactionTable getTransactionTable() {
        return this.getComponent(TransactionTable.class);
    }

    public final synchronized void registerVersionGenerator(NumericVersionGenerator newVersionGenerator) {
        this.versionGenerator = newVersionGenerator;
        this.registerComponent((Object)newVersionGenerator, VersionGenerator.class);
    }
}

