/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commands.CancelCommand;
import org.infinispan.commands.CreateCacheCommand;
import org.infinispan.commands.RemoveCacheCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.ClusteredGetAllCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.RenewBiasCommand;
import org.infinispan.commands.remote.RevokeBiasCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.expiration.RetrieveLastAccessCommand;
import org.infinispan.commands.remote.expiration.UpdateLastAccessCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.triangle.MultiEntriesFunctionalBackupWriteCommand;
import org.infinispan.commands.triangle.MultiKeyFunctionalBackupWriteCommand;
import org.infinispan.commands.triangle.PutMapBackupWriteCommand;
import org.infinispan.commands.triangle.SingleKeyBackupWriteCommand;
import org.infinispan.commands.triangle.SingleKeyFunctionalBackupWriteCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderCommitCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderNonVersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderRollbackCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderVersionedCommitCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderVersionedPrepareCommand;
import org.infinispan.commands.write.InvalidateVersionsCommand;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.marshall.exts.ReplicableCommandExternalizer;
import org.infinispan.notifications.cachelistener.cluster.MultiClusterEventCommand;
import org.infinispan.reactive.publisher.impl.PublisherRequestCommand;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.stream.impl.StreamIteratorCloseCommand;
import org.infinispan.stream.impl.StreamIteratorNextCommand;
import org.infinispan.stream.impl.StreamIteratorRequestCommand;
import org.infinispan.stream.impl.StreamRequestCommand;
import org.infinispan.stream.impl.StreamResponseCommand;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.SingleXSiteRpcCommand;
import org.infinispan.xsite.XSiteAdminCommand;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;
import org.infinispan.xsite.statetransfer.XSiteStateTransferControlCommand;

public final class CacheRpcCommandExternalizer
extends AbstractExternalizer<CacheRpcCommand> {
    private final GlobalComponentRegistry gcr;
    private final ReplicableCommandExternalizer cmdExt;

    public CacheRpcCommandExternalizer(GlobalComponentRegistry gcr, ReplicableCommandExternalizer cmdExt) {
        this.cmdExt = cmdExt;
        this.gcr = gcr;
    }

    public Set<Class<? extends CacheRpcCommand>> getTypeClasses() {
        Set coreCommands = Util.asSet((Object[])new Class[]{LockControlCommand.class, StateRequestCommand.class, StateResponseCommand.class, ClusteredGetCommand.class, SingleRpcCommand.class, CommitCommand.class, PrepareCommand.class, RollbackCommand.class, RemoveCacheCommand.class, TxCompletionNotificationCommand.class, GetInDoubtTransactionsCommand.class, GetInDoubtTxInfoCommand.class, CompleteTransactionCommand.class, VersionedPrepareCommand.class, CreateCacheCommand.class, CancelCommand.class, VersionedCommitCommand.class, XSiteAdminCommand.class, TotalOrderNonVersionedPrepareCommand.class, TotalOrderVersionedPrepareCommand.class, TotalOrderCommitCommand.class, TotalOrderVersionedCommitCommand.class, TotalOrderRollbackCommand.class, XSiteStateTransferControlCommand.class, XSiteStatePushCommand.class, SingleXSiteRpcCommand.class, ClusteredGetAllCommand.class, StreamRequestCommand.class, StreamResponseCommand.class, SingleKeyBackupWriteCommand.class, SingleKeyFunctionalBackupWriteCommand.class, PutMapBackupWriteCommand.class, MultiEntriesFunctionalBackupWriteCommand.class, MultiKeyFunctionalBackupWriteCommand.class, InvalidateVersionsCommand.class, StreamIteratorRequestCommand.class, StreamIteratorNextCommand.class, StreamIteratorCloseCommand.class, RevokeBiasCommand.class, RenewBiasCommand.class, RetrieveLastAccessCommand.class, UpdateLastAccessCommand.class, PublisherRequestCommand.class, MultiClusterEventCommand.class});
        coreCommands.addAll(this.gcr.getModuleProperties().moduleCacheRpcCommands());
        return coreCommands;
    }

    public void writeObject(ObjectOutput output, CacheRpcCommand command) throws IOException {
        this.cmdExt.writeCommandHeader(output, command);
        ByteString cacheName = command.getCacheName();
        ByteString.writeObject(output, cacheName);
        this.marshallParameters(command, output);
    }

    private void marshallParameters(CacheRpcCommand cmd, ObjectOutput oo) throws IOException {
        this.cmdExt.writeCommandParameters(oo, cmd);
    }

    public CacheRpcCommand readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        byte type = input.readByte();
        byte methodId = (byte)input.readShort();
        ByteString cacheName = ByteString.readObject(input);
        CacheRpcCommand cacheRpcCommand = this.cmdExt.fromStream(methodId, type, cacheName);
        this.cmdExt.readCommandParameters(input, cacheRpcCommand);
        return cacheRpcCommand;
    }

    public Integer getId() {
        return 36;
    }
}

