/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.persistence.impl;

import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.persistence.impl.MarshalledEntryImpl;
import org.infinispan.marshall.persistence.impl.MarshalledValueImpl;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshalledValue;
import org.infinispan.persistence.spi.PersistenceException;

public class MarshallableEntryImpl<K, V>
implements MarshallableEntry<K, V> {
    long created;
    long lastUsed;
    ByteBuffer valueBytes;
    ByteBuffer metadataBytes;
    volatile ByteBuffer keyBytes;
    volatile transient K key;
    volatile transient V value;
    volatile transient Metadata metadata;
    transient Marshaller marshaller;

    MarshallableEntryImpl() {
    }

    MarshallableEntryImpl(K key, V value, Metadata metadata, long created, long lastUsed, Marshaller marshaller) {
        this.key = key;
        this.value = value;
        this.metadata = metadata;
        this.keyBytes = MarshallableEntryImpl.marshall(key, marshaller);
        this.valueBytes = MarshallableEntryImpl.marshall(value, marshaller);
        this.metadataBytes = MarshallableEntryImpl.marshall(metadata, marshaller);
        this.created = created;
        this.lastUsed = lastUsed;
        this.marshaller = marshaller;
    }

    MarshallableEntryImpl(ByteBuffer key, ByteBuffer valueBytes, ByteBuffer metadataBytes, long created, long lastUsed, Marshaller marshaller) {
        this.keyBytes = key;
        this.valueBytes = valueBytes;
        this.metadataBytes = metadataBytes;
        this.created = created;
        this.lastUsed = lastUsed;
        this.marshaller = marshaller;
    }

    MarshallableEntryImpl(K key, ByteBuffer valueBytes, ByteBuffer metadataBytes, long created, long lastUsed, Marshaller marshaller) {
        this(MarshallableEntryImpl.marshall(key, marshaller), valueBytes, metadataBytes, created, lastUsed, marshaller);
        this.key = key;
    }

    @Override
    public K getKey() {
        if (this.key == null) {
            if (this.keyBytes == null) {
                return null;
            }
            this.key = this.unmarshall(this.keyBytes);
        }
        return this.key;
    }

    @Override
    public V getValue() {
        if (this.value == null) {
            if (this.valueBytes == null) {
                return null;
            }
            this.value = this.unmarshall(this.valueBytes);
        }
        return this.value;
    }

    @Override
    public Metadata getMetadata() {
        if (this.metadata == null) {
            if (this.metadataBytes == null) {
                return null;
            }
            this.metadata = (Metadata)this.unmarshall(this.metadataBytes);
        }
        return this.metadata;
    }

    @Override
    public ByteBuffer getKeyBytes() {
        if (this.keyBytes == null) {
            this.keyBytes = MarshallableEntryImpl.marshall(this.key, this.marshaller);
        }
        return this.keyBytes;
    }

    @Override
    public ByteBuffer getValueBytes() {
        return this.valueBytes;
    }

    @Override
    public ByteBuffer getMetadataBytes() {
        return this.metadataBytes;
    }

    @Override
    public long created() {
        return this.created;
    }

    @Override
    public long lastUsed() {
        return this.lastUsed;
    }

    @Override
    public boolean isExpired(long now) {
        long expiry = this.expiryTime();
        return expiry > 0L && expiry <= now;
    }

    @Override
    public long expiryTime() {
        long muet;
        Metadata metadata = this.getMetadata();
        if (metadata == null) {
            return -1L;
        }
        long lifespan = metadata.lifespan();
        long lset = lifespan > -1L ? this.created() + lifespan : -1L;
        long maxIdle = metadata.maxIdle();
        long l = muet = maxIdle > -1L ? this.lastUsed() + maxIdle : -1L;
        if (lset == -1L) {
            return muet;
        }
        if (muet == -1L) {
            return lset;
        }
        return Math.min(lset, muet);
    }

    @Override
    public MarshalledEntry<K, V> asMarshalledEntry() {
        Metadata meta = this.getMetadata();
        InternalMetadataImpl internalMeta = meta == null ? null : new InternalMetadataImpl(meta, this.created(), this.lastUsed());
        return new MarshalledEntryImpl<K, V>(this.getKey(), this.getValue(), internalMeta, this.marshaller);
    }

    @Override
    public MarshalledValue getMarshalledValue() {
        return new MarshalledValueImpl(this.valueBytes, this.metadataBytes, this.created, this.lastUsed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MarshallableEntryImpl)) {
            return false;
        }
        MarshallableEntryImpl that = (MarshallableEntryImpl)o;
        if (this.getKeyBytes() != null ? !this.getKeyBytes().equals(that.getKeyBytes()) : that.getKeyBytes() != null) {
            return false;
        }
        if (this.getMetadataBytes() != null ? !this.getMetadataBytes().equals(that.getMetadataBytes()) : that.getMetadataBytes() != null) {
            return false;
        }
        if (this.getValueBytes() != null ? !this.getValueBytes().equals(that.getValueBytes()) : that.getValueBytes() != null) {
            return false;
        }
        return this.expiryTime() == that.expiryTime();
    }

    public int hashCode() {
        long expiryTime = this.expiryTime();
        int result = this.getKeyBytes() != null ? this.getKeyBytes().hashCode() : 0;
        result = 31 * result + (this.getValueBytes() != null ? this.getValueBytes().hashCode() : 0);
        result = 31 * result + (this.getMetadataBytes() != null ? this.getMetadataBytes().hashCode() : 0);
        result = 31 * result + (int)(expiryTime ^ expiryTime >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.getClass().getSimpleName()).append("{keyBytes=").append(this.keyBytes).append(", valueBytes=").append(this.valueBytes).append(", metadataBytes=").append(this.metadataBytes).append(", key=").append(this.key);
        if (this.key == null && this.keyBytes != null && this.marshaller != null) {
            sb.append('/').append(this.unmarshall(this.keyBytes));
        }
        sb.append(", value=").append(this.value);
        if (this.value == null && this.valueBytes != null && this.marshaller != null) {
            sb.append('/').append(this.unmarshall(this.valueBytes));
        }
        sb.append(", metadata=").append(this.metadata);
        if (this.metadata == null && this.metadataBytes != null && this.marshaller != null) {
            sb.append('/').append(this.unmarshall(this.metadataBytes));
        }
        sb.append(", created=").append(this.created);
        sb.append(", lastUsed=").append(this.lastUsed);
        sb.append(", marshaller=").append(this.marshaller).append('}');
        return sb.toString();
    }

    static ByteBuffer marshall(Object obj, Marshaller marshaller) {
        if (obj == null) {
            return null;
        }
        try {
            return marshaller.objectToBuffer(obj);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    <T> T unmarshall(ByteBuffer buf) {
        return MarshallableEntryImpl.unmarshall(buf, this.marshaller);
    }

    static <T> T unmarshall(ByteBuffer buf, Marshaller marshaller) {
        if (buf == null) {
            return null;
        }
        try {
            return (T)marshaller.objectFromByteBuffer(buf.getBuf(), buf.getOffset(), buf.getLength());
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }
}

