/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.persistence.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.persistence.spi.MarshalledValue;

public class MarshalledValueImpl
implements MarshalledValue {
    static final MarshalledValue EMPTY = new MarshalledValueImpl();
    ByteBuffer valueBytes;
    ByteBuffer metadataBytes;
    long created;
    long lastUsed;

    MarshalledValueImpl(ByteBuffer valueBytes, ByteBuffer metadataBytes, long created, long lastUsed) {
        this.valueBytes = valueBytes;
        this.metadataBytes = metadataBytes;
        this.created = created;
        this.lastUsed = lastUsed;
    }

    MarshalledValueImpl() {
    }

    @Override
    public ByteBuffer getValueBytes() {
        return this.valueBytes;
    }

    @Override
    public ByteBuffer getMetadataBytes() {
        return this.metadataBytes;
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarshalledValueImpl that = (MarshalledValueImpl)o;
        return this.created == that.created && this.lastUsed == that.lastUsed && Objects.equals(this.valueBytes, that.valueBytes) && Objects.equals(this.metadataBytes, that.metadataBytes);
    }

    public int hashCode() {
        return Objects.hash(this.valueBytes, this.metadataBytes, this.created, this.lastUsed);
    }

    public String toString() {
        return "MarshalledValueImpl{valueBytes=" + this.valueBytes + ", metadataBytes=" + this.metadataBytes + ", created=" + this.created + ", lastUsed=" + this.lastUsed + '}';
    }

    public static class Externalizer
    implements AdvancedExternalizer<MarshalledValueImpl> {
        public void writeObject(ObjectOutput output, MarshalledValueImpl e) throws IOException {
            output.writeObject(e.valueBytes);
            output.writeObject(e.metadataBytes);
            output.writeLong(e.created);
            output.writeLong(e.lastUsed);
        }

        public MarshalledValueImpl readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            MarshalledValueImpl e = new MarshalledValueImpl();
            e.valueBytes = (ByteBuffer)input.readObject();
            e.metadataBytes = (ByteBuffer)input.readObject();
            e.created = input.readLong();
            e.lastUsed = input.readLong();
            return e;
        }

        public Set<Class<? extends MarshalledValueImpl>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{MarshalledValueImpl.class});
        }

        public Integer getId() {
            return 142;
        }
    }
}

