/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetCacheInterceptorChainAction;
import org.infinispan.security.actions.GetClusterExecutorAction;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return Security.doPrivileged(action);
    }

    static ClusterExecutor getClusterExecutor(Cache<?, ?> cache) {
        GetClusterExecutorAction action = new GetClusterExecutorAction(cache);
        return SecurityActions.doPrivileged(action);
    }

    static List<AsyncInterceptor> getInterceptorChain(Cache<?, ?> cache) {
        GetCacheInterceptorChainAction action = new GetCacheInterceptorChainAction(cache.getAdvancedCache());
        return SecurityActions.doPrivileged(action);
    }

    static AsyncInterceptorChain getAsyncInterceptorChain(Cache<?, ?> cache) {
        return SecurityActions.doPrivileged(() -> cache.getAdvancedCache().getAsyncInterceptorChain());
    }
}

