/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.spi;

import io.reactivex.Flowable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.reactivestreams.Publisher;

@ThreadSafe
public interface CacheWriter<K, V>
extends Lifecycle {
    public void init(InitializationContext var1);

    default public void write(MarshallableEntry<? extends K, ? extends V> entry) {
        this.write(entry.asMarshalledEntry());
    }

    @Deprecated
    default public void write(MarshalledEntry<? extends K, ? extends V> entry) {
    }

    public boolean delete(Object var1);

    @Deprecated
    default public void writeBatch(Iterable<MarshalledEntry<? extends K, ? extends V>> entries) {
        entries.forEach(e -> this.write((MarshallableEntry<? extends K, ? extends V>)e));
    }

    default public CompletionStage<Void> bulkUpdate(Publisher<MarshallableEntry<? extends K, ? extends V>> publisher) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.writeBatch(Flowable.fromPublisher(publisher).map(e -> ((MarshallableEntry)e).asMarshalledEntry()).blockingIterable());
            future.complete(null);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    default public void deleteBatch(Iterable<Object> keys) {
        keys.forEach(this::delete);
    }

    default public boolean isAvailable() {
        return true;
    }
}

