/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive;

import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import io.reactivex.processors.AsyncProcessor;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class RxJavaInterop {
    private static final Function<Single<Object>, CompletionStage<Object>> singleToCompletionStage = single -> {
        CompletableFuture cf = new CompletableFuture();
        single.subscribe(cf::complete, cf::completeExceptionally);
        return cf;
    };
    private static final Function<Maybe<Object>, CompletionStage<Object>> maybeToCompletionStage = maybe -> {
        CompletableFuture cf = new CompletableFuture();
        maybe.subscribe(cf::complete, cf::completeExceptionally, () -> cf.complete(null));
        return cf;
    };
    private static final java.util.function.Function<CompletionStage<Object>, Flowable<Object>> completionStageToPublisher = stage -> {
        AsyncProcessor asyncProcessor = AsyncProcessor.create();
        stage.whenComplete((value, t) -> {
            if (t != null) {
                asyncProcessor.onError(t);
            } else {
                asyncProcessor.onNext(value);
                asyncProcessor.onComplete();
            }
        });
        return asyncProcessor;
    };
    private static final Function<Map.Entry<Object, Object>, Object> entryToKeyFunction = Map.Entry::getKey;

    private RxJavaInterop() {
    }

    public static <E> Function<Single<E>, CompletionStage<E>> singleToCompletionStage() {
        return singleToCompletionStage;
    }

    public static <E> Function<Maybe<E>, CompletionStage<E>> maybeToCompletionStage() {
        return maybeToCompletionStage;
    }

    public static <E> java.util.function.Function<CompletionStage<E>, Flowable<E>> completionStageToPublisher() {
        return completionStageToPublisher;
    }

    public static <K, V> Function<Map.Entry<K, V>, K> entryToKeyFunction() {
        return entryToKeyFunction;
    }
}

