/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.LocalPublisherManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;

public class PublisherRequestCommand<K>
extends BaseRpcCommand
implements TopologyAffectedCommand {
    public static final byte COMMAND_ID = 31;
    private LocalPublisherManager lpm;
    private boolean parallelStream;
    private DeliveryGuarantee deliveryGuarantee;
    private IntSet segments;
    private Set<K> keys;
    private Set<K> excludedKeys;
    private boolean includeLoader;
    private boolean entryStream;
    private Function transformer;
    private Function finalizer;
    private int topologyId = -1;

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    private PublisherRequestCommand() {
        super(null);
    }

    public PublisherRequestCommand(ByteString cacheName) {
        super(cacheName);
    }

    public PublisherRequestCommand(ByteString cacheName, boolean parallelStream, DeliveryGuarantee deliveryGuarantee, IntSet segments, Set<K> keys, Set<K> excludedKeys, boolean includeLoader, boolean entryStream, Function transformer, Function finalizer) {
        super(cacheName);
        this.parallelStream = parallelStream;
        this.deliveryGuarantee = deliveryGuarantee;
        this.segments = segments;
        this.keys = keys;
        this.excludedKeys = excludedKeys;
        this.includeLoader = includeLoader;
        this.entryStream = entryStream;
        this.transformer = transformer;
        this.finalizer = finalizer;
    }

    public void inject(LocalPublisherManager lpm) {
        this.lpm = lpm;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        if (this.entryStream) {
            return (CompletableFuture)this.lpm.entryReduction(this.parallelStream, this.segments, this.keys, this.excludedKeys, this.includeLoader, this.deliveryGuarantee, this.transformer, this.finalizer);
        }
        return (CompletableFuture)this.lpm.keyReduction(this.parallelStream, this.segments, this.keys, this.excludedKeys, this.includeLoader, this.deliveryGuarantee, this.transformer, this.finalizer);
    }

    @Override
    public byte getCommandId() {
        return 31;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.getOrigin());
        output.writeBoolean(this.parallelStream);
        MarshallUtil.marshallEnum((Enum)this.deliveryGuarantee, (ObjectOutput)output);
        output.writeObject(this.segments);
        MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
        MarshallUtil.marshallCollection(this.excludedKeys, (ObjectOutput)output);
        output.writeBoolean(this.includeLoader);
        output.writeBoolean(this.entryStream);
        output.writeObject(this.transformer);
        output.writeObject(this.finalizer);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.setOrigin((Address)input.readObject());
        this.parallelStream = input.readBoolean();
        this.deliveryGuarantee = (DeliveryGuarantee)MarshallUtil.unmarshallEnum((ObjectInput)input, DeliveryGuarantee::valueOf);
        this.segments = (IntSet)input.readObject();
        this.keys = (Set)MarshallUtil.unmarshallCollectionUnbounded((ObjectInput)input, HashSet::new);
        this.excludedKeys = (Set)MarshallUtil.unmarshallCollectionUnbounded((ObjectInput)input, HashSet::new);
        this.includeLoader = input.readBoolean();
        this.entryStream = input.readBoolean();
        this.transformer = (Function)input.readObject();
        this.finalizer = (Function)input.readObject();
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return !this.parallelStream;
    }

    @Override
    public String toString() {
        return "PublisherRequestCommand{, includeLoader=" + this.includeLoader + ", topologyId=" + this.topologyId + ", segments=" + this.segments + ", keys=" + Util.toStr(this.keys) + ", excludedKeys=" + Util.toStr(this.excludedKeys) + ", transformer= " + this.transformer + ", finalizer=" + this.finalizer + '}';
    }
}

