/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler.action;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.remoting.inboundhandler.action.ActionListener;
import org.infinispan.remoting.inboundhandler.action.ActionState;
import org.infinispan.remoting.inboundhandler.action.ActionStatus;
import org.infinispan.remoting.inboundhandler.action.BaseLockingAction;
import org.infinispan.util.concurrent.locks.KeyAwareLockPromise;
import org.infinispan.util.concurrent.locks.LockListener;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.LockPromise;
import org.infinispan.util.concurrent.locks.LockState;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;
import org.infinispan.util.concurrent.locks.TransactionalRemoteLockCommand;

public class LockAction
extends BaseLockingAction
implements LockListener {
    private final LockManager lockManager;
    private final CompletableFuture<Void> notifier;
    private volatile LockPromise lockPromise;

    public LockAction(LockManager lockManager, DistributionManager distributionManager) {
        super(distributionManager);
        this.lockManager = lockManager;
        this.notifier = new CompletableFuture();
    }

    @Override
    protected ActionStatus checking(ActionState ignored) {
        LockPromise promise = this.lockPromise;
        if (promise != null && promise.isAvailable()) {
            this.cas(BaseLockingAction.InternalState.CHECKING, BaseLockingAction.InternalState.READY);
            return ActionStatus.READY;
        }
        return ActionStatus.NOT_READY;
    }

    @Override
    protected ActionStatus init(ActionState state) {
        if (!this.cas(BaseLockingAction.InternalState.INIT, BaseLockingAction.InternalState.CHECKING)) {
            return ActionStatus.NOT_READY;
        }
        Object lockOwner = this.getLockOwner(state);
        long timeout = state.getTimeout();
        List<Object> keysToLock = this.getAndUpdateFilteredKeys(state);
        if (keysToLock.isEmpty()) {
            return this.cas(BaseLockingAction.InternalState.CHECKING, BaseLockingAction.InternalState.READY) ? ActionStatus.READY : ActionStatus.NOT_READY;
        }
        TxInvocationContext<?> context = this.createContext(state);
        if (context != null) {
            keysToLock.forEach(context::addLockedKey);
        }
        KeyAwareLockPromise promise = keysToLock.size() == 1 ? this.lockManager.lock(keysToLock.get(0), lockOwner, timeout, TimeUnit.MILLISECONDS) : this.lockManager.lockAll(keysToLock, lockOwner, timeout, TimeUnit.MILLISECONDS);
        this.lockPromise = promise;
        if (!promise.isAvailable()) {
            promise.addListener(this);
        }
        return this.check(state);
    }

    private Object getLockOwner(ActionState state) {
        RemoteLockCommand command = (RemoteLockCommand)state.getCommand();
        return command instanceof TransactionalRemoteLockCommand ? ((TransactionalRemoteLockCommand)command).createContext().getLockOwner() : command.getKeyLockOwner();
    }

    @Override
    public void addListener(ActionListener listener) {
        if (this.notifier.isDone()) {
            listener.onComplete();
        } else {
            this.notifier.thenRun(listener::onComplete);
        }
    }

    @Override
    public void onException(ActionState state) {
        Object lockOwner = this.getLockOwner(state);
        List<Object> keysToLock = this.getAndUpdateFilteredKeys(state);
        this.lockManager.unlockAll(keysToLock, lockOwner);
    }

    @Override
    public void onEvent(LockState state) {
        this.notifier.complete(null);
    }

    private TxInvocationContext<?> createContext(ActionState state) {
        RemoteLockCommand command = (RemoteLockCommand)state.getCommand();
        if (command instanceof TransactionalRemoteLockCommand) {
            return ((TransactionalRemoteLockCommand)command).createContext();
        }
        return null;
    }
}

