/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.remoting.transport.jgroups.FileJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;

public class BuiltinJGroupsChannelConfigurator
extends FileJGroupsChannelConfigurator {
    public static BuiltinJGroupsChannelConfigurator TCP(Properties properties) {
        return BuiltinJGroupsChannelConfigurator.loadBuiltIn("tcp", "default-configs/default-jgroups-tcp.xml", properties);
    }

    public static BuiltinJGroupsChannelConfigurator UDP(Properties properties) {
        return BuiltinJGroupsChannelConfigurator.loadBuiltIn("udp", "default-configs/default-jgroups-udp.xml", properties);
    }

    private static BuiltinJGroupsChannelConfigurator loadBuiltIn(String name, String path, Properties properties) {
        BuiltinJGroupsChannelConfigurator builtinJGroupsChannelConfigurator;
        block8: {
            InputStream xml = FileLookupFactory.newInstance().lookupFileStrict(path, BuiltinJGroupsChannelConfigurator.class.getClassLoader());
            try {
                builtinJGroupsChannelConfigurator = new BuiltinJGroupsChannelConfigurator(name, path, xml, properties);
                if (xml == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (xml != null) {
                        try {
                            xml.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw JGroupsTransport.log.jgroupsConfigurationNotFound(path);
                }
            }
            xml.close();
        }
        return builtinJGroupsChannelConfigurator;
    }

    BuiltinJGroupsChannelConfigurator(String name, String path, InputStream is, Properties properties) throws IOException {
        super(name, path, is, properties);
    }
}

