/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import java.security.Principal;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.PrincipalRoleMapperContext;

public class ClusterRoleMapper
implements PrincipalRoleMapper {
    private EmbeddedCacheManager cacheManager;
    private static final String CLUSTER_ROLE_MAPPER_CACHE = "___cluster_role_mapper";
    private Cache<String, Set<String>> clusterRoleMap;

    private Cache<String, Set<String>> getClusterRoleMap() {
        if (this.clusterRoleMap == null && this.cacheManager != null) {
            this.clusterRoleMap = this.cacheManager.getCache(CLUSTER_ROLE_MAPPER_CACHE);
        }
        return this.clusterRoleMap;
    }

    @Override
    public Set<String> principalToRoles(Principal principal) {
        if (this.getClusterRoleMap() != null) {
            return (Set)this.clusterRoleMap.get(principal.getName());
        }
        return Collections.singleton(principal.getName());
    }

    @Override
    public void setContext(PrincipalRoleMapperContext context) {
        this.cacheManager = context.getCacheManager();
        GlobalConfiguration globalConfiguration = this.cacheManager.getGlobalComponentRegistry().getGlobalConfiguration();
        CacheMode cacheMode = globalConfiguration.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL;
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.clustering().cacheMode(cacheMode).stateTransfer().fetchInMemoryState(true).awaitInitialTransfer(false).security().authorization().disable();
        InternalCacheRegistry internalCacheRegistry = this.cacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        internalCacheRegistry.registerInternalCache(CLUSTER_ROLE_MAPPER_CACHE, cfg.build(), EnumSet.of(InternalCacheRegistry.Flag.PERSISTENT));
    }

    public void grant(String roleName, String principalName) {
        Set<String> roleSet = this.getClusterRoleMap().computeIfAbsent(principalName, n -> new HashSet());
        roleSet.add(roleName);
        this.clusterRoleMap.put(principalName, roleSet);
    }

    public void deny(String roleName, String principalName) {
        Set<String> roleSet = this.getClusterRoleMap().computeIfAbsent(principalName, n -> new HashSet());
        roleSet.remove(roleName);
        this.clusterRoleMap.put(principalName, roleSet);
    }

    public Set<String> list(String principalName) {
        Set roleSet = (Set)this.getClusterRoleMap().get(principalName);
        if (roleSet != null) {
            return Collections.unmodifiableSet(roleSet);
        }
        return Collections.emptySet();
    }

    public String listAll() {
        StringBuilder sb = new StringBuilder();
        CloseableIterator closeableIterator = this.getClusterRoleMap().values().iterator();
        while (closeableIterator.hasNext()) {
            Set set = (Set)closeableIterator.next();
            sb.append(set.toString());
        }
        return sb.toString();
    }
}

