/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiConsumer;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletableFutures;

public class CompletionStages {
    private CompletionStages() {
    }

    public static AggregateCompletionStage<Void> aggregateCompletionStage() {
        return new VoidAggregateCompletionStage();
    }

    public static <R> AggregateCompletionStage<R> aggregateCompletionStage(R valueToReturn) {
        return new ValueAggregateCompletionStage(valueToReturn);
    }

    public static boolean isCompletedSuccessfully(CompletionStage<?> stage) {
        CompletableFuture<?> future = stage.toCompletableFuture();
        return future.isDone() && !future.isCompletedExceptionally();
    }

    public static <R> R join(CompletionStage<R> stage) {
        try {
            return CompletableFutures.await(stage.toCompletableFuture());
        }
        catch (ExecutionException e) {
            throw new CompletionException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new CompletionException(e);
        }
    }

    public static CompletionStage<Void> allOf(CompletionStage<Void> first, CompletionStage<Void> second) {
        if (!CompletionStages.isCompletedSuccessfully(first)) {
            if (CompletionStages.isCompletedSuccessfully(second)) {
                return first;
            }
            return CompletionStages.aggregateCompletionStage().dependsOn(first).dependsOn(second).freeze();
        }
        return second;
    }

    public static CompletionStage<Void> allOf(CompletionStage<?> ... stages) {
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (CompletionStage<?> stage : stages) {
            if (CompletionStages.isCompletedSuccessfully(stage)) continue;
            if (aggregateCompletionStage == null) {
                aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
            }
            aggregateCompletionStage.dependsOn(stage);
        }
        return aggregateCompletionStage != null ? aggregateCompletionStage.freeze() : CompletableFutures.completedNull();
    }

    private static abstract class AbstractAggregateCompletionStage<R>
    extends CompletableFuture<R>
    implements AggregateCompletionStage<R>,
    BiConsumer<Object, Throwable> {
        private static final AtomicIntegerFieldUpdater<AbstractAggregateCompletionStage> remainingUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractAggregateCompletionStage.class, "remaining");
        private volatile int remaining;
        private volatile boolean frozen = false;
        private volatile Throwable throwable;

        private AbstractAggregateCompletionStage() {
        }

        @Override
        public void accept(Object o, Throwable t) {
            if (t != null) {
                this.throwable = t;
            }
            if (remainingUpdater.decrementAndGet(this) == 0 && this.frozen) {
                this.complete();
            }
        }

        @Override
        public final AggregateCompletionStage<R> dependsOn(CompletionStage<?> stage) {
            Objects.requireNonNull(stage);
            if (this.frozen) {
                throw new IllegalStateException();
            }
            if (!CompletionStages.isCompletedSuccessfully(stage)) {
                remainingUpdater.incrementAndGet(this);
                stage.whenComplete(this);
            }
            return this;
        }

        @Override
        public final CompletionStage<R> freeze() {
            this.frozen = true;
            if (remainingUpdater.get(this) == 0) {
                this.complete();
            }
            return this;
        }

        private void complete() {
            Throwable t = this.throwable;
            if (t != null) {
                this.completeExceptionally(t);
            } else {
                this.complete(this.getValue());
            }
        }

        abstract R getValue();
    }

    private static class ValueAggregateCompletionStage<R>
    extends AbstractAggregateCompletionStage<R> {
        private final R value;

        private ValueAggregateCompletionStage(R value) {
            this.value = value;
        }

        @Override
        R getValue() {
            return this.value;
        }
    }

    private static class VoidAggregateCompletionStage
    extends AbstractAggregateCompletionStage<Void> {
        private VoidAggregateCompletionStage() {
        }

        @Override
        Void getValue() {
            return null;
        }
    }
}

